/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.oracle.plan.OraRawPlanData;
import com.intellij.database.plan.MetaNode;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraPlanModelBuilder
extends AbstractPlanModelBuilder<OraRawPlanData, MetaNode<OraRawPlanData.MetaData>> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> SUB_MAPPING = new HashMap<Pair<PlanModel.NodeType, String>, PlanModel.NodeType>();

    public OraPlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.STARTUP_COST));
    }

    @NotNull
    public OraRawPlanData createData() {
        return new OraRawPlanData();
    }

    protected void parseData() {
        this.parseModel(((OraRawPlanData)this.myData).plan);
    }

    @NotNull
    protected String getRawData() {
        String string = ((OraRawPlanData)this.myData).dump();
        if (string == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean hasRawData() {
        return true;
    }

    private void parseModel(@NotNull MetaNode<OraRawPlanData.MetaData> root) throws PlanRetrievalException {
        if (root == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(1);
        }
        this.openNode(null);
        this.parseStatement(root);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @NotNull
    protected String parseRawDescription(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder();
        if (((OraRawPlanData.MetaData)element.data).cpuCost != null) {
            sb.append("cpu_cost = ").append(((OraRawPlanData.MetaData)element.data).cpuCost).append(System.lineSeparator());
        }
        if (((OraRawPlanData.MetaData)element.data).ioCost != null) {
            sb.append("io_cost = ").append(((OraRawPlanData.MetaData)element.data).ioCost).append(System.lineSeparator());
        }
        if (((OraRawPlanData.MetaData)element.data).bytes != null) {
            sb.append("bytes = ").append(((OraRawPlanData.MetaData)element.data).bytes).append(System.lineSeparator());
        }
        if (((OraRawPlanData.MetaData)element.data).time != null) {
            sb.append("time = ").append(OraPlanModelBuilder.formatSeconds(((OraRawPlanData.MetaData)element.data).time)).append(System.lineSeparator());
        }
        if (((OraRawPlanData.MetaData)element.data).accessPredicates != null && !((OraRawPlanData.MetaData)element.data).accessPredicates.isEmpty()) {
            sb.append("access_predicates = ").append(((OraRawPlanData.MetaData)element.data).accessPredicates).append(System.lineSeparator());
        }
        if (((OraRawPlanData.MetaData)element.data).filterPredicates != null && !((OraRawPlanData.MetaData)element.data).filterPredicates.isEmpty()) {
            sb.append("filter_predicates = ").append(((OraRawPlanData.MetaData)element.data).filterPredicates).append(System.lineSeparator());
        }
        String string = sb.toString();
        if (string == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String formatSeconds(@NotNull BigDecimal secondsValue) {
        if (secondsValue == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(4);
        }
        if (secondsValue.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
            String string = secondsValue.toPlainString();
            if (string == null) {
                OraPlanModelBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }
        long totalSeconds = secondsValue.longValue();
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        String string = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        if (string == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(7);
        }
        return ((OraRawPlanData.MetaData)element.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((OraRawPlanData.MetaData)element.data).objectType, (String)"table") ? ((OraRawPlanData.MetaData)element.data).objectName : null;
    }

    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(8);
        }
        return ((OraRawPlanData.MetaData)element.data).cardinality;
    }

    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return ((OraRawPlanData.MetaData)element.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((OraRawPlanData.MetaData)element.data).objectType, (String)"index") ? ((OraRawPlanData.MetaData)element.data).objectName : null;
    }

    protected void parsePlan(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(10);
        }
        this.openNode(null);
        this.parseSubPlans(element);
        PlanModel.NodeType nodeType = TYPE_MAPPING.get(((OraRawPlanData.MetaData)element.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.UNKNOWN;
        }
        nodeType = (PlanModel.NodeType)ObjectUtils.chooseNotNull((Object)SUB_MAPPING.get(Pair.create((Object)nodeType, (Object)((OraRawPlanData.MetaData)element.data).options)), (Object)nodeType);
        String title = StringUtil.notNullize((String)((OraRawPlanData.MetaData)element.data).operation) + (String)(StringUtil.isEmpty((String)((OraRawPlanData.MetaData)element.data).options) ? "" : " " + ((OraRawPlanData.MetaData)element.data).options);
        PlanModel.GenericNode node = this.createNode(element, nodeType, title);
        this.closeNode(node);
    }

    protected void parseSubPlans(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(11);
        }
        for (MetaNode child : element.children) {
            this.parsePlan((MetaNode<OraRawPlanData.MetaData>)child);
        }
    }

    protected void parseStatement(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(12);
        }
        this.openNode(null);
        PlanModel.NodeType nodeType = STATEMENT_MAPPING.get(((OraRawPlanData.MetaData)element.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.STATEMENT;
        }
        PlanModel.GenericNode node = this.createNode(element, nodeType, nodeType == PlanModel.NodeType.STATEMENT ? ((OraRawPlanData.MetaData)element.data).operation : null);
        this.parseSubPlans(element);
        this.closeNode(node);
    }

    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return ((OraRawPlanData.MetaData)element.data).cost == null ? null : Double.valueOf(((OraRawPlanData.MetaData)element.data).cost.doubleValue());
    }

    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return null;
    }

    protected boolean parseSubqueryCorrelated(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    protected boolean parseSubqueryScalar(@NotNull MetaNode<OraRawPlanData.MetaData> element) {
        if (element == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(16);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("AND-EQUAL", PlanModel.NodeType.SET_OP);
        TYPE_MAPPING.put("BITMAP", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("CONNECT BY", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("CONCATENATION", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("COUNT", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("DOMAIN INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("FIRST ROW", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("FOR UPDATE", PlanModel.NodeType.LOCK_ROWS);
        TYPE_MAPPING.put("HASH", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HASH JOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("INLIST ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("INTERSECTION", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("LOAD AS SELECT", PlanModel.NodeType.DIRECT_LOAD);
        TYPE_MAPPING.put("MERGE JOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("MAT_VIEW REWRITE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("MINUS", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("NESTED LOOPS", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX COORDINATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX RECEIVE", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX SEND", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("REMOTE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SEQUENCE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TABLE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("TEMP TABLE TRANSFORMATION", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("UNION-ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("VIEW", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("FAST DUAL", PlanModel.NodeType.VALUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"FULL"), PlanModel.NodeType.SEQ_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"SAMPLE BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"BY USER ROWID"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"BY INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"BY GLOBAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.ACCESS, (Object)"BY LOCAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.INDEX_SCAN, (Object)"UNIQUE SCAN"), PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.INDEX_SCAN, (Object)"FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.INDEX_SCAN, (Object)"FULL SCAN DESCENDING"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.INDEX_SCAN, (Object)"FAST FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.SORT, (Object)"UNIQUE"), PlanModel.NodeType.SORT_UNIQUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.SORT, (Object)"GROUP BY"), PlanModel.NodeType.GROUP_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.SORT, (Object)"ORDER BY"), PlanModel.NodeType.ORDER_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.UNKNOWN, (Object)"SORT"), PlanModel.NodeType.SORT);
        STATEMENT_MAPPING.put("SELECT STATEMENT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("INSERT STATEMENT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE STATEMENT", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE STATEMENT", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OraPlanModelBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondsValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawData";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OraPlanModelBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSeconds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatSeconds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

