/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k1.scriptingSupport;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileEditorExtensionsKt;
import com.intellij.kotlin.jupyter.core.scriptingSupport.IndexAwareScriptDefinitionsLoadRequestor;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerPerFileService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.listeners.ScriptingSupportUpdateEventsListener;
import com.intellij.kotlin.jupyter.core.scriptingSupport.listeners.ScriptingSupportUpdateEventsListenerKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.ScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u0011*\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport;", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/ScriptingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "compilerService", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/JupyterCompilerService;", "editorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "getEditorManager", "()Lcom/intellij/openapi/fileEditor/FileEditorManager;", "indexAwareScriptDefinitionsRequestor", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/IndexAwareScriptDefinitionsLoadRequestor;", "scriptingSupportPublisher", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/listeners/ScriptingSupportUpdateEventsListener;", "afterUpdate", "", "onUpdateException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onTrivialUpdate", "collectConfigurations", "builder", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;", "getConfigurationImmediately", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "isConfigurationLoadingInProgress", "Lorg/jetbrains/kotlin/psi/KtFile;", "addRootsFromNotebooks", "notebooks", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Companion", "intellij.kotlin.jupyter.k1"})
@SourceDebugExtension(value={"SMAP\nJupyterKtScriptingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n12033#2,10:131\n14060#2:141\n14061#2:143\n12043#2:144\n1#3:142\n777#4:145\n873#4,2:146\n1586#4:148\n1661#4,3:149\n1586#4:152\n1661#4,3:153\n1915#4,2:156\n13#5:158\n*S KotlinDebug\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport\n*L\n62#1:131,10\n62#1:141\n62#1:143\n62#1:144\n62#1:142\n62#1:145\n62#1:146,2\n88#1:148\n88#1:149,3\n89#1:152\n89#1:153,3\n93#1:156,2\n103#1:158\n*E\n"})
public final class JupyterKtScriptingSupport
implements ScriptingSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterCompilerService compilerService;
    @NotNull
    private final IndexAwareScriptDefinitionsLoadRequestor indexAwareScriptDefinitionsRequestor;
    @NotNull
    private final ScriptingSupportUpdateEventsListener scriptingSupportPublisher;
    @NotNull
    private static final Logger LOG;

    public JupyterKtScriptingSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.compilerService = JupyterCompilerService.Companion.getInstance(this.project);
        this.indexAwareScriptDefinitionsRequestor = new IndexAwareScriptDefinitionsLoadRequestor(this.project);
        this.scriptingSupportPublisher = (ScriptingSupportUpdateEventsListener)this.project.getMessageBus().syncPublisher(ScriptingSupportUpdateEventsListenerKt.getSCRIPTING_SUPPORT_TOPIC());
    }

    private final FileEditorManager getEditorManager() {
        return FileEditorManager.getInstance((Project)this.project);
    }

    public void afterUpdate() {
        try {
            ScriptingSupportUpdateEventsListener.afterUpdate$default((ScriptingSupportUpdateEventsListener)this.scriptingSupportPublisher, null, (int)1, null);
            this.indexAwareScriptDefinitionsRequestor.reloadDefinitions();
        }
        catch (Exception ex) {
            if (ex instanceof ProcessCanceledException) {
                this.indexAwareScriptDefinitionsRequestor.reloadDefinitions();
            }
            LOG.warn("Post-update: error occurred during reloading of script configurations", (Throwable)ex);
        }
    }

    public void onUpdateException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.scriptingSupportPublisher.onUpdateException((Throwable)exception);
    }

    public void onTrivialUpdate() {
        this.scriptingSupportPublisher.onTrivialUpdate();
    }

    /*
     * WARNING - void declaration
     */
    public void collectConfigurations(@NotNull ScriptClassRootsBuilder builder) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        FileEditor[] editors;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        FileEditor[] fileEditorArray = this.getEditorManager();
        if (fileEditorArray == null || (fileEditorArray = fileEditorArray.getAllEditors()) == null) {
            return;
        }
        Object $this$mapNotNull$iv = editors = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        FileEditor[] fileEditorArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            BackedNotebookVirtualFile it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            if ((v1 != null ? JupyterFileEditorExtensionsKt.getNotebookFileOrNull((FileEditor)v1) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BackedNotebookVirtualFile it = (BackedNotebookVirtualFile)element$iv$iv;
            boolean bl = false;
            if (!IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)it.getFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notebookFiles = (List)destination$iv$iv;
        this.addRootsFromNotebooks(builder, notebookFiles);
    }

    @Nullable
    public ScriptCompilationConfigurationWrapper getConfigurationImmediately(@NotNull VirtualFile file) {
        ScriptCompilationConfigurationWrapper conf;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof VirtualFileWindow)) {
            return null;
        }
        PsiFile psiFile = UtilKt.findPsiFile((VirtualFile)file, (Project)this.project);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            return null;
        }
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics = Companion.getDefaultConfiguration((KtFile)psiFile2);
        Object object = conf = resultWithDiagnostics != null ? (ScriptCompilationConfigurationWrapper)ErrorHandlingKt.valueOrNull(resultWithDiagnostics) : null;
        if (conf == null) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment(((KtFile)psiFile2).getName(), ((KtFile)psiFile2).getText())};
            LoggingKt.errorWithAttachments((Logger)LOG, (String)"Can't retrieve fast configuration", (Attachment[])attachmentArray);
        }
        return conf;
    }

    public boolean isApplicable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)this.compilerService.getFileSuffix(), (boolean)false, (int)2, null);
    }

    public boolean isConfigurationLoadingInProgress(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JupyterKtScriptingSupport.Companion.getUpdater(this.project).isTransactionAboutToHappen();
    }

    private final void addRootsFromNotebooks(ScriptClassRootsBuilder $this$addRootsFromNotebooks, Collection<? extends BackedNotebookVirtualFile> notebooks) {
        for (BackedNotebookVirtualFile backedNotebookVirtualFile : notebooks) {
            Path it;
            boolean bl;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JupyterCompilerPerFileService notebookService = JupyterCompilerService.Companion.getForFile($this$addRootsFromNotebooks.getProject(), backedNotebookVirtualFile);
            Iterable iterable = notebookService.getCurrentClasspath();
            ScriptClassRootsBuilder scriptClassRootsBuilder = $this$addRootsFromNotebooks;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add(((Object)it.toAbsolutePath()).toString());
            }
            scriptClassRootsBuilder.addTemplateClassesRoots((Collection)((List)destination$iv$iv));
            $this$map$iv = notebookService.getCurrentSourceRoots();
            scriptClassRootsBuilder = $this$addRootsFromNotebooks;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Path)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add(((Object)it.toAbsolutePath()).toString());
            }
            scriptClassRootsBuilder.addSources((Collection)((List)destination$iv$iv));
            $this$addRootsFromNotebooks.warnAboutDependenciesExistence(false);
            try {
                Iterable $this$forEach$iv = notebookService.scripts();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    VirtualFile file = (VirtualFile)pair.component1();
                    ScriptCompilationConfigurationWrapper conf = (ScriptCompilationConfigurationWrapper)pair.component2();
                    $this$addRootsFromNotebooks.add(file, conf);
                }
            }
            catch (Throwable e) {
                if (e instanceof ProcessCanceledException) {
                    throw e;
                }
                LOG.error("Notebook injected scripts can't be obtained. Notebook: [" + backedNotebookVirtualFile + "]", e);
            }
            $this$addRootsFromNotebooks.warnAboutDependenciesExistence(true);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JupyterKtScriptingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getUpdater", "Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "updateSynchronously", "", "getDefaultConfiguration", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.jupyter.k1"})
    @SourceDebugExtension(value={"SMAP\nJupyterKtScriptingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion\n+ 2 ScriptClassRootsUpdater.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,130:1\n157#2,5:131\n137#3:136\n*S KotlinDebug\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion\n*L\n109#1:131,5\n116#1:136\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ScriptClassRootsUpdater getUpdater(Project project) {
            return ScriptConfigurationManager.Companion.getInstance(project).getUpdater();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void updateSynchronously(@NotNull Project project) {
            ScriptClassRootsUpdater updater;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ScriptClassRootsUpdater this_$iv = updater = this.getUpdater(project);
            boolean $i$f$update = false;
            try {
                boolean bl = false;
                updater.invalidate(true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.commit();
            }
        }

        @Nullable
        public final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getDefaultConfiguration(@NotNull KtFile psiFile) {
            VirtualFileWindow virtualFile;
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile $this$safeAs$iv = virtualFile2;
                boolean $i$f$safeAs = false;
                VirtualFile virtualFile3 = $this$safeAs$iv;
                if (!(virtualFile3 instanceof VirtualFileWindow)) {
                    virtualFile3 = null;
                }
                v2 = (VirtualFileWindow)virtualFile3;
            } else {
                v2 = virtualFile = null;
            }
            if (virtualFile == null) {
                LOG.error("Can't retrieve virtual file window for " + psiFile);
                return null;
            }
            VirtualFile virtualFile4 = virtualFile.getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getDelegate(...)");
            VirtualFile notebookVirtualFile = virtualFile4;
            BackedNotebookVirtualFile notebookFile = UtilKt.toBackedNotebookFile((VirtualFile)notebookVirtualFile);
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JupyterCompilerPerFileService compilerService = JupyterCompilerService.Companion.getForFile(project, notebookFile);
            KtFileScriptSource sourceCode = new KtFileScriptSource(psiFile, null, 2, null);
            return compilerService.provideDefaultConfiguration((SourceCode)sourceCode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

