/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ModulesWithDependencies;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.util.graph.Graph;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/plugins/ModuleGraph;", "Lcom/intellij/util/graph/Graph;", "Lcom/intellij/ide/plugins/PluginModuleDescriptor;", "modulesWithDependencies", "Lcom/intellij/ide/plugins/ModulesWithDependencies;", "additionalEdges", "Ljava/util/IdentityHashMap;", "", "<init>", "(Lcom/intellij/ide/plugins/ModulesWithDependencies;Ljava/util/IdentityHashMap;)V", "nodes", "directDependencies", "directDependents", "Ljava/util/ArrayList;", "getNodes", "", "getDependencies", "descriptor", "getIn", "", "getOut", "intellij.platform.core.impl"})
public final class ModuleGraph
implements Graph<PluginModuleDescriptor> {
    @NotNull
    private final List<PluginModuleDescriptor> nodes;
    @NotNull
    private final IdentityHashMap<PluginModuleDescriptor, List<PluginModuleDescriptor>> directDependencies;
    @NotNull
    private final IdentityHashMap<PluginModuleDescriptor, ArrayList<PluginModuleDescriptor>> directDependents;

    public ModuleGraph(@NotNull ModulesWithDependencies modulesWithDependencies, @NotNull IdentityHashMap<PluginModuleDescriptor, List<PluginModuleDescriptor>> additionalEdges) {
        Intrinsics.checkNotNullParameter((Object)modulesWithDependencies, (String)"modulesWithDependencies");
        Intrinsics.checkNotNullParameter(additionalEdges, (String)"additionalEdges");
        this.nodes = modulesWithDependencies.modules;
        this.directDependencies = new IdentityHashMap(modulesWithDependencies.modules.size());
        this.directDependents = new IdentityHashMap(modulesWithDependencies.modules.size());
        for (PluginModuleDescriptor module : modulesWithDependencies.modules) {
            List merged;
            List list;
            List dependencies = modulesWithDependencies.directDependencies.get(module);
            List additional = additionalEdges.get(module);
            if (dependencies != null && additional != null) {
                list = CollectionsKt.plus((Collection)additional, (Iterable)dependencies);
            } else {
                list = dependencies;
                if (list == null && (list = additional) == null) {
                    list = null;
                }
            }
            if ((merged = list) == null) continue;
            ((Map)this.directDependencies).put(module, merged);
        }
        HashSet<AbstractMap.SimpleImmutableEntry<PluginModuleDescriptor, PluginModuleDescriptor>> edges = new HashSet<AbstractMap.SimpleImmutableEntry<PluginModuleDescriptor, PluginModuleDescriptor>>();
        for (PluginModuleDescriptor module : modulesWithDependencies.modules) {
            for (PluginModuleDescriptor inNode : this.directDependencies.getOrDefault(module, Collections.emptyList())) {
                if (!edges.add(new AbstractMap.SimpleImmutableEntry<PluginModuleDescriptor, PluginModuleDescriptor>(inNode, module))) continue;
                this.directDependents.computeIfAbsent(inNode, arg_0 -> ModuleGraph._init_$lambda$1(ModuleGraph::_init_$lambda$0, arg_0)).add(module);
            }
        }
    }

    @NotNull
    public Collection<PluginModuleDescriptor> getNodes() {
        return this.nodes;
    }

    private final Collection<PluginModuleDescriptor> getDependencies(PluginModuleDescriptor descriptor) {
        List list = this.directDependencies.getOrDefault(descriptor, Collections.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOrDefault(...)");
        return list;
    }

    @NotNull
    public Iterator<PluginModuleDescriptor> getIn(@NotNull PluginModuleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.getDependencies(descriptor).iterator();
    }

    @NotNull
    public Iterator<PluginModuleDescriptor> getOut(@NotNull PluginModuleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return ((Map)this.directDependents).getOrDefault(descriptor, Collections.emptyList()).iterator();
    }

    private static final ArrayList _init_$lambda$0(PluginModuleDescriptor it) {
        return new ArrayList();
    }

    private static final ArrayList _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (ArrayList)$tmp0.invoke(p0);
    }
}

