/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.parser.CronParser;
import com.intellij.DynamicBundle;
import com.intellij.cron.CronBundle;
import com.intellij.cron.CronExpLanguage;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.cron.DefaultCronExpressionProvider;
import com.intellij.cron.InvalidCronExpression;
import com.intellij.cron.psi.CronExpFile;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"CRON_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/cron/CronExpressionProvider;", "getCRON_EP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "DEFAULT_CRON_EXPRESSION_PROVIDER", "Lcom/intellij/cron/DefaultCronExpressionProvider;", "getDEFAULT_CRON_EXPRESSION_PROVIDER", "()Lcom/intellij/cron/DefaultCronExpressionProvider;", "getCronExplanationSilent", "", "provider", "element", "Lcom/intellij/psi/PsiElement;", "getCronExplanationWithDescriptor", "cronExpr", "cronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "getCronExplanation", "getCronInjection", "Lcom/intellij/cron/psi/CronExpFile;", "getCronExpressionProvider", "getCronExpressionForElement", "cronProvider", "intellij.cron"})
@SourceDebugExtension(value={"SMAP\ncronUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 cronUtils.kt\ncom/intellij/cron/CronUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n296#2,2:82\n*S KotlinDebug\n*F\n+ 1 cronUtils.kt\ncom/intellij/cron/CronUtilsKt\n*L\n58#1:82,2\n*E\n"})
public final class CronUtilsKt {
    @ApiStatus.Internal
    @NotNull
    private static final ExtensionPointName<CronExpressionProvider> CRON_EP_NAME = ExtensionPointName.Companion.create("com.intellij.cron.cronExpressionProvider");
    @NotNull
    private static final DefaultCronExpressionProvider DEFAULT_CRON_EXPRESSION_PROVIDER = new DefaultCronExpressionProvider();

    @NotNull
    public static final ExtensionPointName<CronExpressionProvider> getCRON_EP_NAME() {
        return CRON_EP_NAME;
    }

    @NotNull
    public static final DefaultCronExpressionProvider getDEFAULT_CRON_EXPRESSION_PROVIDER() {
        return DEFAULT_CRON_EXPRESSION_PROVIDER;
    }

    @Nullable
    public static final String getCronExplanationSilent(@NotNull CronExpressionProvider provider, @NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CronExpressionProvider $this$getCronExplanationSilent_u24lambda_u240 = provider;
        boolean bl = false;
        try {
            String string2;
            String string3 = CronUtilsKt.getCronExpressionForElement(provider, element);
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                string2 = $this$getCronExplanationSilent_u24lambda_u240.getCronExplanation(it, element);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (InvalidCronExpression e) {
            Logger.getInstance((String)"com.intellij.cron.cronExpressionProvider").debug("Unable to parse cron expression", (Throwable)e);
            return null;
        }
        return string;
    }

    @Nullable
    public static final String getCronExplanationWithDescriptor(@NotNull String cronExpr, @NotNull CronDefinition cronDefinition) throws InvalidCronExpression {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        Intrinsics.checkNotNullParameter((Object)cronDefinition, (String)"cronDefinition");
        if (Intrinsics.areEqual((Object)cronExpr, (Object)"")) {
            return cronExpr;
        }
        try {
            Cron cron = new CronParser(cronDefinition).parse(cronExpr);
            return CronDescriptor.instance((Locale)DynamicBundle.getLocale()).describe(cron);
        }
        catch (IllegalArgumentException iae) {
            String string = iae.getMessage();
            if (string == null) {
                string = CronBundle.INSTANCE.message("cron.parser.error", new Object[0]);
            }
            throw new InvalidCronExpression(cronExpr, string, iae);
        }
        catch (Exception e) {
            Logger.getInstance((String)"com.intellij.cron.cronExpressionProvider").debug("Unable to parse cron expression \"" + cronExpr + "\"", (Throwable)e);
            throw new InvalidCronExpression(cronExpr, CronBundle.INSTANCE.message("cron.parser.error", new Object[0]), e);
        }
    }

    @Nullable
    public static final String getCronExplanation(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CronExpressionProvider cronExpressionProvider = CronUtilsKt.getCronExpressionProvider(element);
        if (cronExpressionProvider == null) {
            return null;
        }
        CronExpressionProvider cronProvider = cronExpressionProvider;
        return CronUtilsKt.getCronExplanationSilent(cronProvider, element);
    }

    @Nullable
    public static final CronExpFile getCronInjection(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof CronExpFile ? (CronExpFile)psiFile : null;
    }

    @Nullable
    public static final CronExpressionProvider getCronExpressionProvider(@NotNull PsiElement element) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            Iterable $this$firstOrNull$iv = CRON_EP_NAME.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CronExpressionProvider it = (CronExpressionProvider)element$iv;
                boolean bl = false;
                PsiLanguageInjectionHost psiLanguageInjectionHost = languageManager.getInjectionHost(element);
                PsiElement host = psiLanguageInjectionHost != null ? (PsiElement)psiLanguageInjectionHost : element;
                if (!(it.getLanguages().contains(host.getLanguage()) && it.isSuitableElement(host))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        CronExpressionProvider suitableProvider = v1;
        if (suitableProvider == null && Registry.Companion.is("com.intellij.cron.enableDefaultProvider") && CronUtilsKt.getCronInjection(element) != null) {
            return DEFAULT_CRON_EXPRESSION_PROVIDER;
        }
        return suitableProvider;
    }

    @Nullable
    public static final String getCronExpressionForElement(@NotNull CronExpressionProvider cronProvider, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronProvider, (String)"cronProvider");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof CronExpFile) {
            return ((CronExpFile)element).getText();
        }
        if (element.getLanguage() instanceof CronExpLanguage) {
            return element.getContainingFile().getText();
        }
        return cronProvider.getCronExpression(element);
    }
}

