/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.highlighting.jam.SpringSelfInvocationMethodCallsInspection;
import com.intellij.spring.security.SpringSecurityBundle;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringSecurityMethodCallsInspection
extends SpringSelfInvocationMethodCallsInspection {
    @NonNls
    protected Collection<String> getAnnotations() {
        return Arrays.asList("org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PostFilter");
    }

    @NotNull
    @Nls
    protected String getProblemMessage(@NotNull PsiMethod annotatedMethod) {
        String name;
        if (annotatedMethod == null) {
            SpringSecurityMethodCallsInspection.$$$reportNull$$$0(0);
        }
        if ((name = this.getAnnotationName(annotatedMethod)) != null) {
            String string = SpringSecurityBundle.message("spring.pre.filter.self.method.calls", StringUtil.getShortName((String)name));
            if (string == null) {
                SpringSecurityMethodCallsInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = SpringSecurityBundle.message("spring.meta.filter.self.method.calls", new Object[0]);
        if (string == null) {
            SpringSecurityMethodCallsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private String getAnnotationName(@NotNull PsiMethod annotatedMethod) {
        PsiAnnotation annotation;
        if (annotatedMethod == null) {
            SpringSecurityMethodCallsInspection.$$$reportNull$$$0(3);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)annotatedMethod, this.getAnnotations())) != null ? annotation.getQualifiedName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatedMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/inspections/SpringSecurityMethodCallsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/inspections/SpringSecurityMethodCallsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProblemMessage";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

