/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.dbdrivers;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.jpa.jpb.model.backend.ds.DbDriversManagerExtension;
import com.intellij.jpa.jpb.model.config.DbDriver;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.UnknownType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.jpa.jpb.model.service.DataStoreManagerExtension;
import com.intellij.jpa.jpb.model.util.DbUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.xmlpull.v1.XmlPullParser;

@Deprecated(message="All JPA Buddy's functionality to connect to DB will be deleted. Use only DataGrid's features.")
@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 G2\u00020\u0001:\u0004GHIJB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\u001d\u001a\u00020\u001eJ1\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001cJ\u0010\u0010)\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001cJ\u000e\u0010*\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0010H\u0002J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0010002\u0006\u0010.\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'H\u0002J\"\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u00107\u001a\u00020\u00102\u0006\u0010,\u001a\u00020'2\u0006\u00101\u001a\u00020\u0017H\u0002J\u001a\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u00108\u001a\u00020\u00102\u0006\u0010,\u001a\u00020'H\u0002J \u00109\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\rH\u0002J\u0010\u0010<\u001a\u0002032\u0006\u0010:\u001a\u00020\u0010H\u0002J\u0016\u0010=\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00102\u0006\u0010,\u001a\u00020'J\u000e\u0010>\u001a\u0002032\u0006\u0010,\u001a\u00020'J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010@\u001a\u00020AJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010,\u001a\u00020'H\u0002J\u0010\u0010C\u001a\u0004\u0018\u00010\u00062\u0006\u0010D\u001a\u00020\rJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000600J\b\u0010F\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "artifacts", "", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Artifact;", "myDefaultRepositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "reloadArtifacts", "", "loadRemoteArtifactsSource", "", "loadCachedLocalArtifact", "localArtifactListPath", "Ljava/io/File;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "readArtifact", "readArtifactVersion", "artifact", "readItem", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item;", "downloadDriversAndSaveState", "project", "Lcom/intellij/openapi/project/Project;", "dbTypes", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "successCallback", "Ljava/lang/Runnable;", "loadDriverAndRunAction", "dbProperties", "", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "action", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;Lkotlin/jvm/functions/Function0;)V", "downloadLastArtifact", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$ArtifactVersion;", "dbType", "getLatestArtifactVersion", "getLatest", "downloadArtifact", "version", "downloadMavenItems", "artifactDir", "resolveMavenItem", "", "item", "download", "", "getRepositories", "unpackZippedItems", "unpackZipIfNeeded", "dir", "archive", "extractLibrary", "out", "name", "isExtracted", "getUnpackPath", "isAllDownloaded", "getExistsClasspathElements", "driver", "Lcom/intellij/jpa/jpb/model/config/DbDriver;", "getClasspathElements", "findArtifactByDriverClass", "id", "getArtifacts", "dispose", "Companion", "Artifact", "ArtifactVersion", "Item", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDatabaseArtifactsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseArtifactsManager.kt\ncom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,548:1\n1807#2,3:549\n1642#2,10:553\n1915#2:563\n1916#2:565\n1652#2:566\n777#2:567\n873#2,2:568\n1915#2,2:570\n1786#2,2:572\n1786#2,3:574\n1788#2:577\n1642#2,10:578\n1915#2:588\n1916#2:590\n1652#2:591\n1642#2,10:592\n1915#2:602\n1916#2:604\n1652#2:605\n1391#2:606\n1480#2,5:607\n1#3:552\n1#3:564\n1#3:589\n1#3:603\n13#4:612\n*S KotlinDebug\n*F\n+ 1 DatabaseArtifactsManager.kt\ncom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager\n*L\n192#1:549,3\n328#1:553,10\n328#1:563\n328#1:565\n328#1:566\n408#1:567\n408#1:568,2\n409#1:570,2\n459#1:572,2\n461#1:574,3\n459#1:577\n467#1:578,10\n467#1:588\n467#1:590\n467#1:591\n474#1:592,10\n474#1:602\n474#1:604\n474#1:605\n482#1:606\n482#1:607,5\n328#1:564\n467#1:589\n474#1:603\n56#1:612\n*E\n"})
public final class DatabaseArtifactsManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Artifact> artifacts = new LinkedHashSet();
    @Nullable
    private List<RemoteRepository> myDefaultRepositories;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static String ourDownloadPath;
    @NotNull
    private static final Map<String, String> artifactNameToDriverClass;

    private final void reloadArtifacts() {
        String source2;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        String string = JpaModelBundle.message("progress.loadDriversTitle", new Object[0]);
        String string2 = (String)progressManager2.run((Task.WithResult)new Task.WithResult<String, Exception>(this, string){
            final /* synthetic */ DatabaseArtifactsManager this$0;
            {
                this.this$0 = $receiver;
                super(null, $super_call_param$1, false);
            }

            protected String compute(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return DatabaseArtifactsManager.access$loadRemoteArtifactsSource(this.this$0);
            }
        });
        if (string2 == null) {
            return;
        }
        string = source2 = string2;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), StandardCharsets.UTF_8);
        this.reloadArtifacts((HierarchicalStreamReader)new XppReader((Reader)inputStreamReader, (XmlPullParser)new MXParser()));
    }

    private final String loadRemoteArtifactsSource() {
        File localArtifactListPath = DatabaseArtifactsManager.Companion.getLocalArtifactListPath();
        String string = this.loadCachedLocalArtifact(localArtifactListPath);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        CharSequence charSequence = serviceUrl;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String remoteUrl = serviceUrl + "/jdbc-drivers/jdbc-drivers.xml";
        try {
            String string2 = HttpRequests.request((String)remoteUrl).connectTimeout(10000).readString(ProgressIndicatorProvider.getGlobalProgressIndicator());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
            String jdbcDriversSource = string2;
            try {
                FileUtil.writeToFile((File)localArtifactListPath, (String)jdbcDriversSource);
            }
            catch (Exception e) {
                logger.warn("Failed write to local JDBC artifacts file", (Throwable)e);
            }
            return jdbcDriversSource;
        }
        catch (IOException var7) {
            logger.warn("Failed to load JDBC driver files information from " + remoteUrl + ".\nPlease check your internet connection.");
            if (localArtifactListPath.exists()) {
                try {
                    return FileUtil.loadFile((File)localArtifactListPath);
                }
                catch (Exception e) {
                    logger.warn("Failed to load local JDBC artifacts file", (Throwable)e);
                }
            }
            return null;
        }
    }

    private final String loadCachedLocalArtifact(File localArtifactListPath) {
        if (!localArtifactListPath.exists()) {
            return null;
        }
        try {
            BasicFileAttributes fileAttrs = Files.readAttributes(localArtifactListPath.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            long timeDiff = System.currentTimeMillis() - fileAttrs.creationTime().toMillis();
            if (timeDiff < 172800000L) {
                return FileUtil.loadFile((File)localArtifactListPath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final void reloadArtifacts(HierarchicalStreamReader reader) {
        this.artifacts.clear();
        if (!Intrinsics.areEqual((Object)"artifacts", (Object)reader.getNodeName())) {
            throw new IOException("Unexpected root: " + reader.getNodeName());
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String currNodeName = reader.getNodeName();
            if (Intrinsics.areEqual((Object)currNodeName, (Object)"artifact")) {
                this.readArtifact(reader);
            }
            reader.moveUp();
        }
    }

    private final void readArtifact(HierarchicalStreamReader reader) {
        String driverClass;
        boolean bl;
        String name;
        String id;
        block10: {
            id = reader.getAttribute("id");
            name = reader.getAttribute("name");
            if (id == null) {
                Intrinsics.checkNotNull((Object)name);
                CharSequence charSequence = name;
                Regex regex = new Regex("[^a-zA-Z0-9. _-]");
                String string = "";
                id = StringsKt.removeSuffix((String)regex.replace(charSequence, string), (CharSequence)" 8");
            }
            Iterable $this$any$iv = this.artifacts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Artifact it = (Artifact)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Intrinsics.checkNotNull((Object)name);
        Artifact artifact = new Artifact(id, name);
        if (reader.getAttribute("version") == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String versionNodeName = reader.getNodeName();
                if (Intrinsics.areEqual((Object)versionNodeName, (Object)"version")) {
                    this.readArtifactVersion(reader, artifact);
                }
                reader.moveUp();
            }
        } else {
            this.readArtifactVersion(reader, artifact);
        }
        if ((driverClass = artifactNameToDriverClass.get(artifact.getName())) != null) {
            artifact.setDriverClass(driverClass);
            this.artifacts.add(artifact);
        }
    }

    private final void readArtifactVersion(HierarchicalStreamReader reader, Artifact artifact) {
        String version = reader.getAttribute("version");
        ArrayList<Item> items2 = new ArrayList<Item>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (Intrinsics.areEqual((Object)"item", (Object)reader.getNodeName())) {
                if (this.readItem(reader) != null) {
                    Item it;
                    boolean bl = false;
                    items2.add(it);
                }
            }
            reader.moveUp();
        }
        Intrinsics.checkNotNull((Object)version);
        ArtifactVersion av = new ArtifactVersion(artifact, version, (List<Item>)items2);
        artifact.getVersions().add(av);
    }

    private final Item readItem(HierarchicalStreamReader reader) {
        Item.OS os;
        Object v0;
        String name;
        String url;
        block8: {
            url = reader.getAttribute("url");
            String typeName = reader.getAttribute("type");
            name = reader.getAttribute("name");
            if (name == null) {
                name = PathUtil.getFileName((String)url);
            }
            Iterable iterable = (Iterable)Item.Type.getEntries();
            for (Object object : iterable) {
                Item.Type o = (Item.Type)((Object)object);
                boolean bl = false;
                if (!StringsKt.equals((String)o.name(), (String)typeName, (boolean)true)) continue;
                v0 = object;
                break block8;
            }
            v0 = null;
        }
        Item.Type type = v0;
        if (type == null) {
            type = (StringsKt.startsWith$default((String)name, (String)"sqlserver", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"jtds", (boolean)false, (int)2, null)) && StringsKt.endsWith$default((String)name, (String)"win-auth.jar", (boolean)false, (int)2, null) ? Item.Type.NATIVE : Item.Type.JAR;
        }
        Intrinsics.checkNotNull((Object)url);
        if (!StringsKt.endsWith((String)url, (String)".jar", (boolean)true) && type != Item.Type.MAVEN) {
            return null;
        }
        String osName = reader.getAttribute("os");
        if (osName == null) {
            v1 = null;
        } else {
            Object v2;
            block9: {
                Object object;
                object = (Iterable)Item.OS.getEntries();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Item.OS o = (Item.OS)((Object)t);
                    boolean bl = false;
                    if (!StringsKt.equals((String)o.name(), (String)osName, (boolean)true)) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            v1 = os = (Item.OS)v2;
        }
        if (os == null) {
            os = StringsKt.contains$default((CharSequence)name, (CharSequence)"win", (boolean)false, (int)2, null) ? Item.OS.WIN : Item.OS.ANY;
        }
        return new Item(name, url, os, type);
    }

    public final void downloadDriversAndSaveState(@NotNull Project project, @NotNull List<? extends DbType> dbTypes, @NotNull Runnable successCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dbTypes, (String)"dbTypes");
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        DbDriversManagerExtension.Companion.getInstance().downloadDriversAndSaveState(project, dbTypes, successCallback);
    }

    public final void loadDriverAndRunAction(@NotNull Project project, @NotNull DbProperties[] dbProperties, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        DbDriversManager dbDriversManager = DbDriversManager.Companion.getInstance(project);
        List dbTypeWithoutDrivers = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)ArraysKt.asSequence((Object[])dbProperties)), DatabaseArtifactsManager::loadDriverAndRunAction$lambda$0), DatabaseArtifactsManager::loadDriverAndRunAction$lambda$1)), arg_0 -> DatabaseArtifactsManager.loadDriverAndRunAction$lambda$2(dbDriversManager, arg_0)));
        DataStoreManagerExtension.Companion.getInstance().applyInitialCredentials(project, dbProperties);
        if (dbTypeWithoutDrivers.isEmpty()) {
            action2.invoke();
        } else {
            this.downloadDriversAndSaveState(project, dbTypeWithoutDrivers, () -> DatabaseArtifactsManager.loadDriverAndRunAction$lambda$3(action2));
        }
    }

    @Nullable
    public final ArtifactVersion downloadLastArtifact(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        ArtifactVersion artifactVersion = this.getLatestArtifactVersion(dbType);
        if (artifactVersion == null) {
            return null;
        }
        ArtifactVersion latestVersion = artifactVersion;
        if (!this.isAllDownloaded(latestVersion)) {
            this.downloadArtifact(latestVersion);
        }
        return latestVersion;
    }

    @Nullable
    public final ArtifactVersion getLatestArtifactVersion(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.getDriverClass();
        if (string == null) {
            return null;
        }
        String driverClass = string;
        Artifact artifact = this.findArtifactByDriverClass(driverClass);
        if (artifact == null) {
            return null;
        }
        Artifact artifact2 = artifact;
        return this.getLatest(artifact2);
    }

    @NotNull
    public final ArtifactVersion getLatest(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return (ArtifactVersion)CollectionsKt.last((Iterable)artifact.getVersions());
    }

    /*
     * WARNING - void declaration
     */
    public final void downloadArtifact(@NotNull ArtifactVersion version) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        File artifactDir = Companion.getArtifactDir(version);
        Iterable $this$mapNotNull$iv = version.getItems();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DownloadableFileDescription it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Item it = (Item)element$iv$iv;
            boolean bl2 = false;
            if ((it.getOs().getApplicable() && it.getType() != Item.Type.MAVEN ? DownloadableFileService.getInstance().createFileDescription(it.getUrl(), it.getName()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fileDescriptions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        DownloadableFileSetDescriptionImpl description = new DownloadableFileSetDescriptionImpl(version.getArtifact().getName(), version.getVersion(), fileDescriptions);
        List list = description.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFiles(...)");
        if (!((Collection)list).isEmpty()) {
            FileDownloader fileDownloader = DownloadableFileService.getInstance().createDownloader((DownloadableFileSetDescription)description);
            Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
            FileDownloader downloader = fileDownloader;
            downloader.download(artifactDir);
        }
        try {
            this.downloadMavenItems(version, artifactDir);
        }
        catch (Exception e) {
            throw new IOException("Download from maven failed", e);
        }
        this.unpackZippedItems(version);
    }

    private final void downloadMavenItems(ArtifactVersion version, File artifactDir) {
        for (Item item : version.getItems()) {
            if (item.getType() != Item.Type.MAVEN) continue;
            this.resolveMavenItem(artifactDir, item, true);
        }
    }

    private final Collection<File> resolveMavenItem(File artifactDir, Item item, boolean download) throws Exception {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            Object[] objectArray = new Object[]{download ? 0 : 1, item.getUrl()};
            indicator.setText(JpaModelBundle.message("progress.text.choice.downloading.resolving", objectArray));
        }
        ProgressConsumer progressConsumer2 = indicator != null ? (ProgressConsumer)new ProgressConsumer(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
            }

            public void consume(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$indicator.setText2(message);
            }

            public boolean isCanceled() {
                return this.$indicator.isCanceled();
            }
        } : ProgressConsumer.DEAF;
        ArtifactRepositoryManager manager = new ArtifactRepositoryManager(artifactDir, this.getRepositories(), progressConsumer2, !download);
        List list = StringUtil.split((String)item.getUrl(), (String)":");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List coords = list;
        if (coords.size() != 3) {
            throw new IOException("Illegal maven coordinates " + item.getUrl() + " should be group:artifact:version");
        }
        Object e = coords.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)e;
        Object e2 = coords.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)e2;
        Object e3 = coords.get(2);
        Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type kotlin.String");
        Collection collection = manager.resolveDependency(string, string2, (String)e3, true, CollectionsKt.emptyList());
        Intrinsics.checkNotNull((Object)collection);
        Collection result = collection;
        return result;
    }

    private final List<RemoteRepository> getRepositories() {
        List list;
        if (this.myDefaultRepositories == null) {
            this.myDefaultRepositories = ArtifactRepositoryManager.createDefaultRemoteRepositories();
        }
        if ((list = this.myDefaultRepositories) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void unpackZippedItems(ArtifactVersion version) {
        void $this$filterTo$iv$iv;
        File dir = Companion.getArtifactDir(version);
        Iterable $this$filter$iv = version.getItems();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Item it = (Item)element$iv$iv;
            boolean bl = false;
            if (!(it.getOs().getApplicable() && it.getType() == Item.Type.NATIVE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Item it = (Item)element$iv;
            boolean bl = false;
            this.unpackZipIfNeeded(dir, version, it);
        }
    }

    private final File unpackZipIfNeeded(File dir, ArtifactVersion version, Item item) {
        File archive = new File(dir, item.getName());
        return this.unpackZipIfNeeded(archive, version);
    }

    /*
     * WARNING - void declaration
     */
    private final File unpackZipIfNeeded(File archive, ArtifactVersion version) {
        File file;
        if (!archive.exists()) {
            file = null;
        } else {
            void var3_3;
            File out = this.getUnpackPath(archive, version);
            String string = archive.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.extractLibrary(archive, out, string);
            file = var3_3;
        }
        return file;
    }

    private final void extractLibrary(File archive, File out, String name) {
        if (!this.isExtracted(out)) {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator != null) {
                Object[] objectArray = new Object[]{name};
                indicator.setText2(JpaModelBundle.message("progress.details.extracting", objectArray));
            }
            try {
                ZipUtil.extract((Path)archive.toPath(), (Path)out.toPath(), null, (boolean)true);
            }
            catch (IOException var5) {
                logger.warn("Failed to extract " + name, (Throwable)var5);
                FileUtil.delete((File)out);
            }
        }
    }

    private final boolean isExtracted(File out) {
        return out.exists() && !ArrayUtil.isEmpty((Object[])out.list());
    }

    @NotNull
    public final File getUnpackPath(@NotNull File archive, @NotNull ArtifactVersion version) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = FileUtil.getNameWithoutExtension((File)archive);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String name = string;
        return new File(new File(new File(DbUtils.NATIVE_LIBS_ROOT, version.getArtifact().getId()), version.getVersion()), name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAllDownloaded(@NotNull ArtifactVersion version) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        File artifactDir = Companion.getArtifactDir(version);
        Iterable $this$all$iv = version.getItems();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Item it = (Item)element$iv;
            boolean bl2 = false;
            Collection<File> classPaths = it.getClassPaths(this, artifactDir);
            if (it.getOs().getApplicable()) {
                boolean bl3;
                Collection<File> collection = classPaths;
                if (collection == null) return false;
                Iterable $this$all$iv2 = collection;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        File file = (File)element$iv2;
                        boolean bl4 = false;
                        if (file.exists()) continue;
                        return false;
                    }
                    bl3 = true;
                }
                if (!bl3) return false;
                boolean bl5 = true;
                if (!bl5) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getExistsClasspathElements(@NotNull DbDriver driver) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object v2;
        Object it;
        Iterable $this$mapNotNullTo$iv$iv2;
        List list;
        List result;
        block7: {
            Object object;
            block9: {
                block8: {
                    void $this$mapNotNull$iv2;
                    Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                    result = new ArrayList();
                    Iterable iterable = driver.getLibraries();
                    list = result;
                    boolean $i$f$mapNotNull = false;
                    void var5_7 = $this$mapNotNull$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        File it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        File file = new File(it2);
                        if ((file.exists() ? file : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list.addAll((List)destination$iv$iv);
                    object = driver.getId();
                    if (object == null) break block8;
                    it = object;
                    boolean bl = false;
                    Artifact artifact = this.findArtifactByDriverClass((String)it);
                    object = artifact;
                    if (artifact != null) break block9;
                }
                return result;
            }
            Object artifact = object;
            it = ((Artifact)artifact).getVersions();
            Iterator bl = it.iterator();
            while (bl.hasNext()) {
                Object $i$f$forEach = bl.next();
                ArtifactVersion it3 = (ArtifactVersion)$i$f$forEach;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it3.getVersion(), (Object)driver.getVersion())) continue;
                v2 = $i$f$forEach;
                break block7;
            }
            v2 = null;
        }
        ArtifactVersion artifactVersion = v2;
        if (artifactVersion == null) {
            return result;
        }
        ArtifactVersion artifactVersion2 = artifactVersion;
        $this$mapNotNullTo$iv$iv2 = this.getClasspathElements(artifactVersion2);
        list = result;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it4 = (File)element$iv$iv;
            boolean bl5 = false;
            if ((it4.exists() ? it4 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getClasspathElements(ArtifactVersion version) {
        void $this$flatMapTo$iv$iv;
        File artifactDir = Companion.getArtifactDir(version);
        Iterable $this$flatMap$iv = version.getItems();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Item it = (Item)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getClassPaths(this, artifactDir);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Artifact findArtifactByDriverClass(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.getArtifacts();
            for (Object t : iterable) {
                Artifact it = (Artifact)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDriverClass(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Collection<Artifact> getArtifacts() {
        if (this.artifacts.isEmpty()) {
            this.reloadArtifacts();
        }
        return this.artifacts;
    }

    public void dispose() {
    }

    private static final DbType loadDriverAndRunAction$lambda$0(DbProperties it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType();
    }

    private static final boolean loadDriverAndRunAction$lambda$1(DbType it) {
        return !(it instanceof UnknownType);
    }

    private static final boolean loadDriverAndRunAction$lambda$2(DbDriversManager $dbDriversManager, DbType dbType) {
        try {
            String string = dbType.getDriverClass();
            if (string == null) {
                return false;
            }
            String driverClass = string;
            $dbDriversManager.loadDriver(driverClass);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private static final void loadDriverAndRunAction$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }

    @JvmStatic
    @NotNull
    public static final DatabaseArtifactsManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ String access$loadRemoteArtifactsSource(DatabaseArtifactsManager $this) {
        return $this.loadRemoteArtifactsSource();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DatabaseArtifactsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DatabaseArtifactsManager.logger = logger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"HSQLDB", (Object)"org.hsqldb.jdbc.JDBCDriver"), TuplesKt.to((Object)"MySQL Connector/J", (Object)"com.mysql.jdbc.Driver"), TuplesKt.to((Object)"MySQL Connector/J 8", (Object)"com.mysql.cj.jdbc.Driver"), TuplesKt.to((Object)"MariaDB Connector J", (Object)"org.mariadb.jdbc.Driver"), TuplesKt.to((Object)"PostgreSQL 2", (Object)"org.postgresql.Driver"), TuplesKt.to((Object)"jTDS (SQL Server and Sybase)", (Object)"net.sourceforge.jtds.jdbc.Driver"), TuplesKt.to((Object)"Oracle", (Object)"oracle.jdbc.OracleDriver"), TuplesKt.to((Object)"SQL Server", (Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver"), TuplesKt.to((Object)"H2", (Object)"org.h2.Driver"), TuplesKt.to((Object)"DB2", (Object)"com.ibm.db2.jcc.DB2Driver")};
        artifactNameToDriverClass = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Artifact;", "", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "versions", "Ljava/util/LinkedHashSet;", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$ArtifactVersion;", "Lkotlin/collections/LinkedHashSet;", "getVersions", "()Ljava/util/LinkedHashSet;", "driverClass", "getDriverClass", "setDriverClass", "(Ljava/lang/String;)V", "intellij.javaee.jpa.jpb.model"})
    public static final class Artifact {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final LinkedHashSet<ArtifactVersion> versions;
        @Nullable
        private String driverClass;

        public Artifact(@NotNull String id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
            this.versions = new LinkedHashSet();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final LinkedHashSet<ArtifactVersion> getVersions() {
            return this.versions;
        }

        @Nullable
        public final String getDriverClass() {
            return this.driverClass;
        }

        public final void setDriverClass(@Nullable String string) {
            this.driverClass = string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$ArtifactVersion;", "", "artifact", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Artifact;", "version", "", "items", "", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item;", "<init>", "(Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Artifact;Ljava/lang/String;Ljava/util/List;)V", "getArtifact", "()Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Artifact;", "getVersion", "()Ljava/lang/String;", "getItems", "()Ljava/util/List;", "intellij.javaee.jpa.jpb.model"})
    public static final class ArtifactVersion {
        @NotNull
        private final Artifact artifact;
        @NotNull
        private final String version;
        @NotNull
        private final List<Item> items;

        public ArtifactVersion(@NotNull Artifact artifact, @NlsSafe @NotNull String version, @NotNull List<Item> items2) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            this.artifact = artifact;
            this.version = version;
            this.items = items2;
        }

        @NotNull
        public final Artifact getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final List<Item> getItems() {
            return this.items;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$intellij_javaee_jpa_jpb_model", "()Lcom/intellij/openapi/diagnostic/Logger;", "ourDownloadPath", "", "artifactNameToDriverClass", "", "getInstance", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager;", "getArtifactDir", "Ljava/io/File;", "version", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$ArtifactVersion;", "getLocalArtifactListPath", "getDownloadPath", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger$intellij_javaee_jpa_jpb_model() {
            return logger;
        }

        @JvmStatic
        @NotNull
        public final DatabaseArtifactsManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(DatabaseArtifactsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DatabaseArtifactsManager)object;
        }

        @NotNull
        public final File getArtifactDir(@NotNull ArtifactVersion version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new File(new File(this.getDownloadPath(), version.getArtifact().getId()), version.getVersion());
        }

        private final File getLocalArtifactListPath() {
            return new File(this.getDownloadPath(), "jdbc-drivers.xml");
        }

        private final String getDownloadPath() {
            if (ourDownloadPath == null) {
                String propertyValue = System.getProperty("datagrip.driver.path");
                ourDownloadPath = (String)(propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : PathManager.getConfigPath() + File.separator + "jdbc-drivers");
            }
            String string = ourDownloadPath;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item;", "", "name", "", "url", "os", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$OS;", "type", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$Type;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$OS;Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$Type;)V", "getName", "()Ljava/lang/String;", "getUrl", "getOs", "()Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$OS;", "getType", "()Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$Type;", "classpath", "", "Ljava/io/File;", "getClasspath", "()Ljava/util/Collection;", "setClasspath", "(Ljava/util/Collection;)V", "getClassPaths", "artifactManager", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager;", "dir", "OS", "Type", "intellij.javaee.jpa.jpb.model"})
    public static final class Item {
        @NotNull
        private final String name;
        @NotNull
        private final String url;
        @NotNull
        private final OS os;
        @NotNull
        private final Type type;
        @Nullable
        private Collection<? extends File> classpath;

        public Item(@NotNull String name, @NotNull String url, @NotNull OS os, @NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.name = name;
            this.url = url;
            this.os = os;
            this.type = type;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final OS getOs() {
            return this.os;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @Nullable
        public final Collection<File> getClasspath() {
            return this.classpath;
        }

        public final void setClasspath(@Nullable Collection<? extends File> collection) {
            this.classpath = collection;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Collection<File> getClassPaths(@NotNull DatabaseArtifactsManager artifactManager, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)artifactManager, (String)"artifactManager");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            if (this.classpath == null) {
                Collection collection;
                Item item = this;
                if (this.type == Type.MAVEN) {
                    Collection collection2;
                    Item item2 = item;
                    try {
                        item = item2;
                        collection2 = artifactManager.resolveMavenItem(dir, this, false);
                    }
                    catch (Exception exception) {
                        void e;
                        item = item2;
                        if (!(e instanceof ArtifactResolutionException)) {
                            Companion.getLogger$intellij_javaee_jpa_jpb_model().warn((Throwable)e);
                        }
                        collection2 = null;
                    }
                    collection = collection2;
                } else {
                    collection = CollectionsKt.listOf((Object)new File(dir, this.name));
                }
                item.classpath = collection;
            }
            return this.classpath;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$OS;", "", "applicable", "", "<init>", "(Ljava/lang/String;IZ)V", "getApplicable", "()Z", "ANY", "LINUX", "MAC", "WIN", "intellij.javaee.jpa.jpb.model"})
        public static final class OS
        extends Enum<OS> {
            private final boolean applicable;
            public static final /* enum */ OS ANY = new OS(true);
            public static final /* enum */ OS LINUX = new OS(SystemInfo.isLinux);
            public static final /* enum */ OS MAC = new OS(SystemInfo.isMac);
            public static final /* enum */ OS WIN = new OS(SystemInfo.isWindows);
            private static final /* synthetic */ OS[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OS(boolean applicable) {
                this.applicable = applicable;
            }

            public final boolean getApplicable() {
                return this.applicable;
            }

            public static OS[] values() {
                return (OS[])$VALUES.clone();
            }

            public static OS valueOf(String value) {
                return Enum.valueOf(OS.class, value);
            }

            @NotNull
            public static EnumEntries<OS> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = oSArray = new OS[]{OS.ANY, OS.LINUX, OS.MAC, OS.WIN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$Item$Type;", "", "<init>", "(Ljava/lang/String;I)V", "JAR", "NATIVE", "MAVEN", "intellij.javaee.jpa.jpb.model"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type JAR = new Type();
            public static final /* enum */ Type NATIVE = new Type();
            public static final /* enum */ Type MAVEN = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.JAR, Type.NATIVE, Type.MAVEN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

