/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ed;

import com.google.common.base.Strings;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.jpa.jpb.model.ed.AttrColumnInfo;
import com.intellij.jpa.jpb.model.model.CachedEntityAttributeModel;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaEntityDesignerHelper
extends EntityDesignHelper {
    public JpaEntityDesignerHelper(Project project) {
        super(project);
    }

    @Override
    @Nullable
    public String generateEntityName(@NotNull String className) {
        String entityNameTemplate;
        if (className == null) {
            JpaEntityDesignerHelper.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(entityNameTemplate = JpaPluginProjectConfig.getState((Project)this.project).entityNameTemplate))) {
            return null;
        }
        String entityName = this.mergeTemplate(Map.of("className", new TemplateString(className)), entityNameTemplate, JpaModelBundle.message("notification.title.exception.when.entity.name.calculating.entity.name.template", entityNameTemplate));
        Object uniqueEntityName = entityName;
        int idx = 1;
        while (this.entityNameNotUnique((String)uniqueEntityName, className)) {
            uniqueEntityName = entityName + "_" + idx;
            ++idx;
        }
        return uniqueEntityName;
    }

    @Override
    public Function<String, String> creteDefaultAttrColumnConverter() {
        String columnNameTemplate = JpaPluginProjectConfig.getState((Project)this.project).columnNameTemplate;
        if (StringUtil.isEmpty((String)columnNameTemplate)) {
            return null;
        }
        return s -> this.mergeTemplate(Map.of("fieldName", new TemplateString((String)s)), columnNameTemplate, JpaModelBundle.message("notification.title.exception.when.entity.column.name.calculating.column.name.template", columnNameTemplate));
    }

    @Override
    @Nullable
    public String generateAttributeColumnName(AttrColumnInfo info) {
        String attributeName = info.getAttributeName();
        EntityAttribute.MappingType mappingType = info.getMappingType();
        Function<String, String> converter = info.getConverter();
        if (attributeName == null || mappingType == null || converter == null) {
            return null;
        }
        EntityAttribute.Cardinality cardinality = info.getCardinality();
        Datatype attrType = info.getAttrType();
        boolean isOwner = info.isOwner();
        Entity ownerEntity = info.getOwnerEntity();
        String column = null;
        String underscored = converter.apply(attributeName);
        String postfix = "ID";
        postfix = converter.apply(postfix);
        if (mappingType == EntityAttribute.MappingType.DATATYPE && (cardinality == EntityAttribute.Cardinality.MANY_TO_ONE || cardinality == EntityAttribute.Cardinality.ONE_TO_ONE) && info.isGenericType()) {
            column = !Strings.isNullOrEmpty((String)underscored) ? underscored + "_" + converter.apply(postfix) : "";
        } else if (mappingType == EntityAttribute.MappingType.DATATYPE || mappingType == EntityAttribute.MappingType.ENUM || mappingType == EntityAttribute.MappingType.EMBEDDED || mappingType == EntityAttribute.MappingType.ELEMENT_COLLECTION) {
            column = underscored;
        } else if (mappingType == EntityAttribute.MappingType.ASSOCIATION && cardinality != null && !cardinality.isMany() && (cardinality != EntityAttribute.Cardinality.ONE_TO_ONE || isOwner)) {
            if (attrType instanceof Entity) {
                Entity typeEntity = (Entity)attrType;
                EntityAttribute idAttr = JpaEntityDesignerHelper.getIdAttribute(typeEntity);
                if (idAttr != null && idAttr.getType() instanceof Entity) {
                    return null;
                }
                if (idAttr != null) {
                    postfix = converter.apply(idAttr.getClearDbColumn());
                }
            }
            column = !Strings.isNullOrEmpty((String)underscored) ? underscored + "_" + postfix : "";
        } else if (mappingType == EntityAttribute.MappingType.ASSOCIATION && cardinality == EntityAttribute.Cardinality.ONE_TO_MANY && isOwner && ownerEntity != null) {
            EntityAttribute idAttr = JpaEntityDesignerHelper.getIdAttribute(ownerEntity);
            if (idAttr != null && idAttr.getType() instanceof Entity) {
                return null;
            }
            if (idAttr != null) {
                postfix = converter.apply(idAttr.getClearDbColumn());
            }
            column = !Strings.isNullOrEmpty((String)(underscored = converter.apply(ownerEntity.getClassName()))) ? underscored + "_" + postfix : "";
        }
        return column;
    }

    @Override
    @Nullable
    public String generateTableName(@NotNull String className) {
        String tableNameTemplate;
        if (className == null) {
            JpaEntityDesignerHelper.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(tableNameTemplate = JpaPluginProjectConfig.getState((Project)this.project).tableNameTemplate))) {
            return null;
        }
        String tableName = this.mergeTemplate(Map.of("className", new TemplateString(className)), tableNameTemplate, JpaModelBundle.message("notification.title.exception.when.entity.table.name.calculating.table.name.template", tableNameTemplate));
        Object uniqueTableName = tableName;
        int idx = 1;
        while (JpaEntityDesignerHelper.tableNameNotUnique(this.project, (String)uniqueTableName, className)) {
            uniqueTableName = tableName + "_" + idx;
            ++idx;
        }
        return uniqueTableName;
    }

    @Override
    public String generateJoinTableName(String tableName, String attributeName) {
        return String.format("%s_%s", tableName, attributeName);
    }

    @Override
    public String generateJoinColumnName(Entity e1, String suffix) {
        String className = e1.getClassName();
        return JpaEntityDesignerHelper._generateJoinColumnName(e1, className, suffix);
    }

    public static String _generateJoinColumnName(Entity e1, String name, String suffix) {
        String columnName = StringUtil.decapitalize((String)name);
        String idName = JpaEntityDesignerHelper.getIdName(e1);
        return String.format("%s%s_%s", columnName, suffix != null ? suffix : "", idName);
    }

    @Nullable
    private static String getIdName(Entity e1) {
        EntityAttribute idAttribute = e1.getIdAttributeOrNull();
        if (idAttribute != null) {
            List<EntityAttribute> keyIdAttrs = e1.getCompKeyIdAttrs();
            if (keyIdAttrs.size() == 1) {
                return keyIdAttrs.get(0).getColumn();
            }
            String column = idAttribute.getColumn();
            return column != null ? column : idAttribute.getName();
        }
        return "id";
    }

    @Override
    public String generateInverseJoinColumnName(EntityAttribute attribute, String suffix) {
        Datatype type = attribute.getType();
        if (type instanceof Entity) {
            String className = attribute.getName();
            return JpaEntityDesignerHelper._generateJoinColumnName((Entity)type, className, suffix);
        }
        return null;
    }

    private String mergeTemplate(@NotNull Map attributes, @NotNull String content, @NlsContexts.NotificationTitle @Nullable String exceptionMsg) {
        if (attributes == null) {
            JpaEntityDesignerHelper.$$$reportNull$$$0(2);
        }
        if (content == null) {
            JpaEntityDesignerHelper.$$$reportNull$$$0(3);
        }
        try {
            return FileTemplateUtil.mergeTemplate((Map)attributes, (String)content, (boolean)true);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                HNotificationManager.getInstance(this.project).error(exceptionMsg, e);
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static EntityAttribute getIdAttribute(Entity entity) {
        EntityAttribute idAttr = entity.getIdAttributeOrNull();
        Pair<EntityAttribute, String> overriddenIdAttr = JpaEntityDesignerHelper.getOverriddenIdAttrColumnNameViaMapsId(entity.getAllAttributes());
        if (overriddenIdAttr == null) {
            return idAttr;
        }
        idAttr = (EntityAttribute)overriddenIdAttr.first;
        String columnName = (String)overriddenIdAttr.second;
        CachedEntityAttributeModel newIdAttr = new CachedEntityAttributeModel();
        newIdAttr.copyFromWithMemberReference(idAttr);
        newIdAttr.setColumn(columnName);
        return newIdAttr;
    }

    @Override
    public String generateIndexName(Entity entity, List<String> columns, boolean isUnique) {
        return this.toConstraintCase(super.generateIndexName(entity, columns, isUnique));
    }

    @Override
    public String generateConstraintName(Entity entity, List<String> columns) {
        return this.toConstraintCase(super.generateConstraintName(entity, columns));
    }

    public String toConstraintCase(String constraint) {
        Function<String, String> converter = JpaPluginProjectConfig.getState((Project)this.project).indexCase.getConverter();
        return converter.apply(constraint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/ed/JpaEntityDesignerHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateEntityName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TemplateString
    implements PgKeepClassMembers {
        private String value;

        TemplateString(String value) {
            this.value = value;
        }

        public TemplateString toUpperCase() {
            this.value = this.value.toUpperCase();
            return this;
        }

        public TemplateString toLowerCase() {
            this.value = this.value.toLowerCase();
            return this;
        }

        public TemplateString capitalize() {
            this.value = StringUtil.capitalize((String)this.value);
            return this;
        }

        public TemplateString decapitalize() {
            this.value = StringUtil.decapitalize((String)this.value);
            return this;
        }

        public TemplateString pluralize() {
            this.value = StringUtil.pluralize((String)this.value);
            return this;
        }

        public TemplateString underscore() {
            this.value = TemplateString.splitWords(this.value, '_');
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static String splitWords(@NotNull String text, char separator) {
            if (text == null) {
                TemplateString.$$$reportNull$$$0(0);
            }
            @NotNull List words = NameUtilCore.nameToWordList((String)text);
            boolean insertSeparator = false;
            StringBuilder buf = new StringBuilder();
            for (String word : words) {
                if (!Character.isLetterOrDigit(word.charAt(0))) {
                    buf.append(separator);
                    insertSeparator = false;
                    continue;
                }
                if (insertSeparator) {
                    buf.append(separator);
                } else {
                    insertSeparator = true;
                }
                buf.append(word);
            }
            return buf.toString();
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateString that = (TemplateString)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/jpa/jpb/model/ed/JpaEntityDesignerHelper$TemplateString", "splitWords"));
        }
    }
}

