/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection.fix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.inspection.fix.AnnotationReplacer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/fix/ReplaceAnnotationFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotationFqn", "", "migrateValueAttr", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.javaee.jpa.jpb.model"})
public class ReplaceAnnotationFix
implements LocalQuickFix {
    @NotNull
    private final String annotationFqn;
    private final boolean migrateValueAttr;

    public ReplaceAnnotationFix(@NotNull String annotationFqn, boolean migrateValueAttr) {
        Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
        this.annotationFqn = annotationFqn;
        this.migrateValueAttr = migrateValueAttr;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.annotationFqn};
        String string = JpaModelBundle.message("inspections.replaceAnnotation", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
            PsiElement problemAnnotation = problemDescriptor.getPsiElement();
            Intrinsics.checkNotNull((Object)problemAnnotation);
            AnnotationReplacer annotationReplacer = (AnnotationReplacer)AnnotationReplacer.Companion.getInstance(problemAnnotation);
            if (annotationReplacer == null) break block0;
            annotationReplacer.replace(problemAnnotation, this.annotationFqn, this.migrateValueAttr);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

