/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.overrides.CopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"buildFakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "makeExternal", "", "value", "", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideBuilderStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideBuilderStrategy.kt\norg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class FakeOverrideBuilderStrategyKt {
    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member, @NotNull IrClass clazz) {
        IrOverridableMember irOverridableMember;
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        if (!(superType instanceof IrSimpleType)) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62 = "superType is " + superType + ", expected IrSimpleType";
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62.toString());
        }
        IrClassifierSymbol classifier = ((IrSimpleType)superType).getClassifier();
        if (!(classifier instanceof IrClassSymbol)) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72 = "superType classifier is not IrClassSymbol: " + classifier;
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72.toString());
        }
        List<IrTypeParameter> typeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((Object)((IrClassSymbol)classifier).getOwner()));
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType).getArguments();
        if (!(typeParameters.size() == superArguments.size())) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82 = "typeParameters = " + typeParameters + " size != typeArguments = " + superArguments + " size ";
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82.toString());
        }
        Map substitutionMap = new LinkedHashMap();
        int n = ((Collection)typeParameters).size();
        for (int i = 0; i < n; ++i) {
            IrTypeParameter tp = typeParameters.get(i);
            IrTypeArgument ta = superArguments.get(i);
            if (!(ta instanceof IrTypeProjection)) {
                boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92 = false;
                String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92 = "Unexpected super type argument: " + RenderIrElementKt.render$default(ta, null, 1, null) + " @ " + i;
                throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92.toString());
            }
            if (!(((IrTypeProjection)ta).getVariance() == Variance.INVARIANT)) {
                boolean bl = false;
                String string = "Unexpected variance in super type argument: " + ((IrTypeProjection)ta).getVariance() + " @" + i;
                throw new IllegalArgumentException(string.toString());
            }
            substitutionMap.put(tp.getSymbol(), ((IrTypeProjection)ta).getType());
        }
        IrOverridableMember $this$buildFakeOverrideMember_u24lambda_u245 = irOverridableMember = new CopyIrTreeWithSymbolsForFakeOverrides(member, substitutionMap, clazz).copy();
        boolean bl = false;
        if (clazz.isExternal()) {
            FakeOverrideBuilderStrategyKt.makeExternal($this$buildFakeOverrideMember_u24lambda_u245, true);
        } else if (IrUtilsKt.getParentAsClass(member).isExternal()) {
            FakeOverrideBuilderStrategyKt.makeExternal($this$buildFakeOverrideMember_u24lambda_u245, false);
        }
        return irOverridableMember;
    }

    private static final void makeExternal(IrOverridableMember $this$makeExternal, boolean value) {
        IrOverridableMember irOverridableMember = $this$makeExternal;
        if (irOverridableMember instanceof IrSimpleFunction) {
            ((IrSimpleFunction)$this$makeExternal).setExternal(value);
        } else if (irOverridableMember instanceof IrProperty) {
            ((IrProperty)$this$makeExternal).setExternal(value);
            IrSimpleFunction irSimpleFunction = ((IrProperty)$this$makeExternal).getGetter();
            if (irSimpleFunction != null) {
                irSimpleFunction.setExternal(value);
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)$this$makeExternal).getSetter();
            if (irSimpleFunction2 != null) {
                irSimpleFunction2.setExternal(value);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

