/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;
import org.jetbrains.kotlin.ir.validation.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.ir.validation.checkers.context.OffsetRange;
import org.jetbrains.kotlin.ir.validation.checkers.context.OffsetRangeChainUpdater;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/IrNestedOffsetRangeChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/IrElement;", "<init>", "()V", "requiredContextUpdaters", "", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/ContextUpdater;", "getRequiredContextUpdaters", "()Ljava/util/Set;", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrNestedOffsetRangeChecker
extends IrElementChecker<IrElement> {
    @NotNull
    public static final IrNestedOffsetRangeChecker INSTANCE = new IrNestedOffsetRangeChecker();

    private IrNestedOffsetRangeChecker() {
        super(Reflection.getOrCreateKotlinClass(IrElement.class));
    }

    @Override
    @NotNull
    public Set<ContextUpdater> getRequiredContextUpdaters() {
        return SetsKt.setOf((Object)OffsetRangeChainUpdater.INSTANCE);
    }

    @Override
    public void check(@NotNull IrElement element, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        OffsetRange offsetRange = (OffsetRange)CollectionsKt.lastOrNull(context2.getOffsetRanges());
        if (offsetRange == null) {
            return;
        }
        OffsetRange outerRange = offsetRange;
        OffsetRange offsetRange2 = OffsetRange.Companion.createIfRealValidOffsets(element, true);
        if (offsetRange2 == null) {
            return;
        }
        OffsetRange currentRange = offsetRange2;
        if (!outerRange.contains(currentRange)) {
            context2.error(this, element, "The offsets range " + currentRange + " is not within the outer offsets range " + outerRange + " (owner = " + RenderIrElementKt.render$default(outerRange.getOwner(), null, 1, null) + ')');
        }
    }
}

