/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\bJ\r\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "", "element", "<init>", "(Ljava/lang/Object;)V", "isEnabled", "", "getStringValues", "", "", "getOptionsList", "getNumberValue", "", "()Ljava/lang/Integer;", "getStringMapValue", "", "getRuleOptions", "intellij.tslint"})
public final class TslintJsonOption {
    @Nullable
    private final Object element;

    public TslintJsonOption(@Nullable Object element) {
        this.element = element;
    }

    public final boolean isEnabled() {
        if (this.element instanceof Boolean) {
            return (Boolean)this.element;
        }
        if (this.element instanceof List && ((List)this.element).size() > 0 && ((List)this.element).get(0) instanceof Boolean) {
            Object e = ((List)this.element).get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return (Boolean)e;
        }
        if (this.element instanceof Map) {
            Object severityValue = ((Map)this.element).get("severity");
            return !Intrinsics.areEqual((Object)"none", severityValue) && !Intrinsics.areEqual((Object)"off", severityValue);
        }
        return false;
    }

    @NotNull
    public final List<String> getStringValues() {
        return CollectionsKt.filterIsInstance((Iterable)this.getOptionsList(), String.class);
    }

    @NotNull
    public final List<Object> getOptionsList() {
        Object options = this.getRuleOptions();
        if (options instanceof List) {
            return CollectionsKt.filterNotNull((Iterable)((Iterable)options));
        }
        if (options != null) {
            return CollectionsKt.listOf((Object)options);
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final Integer getNumberValue() {
        return TsLintConfigKt.access$asInt(this.getRuleOptions());
    }

    @NotNull
    public final Map<String, String> getStringMapValue() {
        return TsLintConfigKt.access$asStringMap(this.getRuleOptions());
    }

    private final Object getRuleOptions() {
        if (this.element instanceof List) {
            if (((List)this.element).size() == 2) {
                return ((List)this.element).get(1);
            }
            return CollectionsKt.drop((Iterable)((Iterable)this.element), (int)1);
        }
        if (this.element instanceof Map) {
            Object optionsElement = ((Map)this.element).get("options");
            if (optionsElement instanceof List && ((List)optionsElement).size() == 1) {
                return ((List)optionsElement).get(0);
            }
            return optionsElement;
        }
        return null;
    }
}

