/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.document;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.editor.markup.ShadowingAwareMarkupModelListener;
import com.intellij.kotlin.jupyter.core.editor.highlighting.utils.RangeHighlighterUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J!\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001eJ\u0006\u0010\u001f\u001a\u00020\u0013J\b\u0010 \u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR>\u0010\r\u001a2\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f \u0011*\u0017\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\u0010\u00a2\u0006\u0002\b\u000e0\t\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/MarkUpModelErrorsHighlightersTracker;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "<init>", "()V", "activeMarkupModelListener", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/editor/markup/ShadowingAwareMarkupModelListener;", "fileIndexesToErrors", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getFileIndexesToErrors", "()Ljava/util/concurrent/ConcurrentHashMap;", "_errorHighlighters", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "addMarkupListener", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "resetState", "cellInFocus", "completeReset", "", "resetState$intellij_kotlin_jupyter_core", "(Ljava/lang/Integer;Z)V", "removeHighlightersOutSideOfFocus", "focusCell", "removeHighlightersOutSideOfFocus$intellij_kotlin_jupyter_core", "clear", "dispose", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkUpModelErrorsHighlightersTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkUpModelErrorsHighlightersTracker.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/MarkUpModelErrorsHighlightersTracker\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n72#2,2:75\n1#3:77\n540#4:78\n525#4,6:79\n1915#5,2:85\n*S KotlinDebug\n*F\n+ 1 MarkUpModelErrorsHighlightersTracker.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/MarkUpModelErrorsHighlightersTracker\n*L\n49#1:75,2\n49#1:77\n56#1:78\n56#1:79,6\n62#1:85,2\n*E\n"})
public final class MarkUpModelErrorsHighlightersTracker
extends HighlightingComponent {
    private ShadowingAwareMarkupModelListener activeMarkupModelListener;
    @NotNull
    private final ConcurrentHashMap<Integer, Set<RangeHighlighter>> fileIndexesToErrors = new ConcurrentHashMap();
    @NotNull
    private final Set<RangeHighlighter> _errorHighlighters;

    public MarkUpModelErrorsHighlightersTracker() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this._errorHighlighters = set;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, Set<RangeHighlighter>> getFileIndexesToErrors() {
        return this.fileIndexesToErrors;
    }

    public final void addMarkupListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.activeMarkupModelListener = new ShadowingAwareMarkupModelListener(this._errorHighlighters);
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editorEx2 = editorEx;
        EditorImpl editorImpl = editorEx2 instanceof EditorImpl ? (EditorImpl)editorEx2 : null;
        if (editorImpl == null || (editorImpl = editorImpl.getDisposable()) == null) {
            editorImpl = this;
        }
        EditorImpl parentDisposable = editorImpl;
        MarkupModelEx markupModelEx = editorEx2.getFilteredDocumentMarkupModel();
        ShadowingAwareMarkupModelListener shadowingAwareMarkupModelListener = this.activeMarkupModelListener;
        if (shadowingAwareMarkupModelListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeMarkupModelListener");
            shadowingAwareMarkupModelListener = null;
        }
        markupModelEx.addMarkupModelListener((Disposable)parentDisposable, (MarkupModelListener)shadowingAwareMarkupModelListener);
    }

    /*
     * WARNING - void declaration
     */
    public final void resetState$intellij_kotlin_jupyter_core(@Nullable Integer cellInFocus, boolean completeReset) {
        if (completeReset) {
            this.clear();
            return;
        }
        Set<RangeHighlighter> highlighters = this._errorHighlighters;
        if (cellInFocus != null) {
            Set focusCellHighlighters;
            void $this$getOrPut$iv;
            ConcurrentMap concurrentMap = this.fileIndexesToErrors;
            Integer key$iv = cellInFocus;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                Set default$iv = new LinkedHashSet();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Set set = focusCellHighlighters = (Set)object;
            if (set != null) {
                set.addAll((Collection)highlighters);
            }
        }
        highlighters.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeHighlightersOutSideOfFocus$intellij_kotlin_jupyter_core(int focusCell) {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.fileIndexesToErrors;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((Collection)entry.getValue()).isEmpty() && ((Number)entry.getKey()).intValue() != focusCell)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map errorData = destination$iv$iv;
        RangeHighlighterUtilsKt.disposeOfHighlighters(CollectionsKt.flatten((Iterable)errorData.values()));
        Iterable $this$forEach$iv = errorData.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.fileIndexesToErrors.remove(it);
        }
    }

    public final void clear() {
        this.fileIndexesToErrors.clear();
        this._errorHighlighters.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }
}

