/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JupyterOutputsBase;
import com.intellij.jupyter.execution.util.JsonKt;
import com.intellij.kotlin.jupyter.core.jupyter.execution.KotlinNotebookCellExecutionCallbackFactoryKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.statistics.fus.KotlinNotebookFeatureUsagesCollector;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallback;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "psiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "executionIndex", "", "cellIndex", "executionStartedMs", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;ILjava/lang/Integer;J)V", "Ljava/lang/Integer;", "onExecuteReply", "", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "onExecuteReplyImpl", "onUpdateOutput", "unregisterCallback", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookCellExecutionCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookCellExecutionCallback.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 json.kt\ncom/intellij/jupyter/execution/util/JsonKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,103:1\n29#2,2:104\n31#2:110\n68#3,3:106\n335#4:109\n13#5:111\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookCellExecutionCallback.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback\n*L\n62#1:104,2\n62#1:110\n63#1:106,3\n63#1:109\n100#1:111\n*E\n"})
public final class KotlinNotebookCellExecutionCallback
implements JupyterExecutionCallback {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;
    @Nullable
    private final JupyterPsiCell psiCell;
    private final int executionIndex;
    @Nullable
    private final Integer cellIndex;
    private final long executionStartedMs;
    @NotNull
    private static final Logger LOG;

    public KotlinNotebookCellExecutionCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @Nullable JupyterPsiCell psiCell, int executionIndex, @Nullable Integer cellIndex, long executionStartedMs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.virtualFile = virtualFile;
        this.psiCell = psiCell;
        this.executionIndex = executionIndex;
        this.cellIndex = cellIndex;
        this.executionStartedMs = executionStartedMs;
    }

    public void onExecuteReply(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BuildersKt.async$default((CoroutineScope)KotlinNotebookPluginScope.Companion.getForProject(this.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ KotlinNotebookCellExecutionCallback this$0;
            final /* synthetic */ JupyterMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            KotlinNotebookCellExecutionCallback.access$onExecuteReplyImpl(this.this$0, this.$message);
                        }
                        catch (Throwable e) {
                            if (e instanceof ProcessCanceledException) {
                                throw e;
                            }
                            KotlinNotebookCellExecutionCallback.access$getLOG$cp().warn("Kotlin execution callback failed", e);
                        }
                        finally {
                            Disposer.dispose((Disposable)((Disposable)this.this$0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void onExecuteReplyImpl(JupyterMessage message) {
        EvaluatedSnippetMetadata evaluatedSnippetMetadata;
        long executionFinishedMs = System.currentTimeMillis();
        JsonNode metadataObject = (JsonNode)message.getMetadata("eval_metadata");
        boolean bl = false;
        Object snippetMetadata = null;
        if (metadataObject != null) {
            Object object;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            JsonNode $this$deserialize$iv = metadataObject;
            boolean $i$f$deserialize = false;
            JsonElement json$iv = JsonKt.toNotebookSerializationJson((JsonNode)$this$deserialize$iv);
            if (json$iv instanceof JsonNull) {
                object = null;
            } else {
                void $this$decodeFromJsonElement$iv$iv;
                Json json = JsonKt.getJsonConfig();
                JsonElement json$iv$iv = json$iv;
                boolean $i$f$decodeFromJsonElement = false;
                $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                object = $this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.getNullable(EvaluatedSnippetMetadata.Companion.serializer()), json$iv$iv);
            }
            snippetMetadata = object;
            long deserializationTime = System.currentTimeMillis() - start$iv;
            String string = "Cell executed. Deserialization took " + deserializationTime + " ms. New classpath received";
            EvaluatedSnippetMetadata evaluatedSnippetMetadata2 = (EvaluatedSnippetMetadata)snippetMetadata;
            List list = evaluatedSnippetMetadata2 != null ? evaluatedSnippetMetadata2.getNewClasspath() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            LoggingKt.logListInfo(LOG, string, list);
        } else {
            LoggingKt.debugInTests(LOG, (Function0<String>)((Function0)() -> KotlinNotebookCellExecutionCallback.onExecuteReplyImpl$lambda$0$1(message)));
        }
        if ((evaluatedSnippetMetadata = (EvaluatedSnippetMetadata)snippetMetadata) == null) {
            evaluatedSnippetMetadata = EvaluatedSnippetMetadata.Companion.getEMPTY();
        }
        KotlinNotebookFeatureUsagesCollector.Companion.registerCellExecuted(this.project, message, executionFinishedMs - this.executionStartedMs, evaluatedSnippetMetadata);
        EvaluatedSnippetMetadata snippetMetadata2 = (EvaluatedSnippetMetadata)snippetMetadata;
        this.unregisterCallback();
        if (snippetMetadata2 != null) {
            Integer n = this.cellIndex;
            JupyterCompilerService.Companion.getForFile(this.project, this.virtualFile).addCompiledSnippet(snippetMetadata2, this.psiCell, n != null ? n : -1);
        }
    }

    public void onUpdateOutput(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterOutput jupyterOutput = JupyterOutputsBase.Companion.fromMessage(message);
        if (jupyterOutput == null) {
            return;
        }
        JupyterOutput output = jupyterOutput;
        KotlinNotebookFeatureUsagesCollector.Companion.registerOutputUpdated(this.project, output);
    }

    private final void unregisterCallback() {
        KotlinNotebookCellExecutionCallbackFactoryKt.getKotlinNotebookCellExecutionCallbackFactory().unregisterCallback(this.virtualFile, this.executionIndex);
    }

    private static final String onExecuteReplyImpl$lambda$0$1(JupyterMessage $message) {
        return "No snippet metadata found for message " + $message;
    }

    public static final /* synthetic */ void access$onExecuteReplyImpl(KotlinNotebookCellExecutionCallback $this, JupyterMessage message) {
        $this.onExecuteReplyImpl(message);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

