/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.session.KernelStartupOptions;
import com.intellij.jupyter.execution.kernel.KernelProcessAttachable;
import com.intellij.jupyter.execution.kernel.SeparateProcessKernelRunnableHandler;
import com.intellij.jupyter.execution.listeners.KernelListener;
import com.intellij.jupyter.execution.listeners.KernelProcessListener;
import com.intellij.jupyter.execution.listeners.events.KernelNotificationStartedEvent;
import com.intellij.jupyter.execution.listeners.events.KernelProcessEvent;
import com.intellij.jupyter.execution.listeners.events.NotebookKernelEvent;
import com.intellij.jupyter.execution.process.KernelPortsProvider;
import com.intellij.jupyter.execution.toolwindow.KernelProcessToolWindowCoordinator;
import com.intellij.jupyter.execution.toolwindow.KernelProcessToolWindowCoordinatorService;
import com.intellij.kotlin.jupyter.core.jupyter.actions.CreateNotebookFactoryKt;
import com.intellij.kotlin.jupyter.core.jupyter.actions.NotebookMode;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.DefaultKotlinKernelConfigFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.DefaultSystemPropertiesKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.ModeAwareKernelRunnableFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.extensions.KernelProcessCommandLineCustomizer;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.extensions.KernelVmCommandCustomizer;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifacts;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.core.util.PropertiesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlinx.jupyter.protocol.startup.KernelPorts;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelConfig;
import org.jetbrains.kotlinx.jupyter.startup.ArgumentsKt;
import org.jetbrains.kotlinx.jupyter.startup.parameters.KotlinKernelOwnParams;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqKernelPortsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0015J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/ModeAwareKernelRunnableFactory;", "<init>", "()V", "createSpecificKernelRunnableHandler", "Lcom/intellij/jupyter/execution/kernel/SeparateProcessKernelRunnableHandler;", "startupOptions", "Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;", "getWorkingDir", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "getJavaExecutable", "", "options", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookProjectOptionsProvider;", "_kernelPortsProvider", "Lcom/intellij/jupyter/execution/process/KernelPortsProvider;", "kernelPortsProvider", "getKernelPortsProvider", "()Lcom/intellij/jupyter/execution/process/KernelPortsProvider;", "setKernelPortsProvider", "", "getKernelPorts", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/KernelPorts;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKernelProcessFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelProcessFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,178:1\n1#2:179\n184#3,2:180\n*S KotlinDebug\n*F\n+ 1 KernelProcessFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory\n*L\n156#1:180,2\n*E\n"})
public final class KernelProcessFactory
extends ModeAwareKernelRunnableFactory {
    @NotNull
    private KernelPortsProvider _kernelPortsProvider = KernelProcessFactory::_kernelPortsProvider$lambda$0;

    public KernelProcessFactory() {
        super(KotlinNotebookSessionRunMode.SEPARATE_PROCESS);
    }

    @RequiresBackgroundThread
    @NotNull
    protected SeparateProcessKernelRunnableHandler createSpecificKernelRunnableHandler(@NotNull KernelStartupOptions startupOptions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        KernelPorts kernelPorts = this.getKernelPorts();
        KernelConfig<KotlinKernelOwnParams> kernelConfig = new DefaultKotlinKernelConfigFactory(startupOptions, kernelPorts).create();
        Project project = startupOptions.getProject();
        Path notebookPath = startupOptions.getNotebookPath();
        KotlinNotebookProjectOptionsProvider options2 = KotlinNotebookProjectOptionsProvider.Companion.getInstance(project);
        String javaExecutable = this.getJavaExecutable(project, options2);
        Path workingDir = this.getWorkingDir(project, notebookPath);
        List $this$createSpecificKernelRunnableHandler_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Path path2 = workingDir;
        if (path2 != null) {
            Path it = path2;
            boolean bl2 = false;
            $this$createSpecificKernelRunnableHandler_u24lambda_u240.add("-Duser.dir=" + PathsKt.getInvariantSeparatorsPathString((Path)workingDir) + "/");
        }
        $this$createSpecificKernelRunnableHandler_u24lambda_u240.add("-Xmx" + options2.getHeapMaxLimitInMib() + "M");
        List<String> jvmArguments = options2.getExtraJvmArguments();
        for (String extraArg : jvmArguments) {
            $this$createSpecificKernelRunnableHandler_u24lambda_u240.add(extraArg);
        }
        PropertiesKt.ensureSystemPropertiesPresent($this$createSpecificKernelRunnableHandler_u24lambda_u240, jvmArguments, DefaultSystemPropertiesKt.getDefaultSystemProperties());
        KernelVmCommandCustomizer.Companion.addVmArguments($this$createSpecificKernelRunnableHandler_u24lambda_u240);
        List extraJavaArgs = CollectionsKt.build((List)list);
        List<String> cmdArgs = ArgumentsKt.javaCmdLine(kernelConfig, javaExecutable, "kernelProcessConnection", CollectionsKt.joinToString$default((Iterable)KotlinNotebookMavenArtifactsDownloader.Companion.getInstance(project).downloadArtifactBlocking(KotlinNotebookMavenArtifacts.INSTANCE.getKERNEL_SHADOWED(), OptionsUtilKt.getSelectedKernelVersionAsString(project)), (CharSequence)FilesKt.getPathSeparator(), null, null, (int)0, null, KernelProcessFactory::createSpecificKernelRunnableHandler$lambda$1, (int)30, null), extraJavaArgs);
        GeneralCommandLine $this$createSpecificKernelRunnableHandler_u24lambda_u242 = bl = new GeneralCommandLine(cmdArgs);
        boolean bl3 = false;
        Path path3 = workingDir;
        if (path3 != null) {
            Path it = path3;
            boolean bl4 = false;
            $this$createSpecificKernelRunnableHandler_u24lambda_u242.withWorkingDirectory(it);
        }
        $this$createSpecificKernelRunnableHandler_u24lambda_u242.withEnvironment(options2.getExtraEnvironmentVariables());
        KernelProcessCommandLineCustomizer.Companion.customize($this$createSpecificKernelRunnableHandler_u24lambda_u242);
        GeneralCommandLine commandLine = bl;
        Process process = commandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        Process process2 = process;
        String string = commandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        SeparateProcessKernelRunnableHandler kernelHandler = new SeparateProcessKernelRunnableHandler(startupOptions, process2, string, kernelConfig.getJupyterParams());
        kernelHandler.addKernelListener((KernelListener)new KernelProcessListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void beforeNotificationStarted(KernelNotificationStartedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KernelProcessToolWindowCoordinator kernelProcessToolWindowCoordinator = KernelProcessToolWindowCoordinatorService.Companion.getInstance(this.$project).getOrCreate(event.getEventSource().getNotebookVirtualFile());
                if (kernelProcessToolWindowCoordinator != null) {
                    kernelProcessToolWindowCoordinator.onStarted((KernelProcessAttachable)event.getEventSource());
                }
            }

            public void kernelWillTerminate(KernelProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KernelProcessToolWindowCoordinator kernelProcessToolWindowCoordinator = KernelProcessToolWindowCoordinatorService.Companion.getInstance(this.$project).get(event.getKernelsProcessHandler().getNotebookVirtualFile());
                if (kernelProcessToolWindowCoordinator != null) {
                    kernelProcessToolWindowCoordinator.onWillTerminate((NotebookKernelEvent)event);
                }
            }
        });
        kernelHandler.getProcess().startNotify();
        return kernelHandler;
    }

    private final Path getWorkingDir(Project project, Path notebookPath) {
        Path path2;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFile virtualFile = fileManager.findFileByNioPath(notebookPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile notebookFile = virtualFile;
        Object object = BackedNotebookVirtualFile.Companion.takeIfBacked(notebookFile);
        if (object == null || (object = CreateNotebookFactoryKt.getMode((BackedNotebookVirtualFile)object)) == null) {
            return null;
        }
        Object mode = object;
        Path path3 = notebookPath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        Path it = path2 = path3.getParent();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path notebookParentDir = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path2 : null;
        return switch (WhenMappings.$EnumSwitchMapping$0[((Enum)mode).ordinal()]) {
            case 1 -> notebookParentDir;
            case 2 -> {
                Path var9_9;
                try {
                    VirtualFile v6 = ProjectUtil.guessProjectDir((Project)project);
                    var9_9 = v6 != null ? v6.toNioPath() : null;
                }
                catch (Exception <unused var>) {
                    var9_9 = notebookParentDir;
                }
                yield var9_9;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String getJavaExecutable(Project project, KotlinNotebookProjectOptionsProvider options2) {
        Path javaExecutable;
        Object object;
        Object v3;
        block3: {
            void $this$firstOrNull$iv;
            String javaHome = options2.getJdk().getPath(project);
            if (javaHome == null) {
                return "java";
            }
            Path path2 = Path.of(javaHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            Path path3 = path2.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
            Path binDir = path3.resolve("bin");
            String[] stringArray = new String[]{"java.exe", "java"};
            stringArray = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])stringArray), arg_0 -> KernelProcessFactory.getJavaExecutable$lambda$0(binDir, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path executable = (Path)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)executable);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        if ((object = (javaExecutable = (Path)v3)) == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
            object = "java";
        }
        return object;
    }

    @NotNull
    public final KernelPortsProvider getKernelPortsProvider() {
        return this._kernelPortsProvider;
    }

    @TestOnly
    public final void setKernelPortsProvider(@NotNull KernelPortsProvider kernelPortsProvider) {
        Intrinsics.checkNotNullParameter((Object)kernelPortsProvider, (String)"kernelPortsProvider");
        this._kernelPortsProvider = kernelPortsProvider;
    }

    private final KernelPorts getKernelPorts() {
        return this.getKernelPortsProvider().getKernelPorts();
    }

    private static final CharSequence createSpecificKernelRunnableHandler$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)it.toAbsolutePath()).toString();
    }

    private static final Path getJavaExecutable$lambda$0(Path $binDir, String executableName) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        return $binDir.resolve(executableName);
    }

    private static final KernelPorts _kernelPortsProvider$lambda$0() {
        Thread.currentThread().setContextClassLoader(KernelPortsProvider.class.getClassLoader());
        return (KernelPorts)ZmqKernelPortsKt.createRandomZmqKernelPorts();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookMode.values().length];
            try {
                nArray[NotebookMode.STANDARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookMode.LIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

