/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.projectModel;

import com.intellij.kotlin.jupyter.core.projectModel.KotlinNotebookPermanentIndexService;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0014\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150!0\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\n\u0010%\u001a\u0004\u0018\u00010#H\u0002J\b\u0010&\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "projectLibraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "Lorg/jetbrains/annotations/NotNull;", "getProjectLibraryTable", "()Lcom/intellij/openapi/roots/libraries/LibraryTable;", "addToPermanentIndex", "", "classpath", "", "", "sourceClasspath", "removeFromPermanentIndex", "artifactsPaths", "", "currentClassRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentClassRoots", "()Ljava/util/Collection;", "getLibraryRoots", "", "Lcom/intellij/openapi/roots/OrderRootType;", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "addToPermanentIndexImpl", "getPermanentScriptingLibrary", "getOrCreatePermanentScriptingLibrary", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookPermanentIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookPermanentIndexService.kt\ncom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1807#2,3:108\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookPermanentIndexService.kt\ncom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService\n*L\n46#1:108,3\n*E\n"})
public final class KotlinNotebookPermanentIndexService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    public static final String SCRIPT_DEPENDENCIES_LIBRARY_NAME = "Permanent Script Dependencies";

    public KotlinNotebookPermanentIndexService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    private final LibraryTable getProjectLibraryTable() {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        return libraryTable;
    }

    public final void addToPermanentIndex(@NotNull List<String> classpath, @NotNull List<String> sourceClasspath) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter(sourceClasspath, (String)"sourceClasspath");
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, classpath, sourceClasspath, null){
            int label;
            final /* synthetic */ KotlinNotebookPermanentIndexService this$0;
            final /* synthetic */ List<String> $classpath;
            final /* synthetic */ List<String> $sourceClasspath;
            {
                this.this$0 = $receiver;
                this.$classpath = $classpath;
                this.$sourceClasspath = $sourceClasspath;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.edtWriteAction(() -> addToPermanentIndex.1.invokeSuspend$lambda$0(this.this$0, this.$classpath, this.$sourceClasspath), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(KotlinNotebookPermanentIndexService this$0, List $classpath, List $sourceClasspath) {
                KotlinNotebookPermanentIndexService.access$addToPermanentIndexImpl(this$0, $classpath, $sourceClasspath);
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    public final void removeFromPermanentIndex(@NotNull Collection<String> artifactsPaths) {
        Intrinsics.checkNotNullParameter(artifactsPaths, (String)"artifactsPaths");
        Library library = this.getPermanentScriptingLibrary();
        if (library == null) {
            return;
        }
        Library library2 = library;
        Library.ModifiableModel modifiableModel = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        Library.ModifiableModel model = modifiableModel;
        Map<OrderRootType, Set<String>> existingRoots = this.getLibraryRoots(library2);
        Object[] objectArray = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};
        for (OrderRootType rootType : CollectionsKt.listOf((Object[])objectArray)) {
            Set<String> set = existingRoots.get(rootType);
            Intrinsics.checkNotNull(set);
            for (String rootPath : set) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = artifactsPaths;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.contains$default((CharSequence)rootPath, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                model.removeRoot(rootPath, rootType);
            }
        }
        model.commit();
    }

    @NotNull
    public final Collection<VirtualFile> getCurrentClassRoots() {
        Library library = this.getPermanentScriptingLibrary();
        if (library == null) {
            return SetsKt.emptySet();
        }
        Library library2 = library;
        VirtualFile[] virtualFileArray = library2.getRootProvider().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        return ArraysKt.toSet((Object[])virtualFileArray);
    }

    private final Map<OrderRootType, Set<String>> getLibraryRoots(Library library) {
        Map map;
        Map $this$getLibraryRoots_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Object[] objectArray = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};
        for (OrderRootType rootType : CollectionsKt.listOf((Object[])objectArray)) {
            Intrinsics.checkNotNull((Object)rootType);
            String[] stringArray = library.getRootProvider().getUrls(rootType);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
            $this$getLibraryRoots_u24lambda_u240.put(rootType, ArraysKt.toSet((Object[])stringArray));
        }
        return MapsKt.build((Map)map);
    }

    private final void addToPermanentIndexImpl(List<String> classpath, List<String> sourceClasspath) {
        Library newLibrary = this.getOrCreatePermanentScriptingLibrary();
        Library.ModifiableModel modifiableModel = newLibrary.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        Library.ModifiableModel model = modifiableModel;
        Map<OrderRootType, Set<String>> existingRoots = this.getLibraryRoots(newLibrary);
        for (String path2 : classpath) {
            OrderRootType orderRootType = OrderRootType.CLASSES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
            KotlinNotebookPermanentIndexService.addToPermanentIndexImpl$addPath(existingRoots, model, path2, orderRootType);
        }
        for (String path2 : sourceClasspath) {
            OrderRootType orderRootType = OrderRootType.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"SOURCES");
            KotlinNotebookPermanentIndexService.addToPermanentIndexImpl$addPath(existingRoots, model, path2, orderRootType);
        }
        model.commit();
    }

    private final Library getPermanentScriptingLibrary() {
        return this.getProjectLibraryTable().getLibraryByName(SCRIPT_DEPENDENCIES_LIBRARY_NAME);
    }

    private final Library getOrCreatePermanentScriptingLibrary() {
        Library library = this.getPermanentScriptingLibrary();
        if (library == null) {
            Library library2 = this.getProjectLibraryTable().createLibrary(SCRIPT_DEPENDENCIES_LIBRARY_NAME);
            library = library2;
            Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"createLibrary(...)");
        }
        return library;
    }

    private static final void addToPermanentIndexImpl$addPath(Map<OrderRootType, ? extends Set<String>> existingRoots, Library.ModifiableModel model, String path2, OrderRootType rootType) {
        if (StringsKt.endsWith$default((String)path2, (String)".jar", (boolean)false, (int)2, null)) {
            Path path3 = Paths.get(path2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            String rootPath = "file://" + PathsKt.getInvariantSeparatorsPathString((Path)path3);
            Set<String> set = existingRoots.get(rootType);
            Intrinsics.checkNotNull(set);
            if (set.contains(rootPath)) {
                return;
            }
            model.addRoot(rootPath, rootType);
        }
    }

    public static final /* synthetic */ void access$addToPermanentIndexImpl(KotlinNotebookPermanentIndexService $this, List classpath, List sourceClasspath) {
        $this.addToPermanentIndexImpl(classpath, sourceClasspath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService$Companion;", "", "<init>", "()V", "SCRIPT_DEPENDENCIES_LIBRARY_NAME", "", "getInstance", "Lcom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookPermanentIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookPermanentIndexService.kt\ncom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,107:1\n30#2,2:108\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookPermanentIndexService.kt\ncom/intellij/kotlin/jupyter/core/projectModel/KotlinNotebookPermanentIndexService$Companion\n*L\n104#1:108,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookPermanentIndexService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinNotebookPermanentIndexService> serviceClass$iv = KotlinNotebookPermanentIndexService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinNotebookPermanentIndexService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

