/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplPreprocessingException;
import org.jetbrains.kotlinx.jupyter.magics.LibrariesAwareMagicsHandler;
import org.jetbrains.kotlinx.jupyter.magics.MagicHandlerFactory;
import org.jetbrains.kotlinx.jupyter.magics.MagicsHandler;
import org.jetbrains.kotlinx.jupyter.magics.UnhandledMagicException;
import org.jetbrains.kotlinx.jupyter.magics.contexts.ContextUtilKt;
import org.jetbrains.kotlinx.jupyter.magics.contexts.LibrariesMagicHandlerContext;
import org.jetbrains.kotlinx.jupyter.magics.contexts.MagicHandlerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompositeMagicsHandler;", "Lorg/jetbrains/kotlinx/jupyter/magics/LibrariesAwareMagicsHandler;", "context", "Lorg/jetbrains/kotlinx/jupyter/magics/contexts/MagicHandlerContext;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/magics/contexts/MagicHandlerContext;)V", "handlers", "", "Lorg/jetbrains/kotlinx/jupyter/magics/MagicsHandler;", "createAndRegister", "", "handlerFactories", "", "Lorg/jetbrains/kotlinx/jupyter/magics/MagicHandlerFactory;", "handle", "magicText", "", "tryIgnoreErrors", "", "parseOnly", "getLibraries", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinitionProducer;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nCompositeMagicsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeMagicsHandler.kt\norg/jetbrains/kotlinx/jupyter/magics/CompositeMagicsHandler\n+ 2 ContextUtil.kt\norg/jetbrains/kotlinx/jupyter/magics/contexts/ContextUtilKt\n*L\n1#1,60:1\n6#2:61\n*S KotlinDebug\n*F\n+ 1 CompositeMagicsHandler.kt\norg/jetbrains/kotlinx/jupyter/magics/CompositeMagicsHandler\n*L\n58#1:61\n*E\n"})
public final class CompositeMagicsHandler
implements LibrariesAwareMagicsHandler {
    @NotNull
    private final MagicHandlerContext context;
    @NotNull
    private final List<MagicsHandler> handlers;

    public CompositeMagicsHandler(@NotNull MagicHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.handlers = new ArrayList();
    }

    public final void createAndRegister(@NotNull List<? extends MagicHandlerFactory> handlerFactories) {
        Intrinsics.checkNotNullParameter(handlerFactories, (String)"handlerFactories");
        for (MagicHandlerFactory magicHandlerFactory : handlerFactories) {
            MagicsHandler handler;
            if (magicHandlerFactory.createIfApplicable(this.context) == null) continue;
            this.handlers.add(handler);
        }
    }

    @Override
    public void handle(@NotNull String magicText, boolean tryIgnoreErrors, boolean parseOnly) {
        Intrinsics.checkNotNullParameter((Object)magicText, (String)"magicText");
        for (MagicsHandler handler : this.handlers) {
            try {
                handler.handle(magicText, tryIgnoreErrors, parseOnly);
                return;
            }
            catch (UnhandledMagicException unhandledMagicException) {
            }
        }
        if (!tryIgnoreErrors && !parseOnly) {
            throw new ReplPreprocessingException("There are no handlers registered for " + magicText, null, 2, null);
        }
    }

    @Override
    @NotNull
    public List<LibraryDefinitionProducer> getLibraries() {
        MagicHandlerContext $this$getContext$iv = this.context;
        boolean $i$f$getContext = false;
        LibrariesMagicHandlerContext librariesMagicHandlerContext = (LibrariesMagicHandlerContext)ContextUtilKt.getContext($this$getContext$iv, Reflection.getOrCreateKotlinClass(LibrariesMagicHandlerContext.class));
        List list = librariesMagicHandlerContext != null ? librariesMagicHandlerContext.getLibraries() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

