/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.streams;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StdinInputStream;", "Ljava/io/InputStream;", "communicationFacility", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;)V", "currentBuf", "", "currentBufPos", "", "initializeCurrentBuf", "read", "b", "off", "len", "shared-compiler"})
public final class StdinInputStream
extends InputStream {
    @NotNull
    private final JupyterCommunicationFacility communicationFacility;
    @Nullable
    private byte[] currentBuf;
    private int currentBufPos;

    public StdinInputStream(@NotNull JupyterCommunicationFacility communicationFacility) {
        Intrinsics.checkNotNullParameter((Object)communicationFacility, (String)"communicationFacility");
        this.communicationFacility = communicationFacility;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] initializeCurrentBuf() {
        byte[] byArray;
        byte[] buf = this.currentBuf;
        if (buf != null) {
            byArray = buf;
        } else {
            void var2_3;
            String string = JupyterCommunicationFacilityKt.getInput$default(this.communicationFacility, null, false, 3, null);
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] newBuf = byArray2;
            this.currentBuf = newBuf;
            this.currentBufPos = 0;
            byArray = var2_3;
        }
        return byArray;
    }

    @Override
    public synchronized int read() {
        byte[] buf = this.initializeCurrentBuf();
        if (this.currentBufPos >= buf.length) {
            this.currentBuf = null;
            return -1;
        }
        int n = this.currentBufPos;
        this.currentBufPos = n + 1;
        return buf[n];
    }

    @Override
    public synchronized int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] buf = this.initializeCurrentBuf();
        int lenLeft = buf.length - this.currentBufPos;
        if (lenLeft <= 0) {
            this.currentBuf = null;
            return -1;
        }
        int lenToRead = Math.min(len, lenLeft);
        for (int i = 0; i < lenToRead; ++i) {
            b[off + i] = buf[this.currentBufPos + i];
        }
        this.currentBufPos += lenToRead;
        return lenToRead;
    }
}

