/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.orm.ddl.DbMappingSettings;
import com.intellij.liquibase.orm.ddl.DbMappingSettingsKt;
import com.intellij.liquibase.orm.ddl.LiquibaseTypes;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nH\u0016J1\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0017H\u0016J1\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\u00172\b\u0010-\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u00060"}, d2={"Lcom/intellij/liquibase/orm/ddl/HsqlMappingSettings;", "Lcom/intellij/liquibase/orm/ddl/DbMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "liquibaseTypes", "Lcom/intellij/liquibase/orm/ddl/LiquibaseTypes;", "sqlSynonymTypes", "", "", "", "getSqlSynonymTypes", "()Ljava/util/Map;", "mappingTypes", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "jdbcTypeCodeMappings", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getJdbcTypeCodeMappings", "isJdbcTypeCodeLengthAvailable", "", "jdbcTypeCode", "", "getSpecificLengthByJdbcTypeCode", "(I)Ljava/lang/Integer;", "defaultValues", "getDefaultValues", "getMaxVarcharLength", "sqlType", "precisionChanged", "attributeColumnSize", "dbColumnSizeInt", "attributeSqlType", "dbSqlType", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "typeChanged", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attrMappedSqlType", "dbType", "oldLength", "lengthChanged", "attrSqlType", "attrColumnSize", "dbColumnSize", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Z", "Companion", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nDbMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/orm/ddl/HsqlMappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1515:1\n1915#2,2:1516\n1915#2,2:1518\n1915#2,2:1520\n13225#3,2:1522\n*S KotlinDebug\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/orm/ddl/HsqlMappingSettings\n*L\n613#1:1516,2\n614#1:1518,2\n620#1:1520,2\n590#1:1522,2\n*E\n"})
public final class HsqlMappingSettings
implements DbMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiquibaseTypes liquibaseTypes;
    @NotNull
    private final Map<String, Collection<String>> sqlSynonymTypes;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> mappingTypes;
    @NotNull
    private final Map<HibernateSqlType, String> jdbcTypeCodeMappings;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> defaultValues;
    private static final int MAX_VARBINARY_PRECISION = 0x1000000;
    private static final int MAX_VARCHAR_LENGTH = 0x1000000;

    /*
     * WARNING - void declaration
     */
    public HsqlMappingSettings(@NotNull Project project) {
        Datatypes.BasicDatatype it;
        void $this$defaultValues_u24lambda_u240;
        Map $this$mappingTypes_u24lambda_u240;
        void it2;
        Pair[] $this$sqlSynonymTypes_u24lambda_u240;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.liquibaseTypes = new LiquibaseTypes(project);
        Pair[] pairArray2 = pairArray = (Pair[])new LinkedHashMap();
        HsqlMappingSettings hsqlMappingSettings = this;
        boolean bl = false;
        $this$sqlSynonymTypes_u24lambda_u240.put("BIGINT", CollectionsKt.listOf((Object)"long"));
        Object[] objectArray = new String[]{"binary", "binary varying", "blob", "longvarbinary"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BLOB", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("BOOLEAN", SetsKt.setOf((Object)"bit"));
        objectArray = new String[]{"character", "NCHAR"};
        $this$sqlSynonymTypes_u24lambda_u240.put("CHAR", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("DATE", CollectionsKt.emptyList());
        objectArray = new String[]{"datetime", "timestamp with time zone", "TIMESTAMP"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DATETIME", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"dec", "numeric", "CURRENCY", "NUMBER"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DECIMAL", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"double precision", "money", "smallmoney", "FLOAT", "real"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DOUBLE", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"integer", "identity", "SMALLINT", "TINYINT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("INT", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("TIME", CollectionsKt.listOf((Object)"time with time zone"));
        objectArray = new String[]{"character varying", "longvarchar", "NVARCHAR", "XML", "CLOB", "NCLOB"};
        $this$sqlSynonymTypes_u24lambda_u240.put("VARCHAR", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("UUID", CollectionsKt.emptyList());
        $this$sqlSynonymTypes_u24lambda_u240 = pairArray;
        boolean $i$a$-let-HsqlMappingSettings$sqlSynonymTypes$32 = false;
        hsqlMappingSettings.sqlSynonymTypes = DbMappingSettingsKt.access$createSynonymMap(project, (Map)it2);
        Map $i$a$-let-HsqlMappingSettings$sqlSynonymTypes$32 = new LinkedHashMap();
        hsqlMappingSettings = this;
        boolean bl2 = false;
        $this$mappingTypes_u24lambda_u240.putAll(this.liquibaseTypes.DATABASE_INDEPENDENT_TYPES);
        if (JpaUtils.isHibernate6Project((Project)project, null)) {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.OffsetDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"OffsetDateTime");
            $this$mappingTypes_u24lambda_u240.put(basicDatatype, "timestamp");
            Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.OffsetTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"OffsetTime");
            $this$mappingTypes_u24lambda_u240.put(basicDatatype2, "time");
            Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.ZonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"ZonedDateTime");
            v3 = $this$mappingTypes_u24lambda_u240.put(basicDatatype3, "timestamp");
        } else {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.OffsetDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"OffsetDateTime");
            $this$mappingTypes_u24lambda_u240.put(basicDatatype, "timestamp with time zone");
            Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.OffsetTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"OffsetTime");
            $this$mappingTypes_u24lambda_u240.put(basicDatatype4, "time with time zone");
            Datatypes.BasicDatatype basicDatatype5 = Datatypes.BasicDatatype.ZonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype5, (String)"ZonedDateTime");
            v3 = $this$mappingTypes_u24lambda_u240.put(basicDatatype5, "timestamp with time zone");
        }
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Calendar;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Calendar");
        $this$mappingTypes_u24lambda_u240.put(basicDatatype, "timestamp with time zone");
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$mappingTypes_u24lambda_u240);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        hsqlMappingSettings.mappingTypes = (Map)immutableMap;
        pairArray = new Pair[]{TuplesKt.to((Object)HibernateSqlType.JSON, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONG32VARCHAR, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONGVARBINARY, (Object)"VARBINARY"), TuplesKt.to((Object)HibernateSqlType.LONGNVARCHAR, (Object)"NVARCHAR"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP_WITH_TIMEZONE, (Object)"timestamp with time zone"), TuplesKt.to((Object)HibernateSqlType.TIME_WITH_TIMEZONE, (Object)"time with time zone")};
        this.jdbcTypeCodeMappings = MapsKt.plus(this.liquibaseTypes.getJDBC_TYPE_CODE_TYPES(), (Map)MapsKt.mapOf((Pair[])pairArray));
        $this$mappingTypes_u24lambda_u240 = new LinkedHashMap();
        hsqlMappingSettings = this;
        boolean bl3 = false;
        Datatypes.BasicDatatype basicDatatype6 = Datatypes.BasicDatatype.Boolean;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype6, (String)"Boolean");
        $this$defaultValues_u24lambda_u240.put(basicDatatype6, "false");
        Datatypes.BasicDatatype basicDatatype7 = Datatypes.BasicDatatype.ByteArray;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype7, (String)"ByteArray");
        $this$defaultValues_u24lambda_u240.put(basicDatatype7, "''");
        Iterable $this$forEach$iv = DbMappingSettingsKt.access$getDATE_TYPES$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_date");
        }
        $this$forEach$iv = DbMappingSettingsKt.access$getDATATIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_timestamp");
        }
        Datatypes.BasicDatatype basicDatatype8 = Datatypes.BasicDatatype.BigDecimal;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype8, (String)"BigDecimal");
        $this$defaultValues_u24lambda_u240.put(basicDatatype8, "0");
        Datatypes.BasicDatatype basicDatatype9 = Datatypes.BasicDatatype.Double;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype9, (String)"Double");
        $this$defaultValues_u24lambda_u240.put(basicDatatype9, "0");
        Datatypes.BasicDatatype basicDatatype10 = Datatypes.BasicDatatype.Integer;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype10, (String)"Integer");
        $this$defaultValues_u24lambda_u240.put(basicDatatype10, "0");
        Datatypes.BasicDatatype basicDatatype11 = Datatypes.BasicDatatype.Long;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype11, (String)"Long");
        $this$defaultValues_u24lambda_u240.put(basicDatatype11, "0");
        Datatypes.BasicDatatype basicDatatype12 = Datatypes.BasicDatatype.String;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype12, (String)"String");
        $this$defaultValues_u24lambda_u240.put(basicDatatype12, "''");
        $this$forEach$iv = DbMappingSettingsKt.access$getTIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u240.put(it, "current_time");
        }
        ImmutableMap immutableMap2 = ImmutableMap.copyOf((Map)$this$defaultValues_u24lambda_u240);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"run(...)");
        hsqlMappingSettings.defaultValues = (Map)immutableMap2;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        return this.sqlSynonymTypes;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getMappingTypes() {
        return this.mappingTypes;
    }

    @Override
    @NotNull
    public Map<HibernateSqlType, String> getJdbcTypeCodeMappings() {
        return this.jdbcTypeCodeMappings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isJdbcTypeCodeLengthAvailable(int jdbcTypeCode) {
        if (DbMappingSettings.super.isJdbcTypeCodeLengthAvailable(jdbcTypeCode)) return true;
        HibernateSqlType[] hibernateSqlTypeArray = new HibernateSqlType[]{HibernateSqlType.BINARY, HibernateSqlType.VARBINARY, HibernateSqlType.GEOGRAPHY, HibernateSqlType.GEOMETRY, HibernateSqlType.INET, HibernateSqlType.LONGVARBINARY, HibernateSqlType.LONGNVARCHAR, HibernateSqlType.LONGVARCHAR, HibernateSqlType.POINT};
        HibernateSqlType[] $this$any$iv = hibernateSqlTypeArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            HibernateSqlType element$iv;
            HibernateSqlType it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it.equalsByCode(Integer.valueOf(jdbcTypeCode))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    @Nullable
    public Integer getSpecificLengthByJdbcTypeCode(int jdbcTypeCode) {
        return HibernateSqlType.INET.equalsByCode(Integer.valueOf(jdbcTypeCode)) ? Integer.valueOf(19) : (HibernateSqlType.LONGVARCHAR.equalsByCode(Integer.valueOf(jdbcTypeCode)) || HibernateSqlType.LONGNVARCHAR.equalsByCode(Integer.valueOf(jdbcTypeCode)) || HibernateSqlType.LONGVARBINARY.equalsByCode(Integer.valueOf(jdbcTypeCode)) ? Integer.valueOf(32600) : DbMappingSettings.super.getSpecificLengthByJdbcTypeCode(jdbcTypeCode));
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public int getMaxVarcharLength(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        return 0x1000000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean precisionChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (Intrinsics.areEqual((Object)dbColumnSizeInt, (Object)attributeColumnSize)) return false;
        Integer n = dbColumnSizeInt;
        int n2 = 128;
        if (n == null) return true;
        if (n != n2) return true;
        if (attributeColumnSize == null) return false;
        if (attributeColumnSize == 0) return false;
        return true;
    }

    @Override
    public boolean typeChanged(@NotNull Datatype datatype, @NotNull String attrMappedSqlType, @NotNull String dbType, int oldLength) {
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        Intrinsics.checkNotNullParameter((Object)attrMappedSqlType, (String)"attrMappedSqlType");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object columnDbType = string;
        if (Intrinsics.areEqual((Object)"varbinary", (Object)columnDbType) && oldLength == 0x1000000) {
            columnDbType = "longvarbinary";
        }
        if (Intrinsics.areEqual((Object)"varchar", (Object)columnDbType) && oldLength == 0x1000000) {
            columnDbType = "longvarchar";
        }
        if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Boolean) && Intrinsics.areEqual((Object)"bit", (Object)columnDbType) && oldLength > 1) {
            columnDbType = (String)columnDbType + "(" + oldLength + ")";
        }
        return !this.isConvertibleType(attrMappedSqlType, (String)columnDbType);
    }

    @Override
    public boolean lengthChanged(@NotNull String attrSqlType, @NotNull String dbSqlType, @Nullable Integer attrColumnSize, @Nullable Integer dbColumnSize) {
        Intrinsics.checkNotNullParameter((Object)attrSqlType, (String)"attrSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (!DbMappingSettings.super.lengthChanged(attrSqlType, dbSqlType, attrColumnSize, dbColumnSize)) {
            return false;
        }
        return !LiquibaseTypes.Companion.isClobType(attrSqlType) || !LiquibaseTypes.Companion.isClobType(dbSqlType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/liquibase/orm/ddl/HsqlMappingSettings$Companion;", "", "<init>", "()V", "MAX_VARBINARY_PRECISION", "", "MAX_VARCHAR_LENGTH", "intellij.liquibase.orm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

