/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui.settings.db;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.ui.StudioMigLayout;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.liquibase.orm.config.DatabaseInfo;
import com.intellij.liquibase.orm.config.DatabaseMigrationState;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.LC;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\u0001H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/orm/gui/settings/db/DbTypeSelectionPanel;", "Ljavax/swing/JPanel;", "selectedTypes", "", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "columnComponentCount", "", "<init>", "(Ljava/util/List;I)V", "dbTypeCheckBoxMap", "", "Ljavax/swing/JCheckBox;", "createFormPanel", "commit", "", "migrationState", "Lcom/intellij/liquibase/orm/config/DatabaseMigrationState;", "addActionListener", "listener", "Ljava/awt/event/ActionListener;", "setSelectedDbIds", "selectedDatabaseIds", "", "isAnySelected", "", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nDbTypeSelectionPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbTypeSelectionPanel.kt\ncom/intellij/liquibase/orm/gui/settings/db/DbTypeSelectionPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,98:1\n1924#2,3:99\n777#2:102\n873#2,2:103\n1586#2:105\n1661#2,3:106\n296#2,2:109\n777#2:111\n873#2:112\n1586#2:113\n1661#2,3:114\n874#2:117\n1915#2,2:118\n1915#2,2:120\n1#3:122\n193#4,3:123\n*S KotlinDebug\n*F\n+ 1 DbTypeSelectionPanel.kt\ncom/intellij/liquibase/orm/gui/settings/db/DbTypeSelectionPanel\n*L\n30#1:99,3\n60#1:102\n60#1:103,2\n60#1:105\n60#1:106,3\n64#1:109,2\n78#1:111\n78#1:112\n79#1:113\n79#1:114,3\n78#1:117\n81#1:118,2\n85#1:120,2\n95#1:123,3\n*E\n"})
public final class DbTypeSelectionPanel
extends JPanel {
    private final int columnComponentCount;
    @NotNull
    private final Map<DbType, JCheckBox> dbTypeCheckBoxMap;

    /*
     * WARNING - void declaration
     */
    public DbTypeSelectionPanel(@NotNull List<? extends DbType> selectedTypes, int columnComponentCount) {
        Intrinsics.checkNotNullParameter(selectedTypes, (String)"selectedTypes");
        super((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)10), 0, 2, null));
        this.columnComponentCount = columnComponentCount;
        this.dbTypeCheckBoxMap = new LinkedHashMap();
        this.dbTypeCheckBoxMap.clear();
        JPanel form = null;
        form = this.createFormPanel();
        Iterable $this$forEachIndexed$iv = DbType.Companion.getUniqueMainTypes();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void dbType;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DbType dbType2 = (DbType)item$iv;
            int index = n;
            boolean bl = false;
            JBLabel label = new JBLabel(dbType.getId());
            label.setIcon(JpaUiUtil.getDbTypeIcon((DbType)dbType));
            JBCheckBox checkBox = new JBCheckBox();
            if (selectedTypes.contains(dbType)) {
                checkBox.setSelected(true);
            }
            JPanel it = form;
            boolean bl2 = false;
            it.add((Component)label);
            it.add((Component)checkBox);
            if (index % this.columnComponentCount == this.columnComponentCount - 1) {
                this.add(form);
                form = this.createFormPanel();
            }
            this.dbTypeCheckBoxMap.put((DbType)dbType, (JCheckBox)checkBox);
        }
    }

    public /* synthetic */ DbTypeSelectionPanel(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        this(list, n);
    }

    private final JPanel createFormPanel() {
        int[] nArray = new int[]{1};
        return new JPanel((LayoutManager)new StudioMigLayout(new LC().insets("0px").fillX().hideMode(3).wrapAfter(2), new AC().growPrio(200, nArray), new AC().align("top")));
    }

    /*
     * WARNING - void declaration
     */
    public final void commit(@NotNull DatabaseMigrationState migrationState) {
        void $this$filterTo$iv$iv;
        List<DatabaseInfo> list;
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)migrationState, (String)"migrationState");
        Iterable $this$filter$iv = this.dbTypeCheckBoxMap.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        List<DatabaseInfo> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((JCheckBox)it.getValue()).isSelected()) continue;
            destination$iv$iv.add((DatabaseInfo)element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            list = destination$iv$iv;
            boolean bl = false;
            list.add((DatabaseInfo)((DbType)it.getKey()));
        }
        List selectedTypes = destination$iv$iv;
        List<DatabaseInfo> databaseInfos = migrationState.getDatabaseInfos();
        for (DbType dbType : selectedTypes) {
            void it2;
            Iterator iterator;
            Object $this$firstOrNull$iv;
            block8: {
                $this$firstOrNull$iv = databaseInfos;
                boolean $i$f$firstOrNull = false;
                Iterator item$iv$iv = $this$firstOrNull$iv.iterator();
                while (item$iv$iv.hasNext()) {
                    Iterator element$iv = item$iv$iv.next();
                    DatabaseInfo it3 = (DatabaseInfo)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it3.getDbmsId(), (Object)dbType.getId())) continue;
                    iterator = element$iv;
                    break block8;
                }
                iterator = null;
            }
            DatabaseInfo existing = (DatabaseInfo)((Object)iterator);
            if (existing != null) {
                existing.setEnabled(true);
                continue;
            }
            Object $i$f$firstOrNull = $this$firstOrNull$iv = new DatabaseInfo();
            list = databaseInfos;
            boolean bl = false;
            it2.setDbmsId(dbType.getId());
            it2.setEnabled(true);
            list.add((DatabaseInfo)$this$firstOrNull$iv);
        }
        Iterable $this$filter$iv2 = databaseInfos;
        boolean $i$f$filter2 = false;
        Iterable $this$firstOrNull$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            DatabaseInfo databaseInfo = (DatabaseInfo)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = selectedTypes;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void dbType;
                DbType dbType2 = (DbType)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(dbType.getId());
            }
            if (!(!CollectionsKt.contains((Iterable)((List)destination$iv$iv3), (Object)databaseInfo.getDbmsId()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unselectedDatabaseInfos = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = unselectedDatabaseInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInfo it4 = (DatabaseInfo)element$iv;
            boolean bl = false;
            it4.setEnabled(false);
        }
    }

    public final void addActionListener(@NotNull ActionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Iterable $this$forEach$iv = this.dbTypeCheckBoxMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JCheckBox it = (JCheckBox)element$iv;
            boolean bl = false;
            it.addActionListener(listener);
        }
    }

    public final void setSelectedDbIds(@NotNull List<String> selectedDatabaseIds) {
        Intrinsics.checkNotNullParameter(selectedDatabaseIds, (String)"selectedDatabaseIds");
        Set<Map.Entry<DbType, JCheckBox>> dbTypeCheckBoxEntries = this.dbTypeCheckBoxMap.entrySet();
        for (Map.Entry<DbType, JCheckBox> dbTypeCheckBox : dbTypeCheckBoxEntries) {
            Object v0;
            JCheckBox jCheckBox;
            block2: {
                Iterable iterable = selectedDatabaseIds;
                jCheckBox = dbTypeCheckBox.getValue();
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)dbTypeCheckBox.getKey().getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            jCheckBox.setSelected(v0 != null);
        }
    }

    public final boolean isAnySelected() {
        boolean bl;
        block3: {
            Map<DbType, JCheckBox> $this$any$iv = this.dbTypeCheckBoxMap;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<DbType, JCheckBox>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<DbType, JCheckBox> element$iv;
                    Map.Entry<DbType, JCheckBox> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!it.getValue().isSelected()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public DbTypeSelectionPanel() {
        this(null, 0, 3, null);
    }
}

