/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DiffPreviewProvider {
    public static final ExtensionPointName<DiffPreviewProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.diffPreviewProvider");
    @NonNls
    private static final String LEFT_TEXT = "class MyClass {\n  int value;\n\n  void leftOnly() {}\n\n  void foo() {\n   // Left changes\n  }\n\n  void bar() {\n\n  }\n}\n\n\n";
    @NonNls
    private static final String CENTER_TEXT = "class MyClass {\n  int value;\n\n  void foo() {\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n\n  }\n}\n\n\n";
    @NonNls
    private static final String RIGHT_TEXT = "class MyClass {\n  long value;\n\n  void foo() {\n   // Right changes\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n  }\n\n}\n\n\n";

    public abstract DiffContent @NotNull [] createContents();

    public static DiffContent @NotNull [] getContents() {
        List providers = EP_NAME.getExtensionList();
        if (!providers.isEmpty()) {
            DiffContent[] diffContentArray = ((DiffPreviewProvider)providers.get(0)).createContents();
            if (diffContentArray == null) {
                DiffPreviewProvider.$$$reportNull$$$0(0);
            }
            return diffContentArray;
        }
        return DiffPreviewProvider.createContent(LEFT_TEXT, CENTER_TEXT, RIGHT_TEXT, (FileType)StdFileTypes.JAVA);
    }

    public static DiffContent @NotNull [] createContent(@NotNull String left, @NotNull String center, @NotNull String right, @NotNull FileType fileType) {
        if (left == null) {
            DiffPreviewProvider.$$$reportNull$$$0(1);
        }
        if (center == null) {
            DiffPreviewProvider.$$$reportNull$$$0(2);
        }
        if (right == null) {
            DiffPreviewProvider.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            DiffPreviewProvider.$$$reportNull$$$0(4);
        }
        DiffContent[] diffContentArray = new DiffContent[]{DiffPreviewProvider.createContent(left, fileType), DiffPreviewProvider.createContent(center, fileType), DiffPreviewProvider.createContent(right, fileType)};
        if (diffContentArray == null) {
            DiffPreviewProvider.$$$reportNull$$$0(5);
        }
        return diffContentArray;
    }

    @NotNull
    private static DiffContent createContent(@NotNull String text, @NotNull FileType fileType) {
        if (text == null) {
            DiffPreviewProvider.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            DiffPreviewProvider.$$$reportNull$$$0(7);
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(text, fileType);
        if (documentContent == null) {
            DiffPreviewProvider.$$$reportNull$$$0(8);
        }
        return documentContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "center";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

