/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.CustomizableIntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionWrapper
implements LocalQuickFix,
IntentionAction,
ActionClassHolder,
CustomizableIntentionActionDelegate {
    private final IntentionAction myAction;

    public IntentionWrapper(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionWrapper.$$$reportNull$$$0(0);
        }
        this.myAction = action;
    }

    @NotNull
    public String getName() {
        String string = this.myAction.getText();
        if (string == null) {
            IntentionWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myAction.getText();
        if (string == null) {
            IntentionWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myAction.getFamilyName();
        if (string == null) {
            IntentionWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            IntentionWrapper.$$$reportNull$$$0(4);
        }
        return this.myAction.isAvailable(project, editor, psiFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            IntentionWrapper.$$$reportNull$$$0(5);
        }
        this.myAction.invoke(project, editor, psiFile);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            IntentionWrapper.$$$reportNull$$$0(6);
        }
        return this.myAction.getElementToMakeWritable(file);
    }

    public boolean startInWriteAction() {
        return this.myAction.startInWriteAction();
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            IntentionWrapper.$$$reportNull$$$0(7);
        }
        return intentionAction;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PsiFile file;
        if (project == null) {
            IntentionWrapper.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            IntentionWrapper.$$$reportNull$$$0(9);
        }
        PsiFile psiFile = file = (element = descriptor.getPsiElement()) == null ? null : element.getContainingFile();
        if (file != null) {
            Editor editor;
            FileEditor editor2 = FileEditorManager.getInstance((Project)project).getSelectedEditor(file.getVirtualFile());
            if (editor2 instanceof TextEditor) {
                TextEditor te = (TextEditor)editor2;
                editor = te.getEditor();
            } else {
                editor = null;
            }
            this.myAction.invoke(project, editor, file);
        }
    }

    @NotNull
    public Class<?> getActionClass() {
        Class clazz = this.getAction().getClass();
        if (clazz == null) {
            IntentionWrapper.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    @NotNull
    public IntentionAction getDelegate() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            IntentionWrapper.$$$reportNull$$$0(11);
        }
        return intentionAction;
    }

    @Contract(value="null, _ -> null")
    public static LocalQuickFix wrapToQuickFix(@Nullable IntentionAction action, @NotNull PsiFile file) {
        if (file == null) {
            IntentionWrapper.$$$reportNull$$$0(12);
        }
        if (action == null) {
            return null;
        }
        if (action instanceof LocalQuickFix) {
            return (LocalQuickFix)action;
        }
        ModCommandAction modCommandAction = action.asModCommandAction();
        if (modCommandAction != null) {
            return LocalQuickFix.from((ModCommandAction)modCommandAction);
        }
        return new IntentionWrapper(action);
    }

    public static LocalQuickFix @NotNull [] wrapToQuickFixes(IntentionAction @NotNull [] actions, @NotNull PsiFile file) {
        if (file == null) {
            IntentionWrapper.$$$reportNull$$$0(13);
        }
        if (actions == null) {
            IntentionWrapper.$$$reportNull$$$0(14);
        }
        if (actions.length == 0) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                IntentionWrapper.$$$reportNull$$$0(15);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = new LocalQuickFix[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            fixes[i] = IntentionWrapper.wrapToQuickFix(actions[i], file);
        }
        if (fixes == null) {
            IntentionWrapper.$$$reportNull$$$0(16);
        }
        return fixes;
    }

    @NotNull
    public static @NotNull List<@NotNull LocalQuickFix> wrapToQuickFixes(@NotNull List<? extends IntentionAction> actions, @NotNull PsiFile file) {
        if (actions == null) {
            IntentionWrapper.$$$reportNull$$$0(17);
        }
        if (file == null) {
            IntentionWrapper.$$$reportNull$$$0(18);
        }
        if (actions.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                IntentionWrapper.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(actions.size());
        for (IntentionAction intentionAction : actions) {
            ContainerUtil.addIfNotNull(fixes, (Object)IntentionWrapper.wrapToQuickFix(intentionAction, file));
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            IntentionWrapper.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            IntentionWrapper.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            IntentionWrapper.$$$reportNull$$$0(22);
        }
        if (psiFile == null) {
            IntentionWrapper.$$$reportNull$$$0(23);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.myAction.generatePreview(project, editor, psiFile);
        if (intentionPreviewInfo == null) {
            IntentionWrapper.$$$reportNull$$$0(24);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 10, 11, 15, 16, 19, 20, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/IntentionWrapper";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/IntentionWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToQuickFixes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapToQuickFix";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapToQuickFixes";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 10, 11, 15, 16, 19, 20, 24 -> new IllegalStateException(string);
        };
    }
}

