/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ProcessorWithThrottledCancellationCheck<V>
implements Processor<V> {
    private static final int DEFAULT_CHECK_CANCELLED_EACH = 16;
    private final Processor<? super V> wrapped;
    private final int checkCancelledEach;
    private int iterationNo;

    public ProcessorWithThrottledCancellationCheck(@NotNull Processor<? super V> wrapped) {
        if (wrapped == null) {
            ProcessorWithThrottledCancellationCheck.$$$reportNull$$$0(0);
        }
        this(wrapped, 16);
    }

    public ProcessorWithThrottledCancellationCheck(@NotNull Processor<? super V> wrapped, int checkCancelledEach) {
        if (wrapped == null) {
            ProcessorWithThrottledCancellationCheck.$$$reportNull$$$0(1);
        }
        if (checkCancelledEach <= 0) {
            throw new IllegalArgumentException("checkCancelledEach(=" + checkCancelledEach + ") must be positive");
        }
        this.wrapped = wrapped;
        this.checkCancelledEach = checkCancelledEach;
    }

    public boolean process(V v) {
        ++this.iterationNo;
        if (this.iterationNo >= this.checkCancelledEach) {
            this.iterationNo = 0;
            ProgressManager.checkCanceled();
        }
        return this.wrapped.process(v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/intellij/util/indexing/ProcessorWithThrottledCancellationCheck", "<init>"));
    }
}

