/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.configuration;

import com.intellij.codeInsight.template.emmet.configuration.CssPrefixInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="CssEmmetOptions", storages={@Storage(value="emmet.xml")}, category=SettingsCategory.CODE)
public final class CssEmmetOptions
implements PersistentStateComponent<CssEmmetOptions> {
    private static final Logger LOG = Logger.getInstance(CssEmmetOptions.class);
    private boolean myCssEmmetEnabled = true;
    private boolean myFuzzySearchEnabled = false;
    private boolean myAutoInsertCssPrefixedEnabled = true;
    private boolean myUnknownPropertiesExpansionEnabled = false;
    @NotNull
    private Object2IntMap<String> prefixes = new Object2IntOpenHashMap();

    public CssEmmetOptions() {
        this.prefixes.defaultReturnValue(-1);
    }

    public boolean isCssEmmetEnabled() {
        return this.myCssEmmetEnabled;
    }

    public void setCssEmmetEnabled(boolean cssEmmetEnabled) {
        this.myCssEmmetEnabled = cssEmmetEnabled;
    }

    public boolean isFuzzySearchEnabled() {
        return this.myFuzzySearchEnabled;
    }

    public void setFuzzySearchEnabled(boolean fuzzySearchEnabled) {
        this.myFuzzySearchEnabled = fuzzySearchEnabled;
    }

    public boolean isAutoInsertCssPrefixedEnabled() {
        return this.myAutoInsertCssPrefixedEnabled;
    }

    public void setAutoInsertCssPrefixedEnabled(boolean autoInsertCssPrefixedEnabled) {
        this.myAutoInsertCssPrefixedEnabled = autoInsertCssPrefixedEnabled;
    }

    public void setPrefixInfo(Collection<CssPrefixInfo> prefixInfos) {
        this.prefixes = new Object2IntOpenHashMap();
        for (CssPrefixInfo state : prefixInfos) {
            this.prefixes.put((Object)state.getPropertyName(), state.toIntegerValue());
        }
    }

    public CssPrefixInfo getPrefixStateForProperty(String propertyName) {
        return CssPrefixInfo.fromIntegerValue(propertyName, this.getPrefixes().getInt((Object)propertyName));
    }

    public Set<CssPrefixInfo> getAllPrefixInfo() {
        Object2IntMap<String> prefixes = this.getPrefixes();
        HashSet<CssPrefixInfo> result = new HashSet<CssPrefixInfo>(prefixes.size());
        for (Object2IntMap.Entry entry : prefixes.object2IntEntrySet()) {
            result.add(CssPrefixInfo.fromIntegerValue((String)entry.getKey(), entry.getIntValue()));
        }
        return result;
    }

    @NotNull
    public Object2IntMap<String> getPrefixes() {
        if (this.prefixes.isEmpty()) {
            this.prefixes = CssEmmetOptions.loadDefaultPrefixes();
        }
        Object2IntMap<String> object2IntMap = this.prefixes;
        if (object2IntMap == null) {
            CssEmmetOptions.$$$reportNull$$$0(0);
        }
        return object2IntMap;
    }

    public void setPrefixes(@NotNull Object2IntMap<String> prefixes) {
        if (prefixes == null) {
            CssEmmetOptions.$$$reportNull$$$0(1);
        }
        this.prefixes = prefixes;
    }

    @NotNull
    public CssEmmetOptions getState() {
        CssEmmetOptions cssEmmetOptions = this;
        if (cssEmmetOptions == null) {
            CssEmmetOptions.$$$reportNull$$$0(2);
        }
        return cssEmmetOptions;
    }

    public void loadState(@NotNull CssEmmetOptions state) {
        if (state == null) {
            CssEmmetOptions.$$$reportNull$$$0(3);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static CssEmmetOptions getInstance() {
        return (CssEmmetOptions)ApplicationManager.getApplication().getService(CssEmmetOptions.class);
    }

    private static Object2IntMap<String> loadDefaultPrefixes() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        result.defaultReturnValue(-1);
        try {
            Element prefixesElement;
            Element rootElement = JDOMUtil.load((InputStream)CssEmmetOptions.class.getResourceAsStream("emmet_default_options.xml"));
            if (rootElement == null) {
                LOG.error("Failed to load default emmet options from emmet_default_options.xml");
            }
            if ((prefixesElement = rootElement.getChild("prefixes")) != null) {
                for (Element entryElement : prefixesElement.getChildren("entry")) {
                    String propertyName = entryElement.getAttributeValue("key");
                    int value = StringUtil.parseInt((String)entryElement.getAttributeValue("value"), (int)0);
                    result.put((Object)propertyName, value);
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance(CssEmmetOptions.class).warn((Throwable)e);
            return result;
        }
        return result;
    }

    public boolean isUnknownPropertiesExpansionEnabled() {
        return this.myUnknownPropertiesExpansionEnabled;
    }

    public void setUnknownPropertiesExpansionEnabled(boolean expandUnknownProperties) {
        this.myUnknownPropertiesExpansionEnabled = expandUnknownProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/configuration/CssEmmetOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixes";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/configuration/CssEmmetOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPrefixes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

