/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramActionsListener;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.LazyPsiElementHolder;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.GraphStructureViewBuilderSetup;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.uml.EmptyDiagramProvider;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphComponent;
import com.intellij.uml.editors.DiagramDocumentAdapter;
import com.intellij.uml.editors.DiagramTextEditorAdapter;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.DiagramCanvasLocationService;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlFileEditorImpl
extends UserDataHolderBase
implements DiagramFileEditor,
GraphBuilderDisplay,
PossiblyDumbAware,
UiDataProvider {
    @NotNull
    private static final Logger LOG = Logger.getInstance(UmlFileEditorImpl.class);
    @NotNull
    @NonNls
    static final String NAME = "UML";
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private UmlGraphComponent myGraphComponent;
    @NotNull
    private final BorderLayoutPanel myPanel;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final NotNullLazyValue<StructureViewBuilder> myStructureViewBuilder;
    @NotNull
    private final DocumentReference myDocumentReference;
    private final boolean myIsOpenedForTheFirstTime;
    @NotNull
    private final AtomicBoolean myIsDisposed;

    public UmlFileEditorImpl(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(1);
        }
        this.myIsDisposed = new AtomicBoolean();
        this.myBuilder = builder;
        this.myFile = file;
        this.myStructureViewBuilder = NotNullLazyValue.atomicLazy(() -> GraphStructureViewBuilderSetup.setupFor(this.myBuilder.getGraphBuilder(), (UiDataProvider)this));
        this.myGraphComponent = new UmlGraphComponent(this.myBuilder);
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myGraphComponent.getComponent());
        this.myComponent = UiDataProvider.wrapComponent((JComponent)this.myPanel, (UiDataProvider)this);
        this.myIsOpenedForTheFirstTime = UmlFileEditorImpl.isOpenedForTheFirstTime(builder, file);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        Disposer.register((Disposable)this, (Disposable)this.myGraphComponent);
        this.myBuilder.initialize();
        this.myBuilder.setEditor(this);
        this.myBuilder.getPresentationModel().registerActions();
        this.createAndRegisterListeners();
        this.myDocumentReference = DocumentReferenceManager.getInstance().create((Document)new DiagramDocumentAdapter(this));
    }

    @NotNull
    public GraphBuilder<?, ?> getCurrentViewBuilder() {
        GraphBuilder<DiagramNode<?>, DiagramEdge<?>> graphBuilder = this.getViewBuilder().getGraphBuilder();
        if (graphBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(2);
        }
        return graphBuilder;
    }

    public void setCurrentViewBuilder(@NotNull GraphBuilder<?, ?> graphViewBuilder) {
        if (graphViewBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(3);
        }
        DiagramBuilder diagramBuilder = DiagramBuilderFactory.getInstance().fromGraphBuilder(graphViewBuilder, this.getModelBuilder());
        diagramBuilder.setEditor(this);
        this.myGraphComponent = new UmlGraphComponent(diagramBuilder);
        this.myPanel.removeAll();
        this.myPanel.addToCenter((Component)this.myGraphComponent.getComponent());
        this.myPanel.repaint();
        this.myPanel.revalidate();
        Disposer.register((Disposable)this, (Disposable)this.myGraphComponent);
        ApplicationManager.getApplication().invokeLater(() -> {
            IdeFocusManager.getInstance((Project)graphViewBuilder.getProject()).requestFocus((Component)diagramBuilder.getView().getCanvasComponent(), true);
            GraphAnimationService.getInstance().fitContent(diagramBuilder.getView(), false);
        });
    }

    private static boolean isOpenedForTheFirstTime(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(4);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(5);
        }
        FileEditorProvider umlEditorProvider = FileEditorProviderManager.getInstance().getProvider("UmlEditorProvider");
        assert (umlEditorProvider != null);
        EditorHistoryManager historyManager = EditorHistoryManager.getInstance((Project)builder.getProject());
        FileEditorState historyState = historyManager.getState(file, umlEditorProvider);
        return historyState == null || historyState == FileEditorState.INSTANCE;
    }

    private void createAndRegisterListeners() {
        final Project project = this.getModelBuilder().getProject();
        MyFileEditorManagerListener fileEditorListener = new MyFileEditorManagerListener(this.getModelBuilder(), this.myFile);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        if (this.isEditableFile()) {
            MyExternalChangeListener externalChangeListener = new MyExternalChangeListener();
            this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)externalChangeListener, (Disposable)this);
            MyDiagramListener diagramListener = new MyDiagramListener(project, externalChangeListener);
            project.getMessageBus().connect((Disposable)this).subscribe(DiagramActionsListener.TOPIC, (Object)diagramListener);
        }
        MyGraphSelectionListener graphSelectionListener = new MyGraphSelectionListener();
        this.getModelBuilder().getGraph().addGraph2DSelectionListener((Graph2DSelectionListener)graphSelectionListener);
        Disposer.register((Disposable)this, (Disposable)graphSelectionListener);
        DiagramProvider.DIAGRAM_PROVIDER.addExtensionPointListener(new ExtensionPointListener<DiagramProvider<?>>(){

            public void extensionRemoved(@NotNull DiagramProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (extension.getClass() == UmlFileEditorImpl.this.getModelBuilder().getProvider().getClass()) {
                    FileEditorManager.getInstance((Project)project).closeFile(UmlFileEditorImpl.this.myFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/uml/UmlFileEditorImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static FileEditorManagerListener createFileEditorListener(@NotNull Project project, @NotNull VirtualFile file, @NotNull DiagramBuilder builder) {
        if (project == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(6);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(8);
        }
        return new MyFileEditorManagerListener(builder, file);
    }

    public boolean isUnknownProvider() {
        return this.getModelBuilder().getProvider() instanceof EmptyDiagramProvider;
    }

    public boolean isEditableFile() {
        return !(this.myFile instanceof UmlVirtualFileSystem.UmlVirtualFile) && !this.isUnknownProvider() && "uml".equalsIgnoreCase(this.myFile.getExtension());
    }

    @Override
    public boolean isOpenedForTheFirstTime() {
        return this.myIsOpenedForTheFirstTime;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @NotNull
    public UmlGraphComponent getGraphComponent() {
        UmlGraphComponent umlGraphComponent = this.myGraphComponent;
        if (umlGraphComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(10);
        }
        return umlGraphComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myGraphComponent.getComponent();
        if (jComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    @NotNull
    @NonNls
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(12);
        }
        FileEditorState fileEditorState = switch (level) {
            default -> throw new MatchException(null, null);
            case FileEditorStateLevel.UNDO -> FileEditorState.INSTANCE;
            case FileEditorStateLevel.NAVIGATION -> {
                if (UmlFileEditorImpl.isJourneyViewComponent(this.getModelBuilder().getView())) {
                    yield FileEditorState.INSTANCE;
                }
                yield DiagramState.makeBuilderSnapshot(this.getModelBuilder());
            }
            case FileEditorStateLevel.FULL -> DiagramState.makeBuilderSnapshot(this.getModelBuilder());
        };
        if (fileEditorState == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(13);
        }
        return fileEditorState;
    }

    private static boolean isJourneyViewComponent(@NotNull Graph2DView view) {
        if (view == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(14);
        }
        return view.getJComponent() != null && ClientProperty.isTrue((Component)view.getJComponent(), (Object)"Journey-View-Component-Key");
    }

    public void setState(@NotNull FileEditorState editorState) {
        if (editorState == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(15);
        }
        if (editorState instanceof DiagramState) {
            DumbService.getInstance((Project)this.getModelBuilder().getProject()).runWhenSmart(() -> this.setUmlState((DiagramState)editorState));
        }
    }

    @Override
    public void setLoading(boolean isLoading) {
        this.myGraphComponent.setLoading(isLoading);
    }

    @Override
    public void setUmlState(@Nullable DiagramState state) {
        if (state == null) {
            return;
        }
        state.restoreTo(this.getModelBuilder());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myIsDisposed.get();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(16);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(17);
        }
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        if (!EDT.isCurrentThreadEdt()) {
            return null;
        }
        return (StructureViewBuilder)this.myStructureViewBuilder.getValue();
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            ReopenInfo.copyIfNeeded(this.myFile, this.getModelBuilder());
            DiagramNodeEditingManager.getInstance().dropLastActiveNodeEditor();
            Optional.ofNullable(this.myDocumentReference.getDocument()).map(it -> (DiagramDocumentAdapter)((Object)((Object)ObjectUtils.tryCast((Object)it, DiagramDocumentAdapter.class)))).ifPresent(it -> Disposer.dispose((Disposable)it));
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(18);
        }
        DiagramTextEditorAdapter adapter = new DiagramTextEditorAdapter(this);
        sink.set(PlatformCoreDataKeys.FILE_EDITOR, (Object)this);
        sink.set(CommonDataKeys.EDITOR, (Object)adapter);
        sink.set(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE, (Object)adapter);
    }

    static void uiDataSnapshot(@NotNull DataSink sink, final @NotNull DiagramBuilder builder) {
        DiagramPresentationModel presentationModel;
        if (sink == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(20);
        }
        sink.set(CommonDataKeys.PROJECT, (Object)builder.getProject());
        sink.set(DiagramDataKeys.BUILDER, (Object)builder);
        sink.set(FileChooserKeys.DELETE_ACTION_AVAILABLE, (Object)false);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"Class_diagram");
        List selectedNodes = ContainerUtil.mapNotNull((Collection)GraphSelectionService.getInstance().getSelectedNodes(builder.getGraph()), it -> builder.getNodeObject((Node)it));
        final DiagramNode singleSelectedNode = selectedNodes.size() == 1 ? (DiagramNode)selectedNodes.get(0) : null;
        DiagramExtras<?> extras = builder.getProvider().getExtras();
        extras.uiDataSnapshot(sink, selectedNodes, builder);
        DiagramNodeEditingManager editingManager = DiagramNodeEditingManager.getInstance();
        sink.set(PlatformDataKeys.CONTEXT_MENU_LOCATOR, (Object)(singleSelectedNode != null ? popup -> (Point)builder.getActionExecutor().computeReadAction(() -> DiagramCanvasLocationService.getInstance().getBestPositionForSelectedNodePopupOnScreen(popup, builder)) : null));
        sink.set(PlatformDataKeys.CONTEXT_MENU_POINT, singleSelectedNode != null ? (Point)builder.getActionExecutor().computeReadAction(() -> DiagramCanvasLocationService.getInstance().getBestPositionForSelectedNodePopupOnScreen(null, builder)) : null);
        final Object currentValue = editingManager.getCurrentValue();
        final DiagramElementManager<?> elementManager = builder.getProvider().getElementManager();
        sink.set(PlatformDataKeys.COPY_PROVIDER, currentValue == null && singleSelectedNode == null ? null : new TextCopyProvider(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            @NotNull
            public Collection<String> getTextLinesToCopy() {
                Object selectedItem = currentValue != null ? currentValue : singleSelectedNode.getIdentifyingElement();
                SimpleColoredText name = elementManager.getItemName(selectedItem, builder);
                SimpleColoredText type = elementManager.getItemType(selectedItem);
                List<String> list = List.of(type == null ? String.valueOf(name) : String.valueOf(name) + " " + String.valueOf(type));
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/uml/UmlFileEditorImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextLinesToCopy";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        JComponent canvas = builder.getView().getCanvasComponent();
        Component root = SwingUtilities.getRoot(canvas);
        if (root != null && !root.isShowing()) {
            Point idePaneScreenLocation = root.getLocationOnScreen();
            if (singleSelectedNode != null) {
                Node selectedGraphNode = Objects.requireNonNull(builder.getNode(singleSelectedNode));
                NodeRealizer realizer = builder.getGraph().getRealizer(selectedGraphNode);
                Point nodeScreenLocation = GraphCanvasLocationService.getInstance().getNodeCoordinatesOnScreen(selectedGraphNode, builder.getGraphBuilder());
                sink.set(PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE, (Object)new Rectangle(nodeScreenLocation.x - idePaneScreenLocation.x, nodeScreenLocation.y - idePaneScreenLocation.y, (int)realizer.getWidth(), (int)realizer.getHeight()));
            } else if (canvas.isShowing()) {
                Point canvasScreenLocation = canvas.getLocationOnScreen();
                sink.set(PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE, (Object)new Rectangle(canvasScreenLocation.x - idePaneScreenLocation.x + canvas.getWidth() / 3, canvasScreenLocation.y - idePaneScreenLocation.y + canvas.getHeight() * 3 / 7, 0, 0));
            }
        }
        if ((presentationModel = builder.getPresentationModel()) instanceof DiagramPresentationModelImpl) {
            sink.set(StructureViewWrapperImpl.STRUCTURE_VIEW_TARGET_FILE_KEY, Optional.ofNullable(((DiagramPresentationModelImpl)presentationModel).getStructureViewTargetFile()));
        }
        sink.lazy(CommonDataKeys.LANGUAGE, () -> {
            Object selectedNodeElement = singleSelectedNode == null ? null : singleSelectedNode.getIdentifyingElement();
            return UmlFileEditorImpl.tryGetPsiElementFrom(selectedNodeElement).map(it -> it.getLanguage()).orElse(null);
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> (Navigatable[])selectedNodes.stream().map(it -> (Navigatable)ObjectUtils.tryCast(it.getIdentifyingElement(), Navigatable.class)).filter(it -> it != null).toArray(Navigatable[]::new));
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            Object selectedNodeElement = singleSelectedNode == null ? null : singleSelectedNode.getIdentifyingElement();
            return UmlFileEditorImpl.tryGetValidPsiElementFrom(selectedNodeElement).orElse(null);
        });
        sink.lazy(CommonDataKeys.PSI_FILE, () -> {
            Object selectedNodeElement = singleSelectedNode == null ? null : singleSelectedNode.getIdentifyingElement();
            return UmlFileEditorImpl.tryGetPsiFileFrom(selectedNodeElement).orElse(null);
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> UmlFileEditorImpl.getVirtualFile(builder, singleSelectedNode));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> {
            VirtualFile[] virtualFileArray;
            VirtualFile virtualFile = UmlFileEditorImpl.getVirtualFile(builder, singleSelectedNode);
            if (virtualFile == null) {
                virtualFileArray = null;
            } else {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = virtualFile;
            }
            return virtualFileArray;
        });
        sink.lazy(SelectInContext.DATA_KEY, () -> {
            Object selectedNodeElement = singleSelectedNode == null ? null : singleSelectedNode.getIdentifyingElement();
            return UmlFileEditorImpl.tryCast(selectedNodeElement, PsiElement.class).map(it -> it.getContainingFile()).map(it -> it.getVirtualFile()).map(it -> new FileSelectInContext(builder.getProject(), it, null)).or(() -> Optional.ofNullable(selectedNodeElement).map(it -> (PsiDirectoryContainer)ObjectUtils.tryCast((Object)it, PsiDirectoryContainer.class)).flatMap(it -> Arrays.stream(it.getDirectories()).findFirst()).map(it -> new FileSelectInContext(builder.getProject(), it.getVirtualFile(), null))).orElse(null);
        });
        sink.lazy(VcsDataKeys.VIRTUAL_FILES, () -> {
            VirtualFile virtualFile = UmlFileEditorImpl.getVirtualFile(builder, singleSelectedNode);
            return JBIterable.of((Object)virtualFile);
        });
        DataSink.uiDataSnapshot((DataSink)sink, (Object)editingManager);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull DiagramBuilder builder, @Nullable DiagramNode<?> singleSelectedNode) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(21);
        }
        Object selectedNodeElement = singleSelectedNode == null ? null : singleSelectedNode.getIdentifyingElement();
        return UmlFileEditorImpl.tryGetPsiFileFrom(selectedNodeElement).map(it -> it.getVirtualFile()).or(() -> Optional.ofNullable(builder.getEditor()).map(it -> it.getOriginalVirtualFile())).orElse(null);
    }

    @NotNull
    private static Optional<PsiElement> tryGetValidPsiElementFrom(@Nullable Object selectedNodeElement) {
        Optional<PsiElement> optional = UmlFileEditorImpl.tryGetPsiElementFrom(selectedNodeElement).filter(it -> it.isValid());
        if (optional == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(22);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiElement> tryGetPsiElementFrom(@Nullable Object selectedNodeElement) {
        Optional<PsiElement> optional = UmlFileEditorImpl.tryCast(selectedNodeElement, PsiElement.class).or(() -> UmlFileEditorImpl.tryCast(selectedNodeElement, LazyPsiElementHolder.class).map(it -> it.calculatePsiElement()));
        if (optional == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(23);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiFile> tryGetPsiFileFrom(@Nullable Object selectedNodeElement) {
        Optional<PsiFile> optional = UmlFileEditorImpl.tryGetPsiElementFrom(selectedNodeElement).map(it -> it.getContainingFile());
        if (optional == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(24);
        }
        return optional;
    }

    @NotNull
    private static <T> Optional<T> tryCast(@Nullable Object o, Class<T> clazz) {
        Optional<Object> optional = Optional.ofNullable(ObjectUtils.tryCast((Object)o, clazz));
        if (optional == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(25);
        }
        return optional;
    }

    @Override
    @NotNull
    public DiagramBuilder getModelBuilder() {
        DiagramBuilder diagramBuilder = this.myBuilder;
        if (diagramBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(26);
        }
        return diagramBuilder;
    }

    @Override
    @NotNull
    public DiagramBuilder getViewBuilder() {
        DiagramBuilder diagramBuilder = this.myGraphComponent.getBuilder();
        if (diagramBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(27);
        }
        return diagramBuilder;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(28);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getOriginalVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(29);
        }
        return virtualFile;
    }

    @NotNull
    public Collection<DocumentReference> getDocumentReferences() {
        List<DocumentReference> list = Collections.singletonList(this.myDocumentReference);
        if (list == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.getModelBuilder().getProvider());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static HintUpdateSupply createHintUpdateSupply(@NotNull JComponent canvasComponent) {
        if (canvasComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(31);
        }
        return new HintUpdateSupply(canvasComponent){

            @Nullable
            protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 10, 11, 13, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphViewBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorState";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvasComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentViewBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetValidPsiElementFrom";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetPsiElementFrom";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetPsiFileFrom";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "tryCast";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewBuilder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalVirtualFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentViewBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedForTheFirstTime";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditorListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isJourneyViewComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createHintUpdateSupply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 10, 11, 13, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    @ThreadSafe
    private static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        @NotNull
        private final DiagramBuilder myBuilder;
        @NotNull
        private final VirtualFile myFile;
        private long myCount;

        private MyFileEditorManagerListener(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
            if (builder == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            this.myBuilder = builder;
            this.myFile = file;
            this.myCount = this.getCount();
        }

        private long getCount() {
            return this.myBuilder.getDataModel().getModificationTracker().getModificationCount();
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            long newCount;
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (Comparing.equal((Object)event.getNewFile(), (Object)this.myFile) && this.myCount != (newCount = this.getCount())) {
                this.myCount = newCount;
                Project project = this.myBuilder.getProject();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!DumbService.getInstance((Project)project).isUsableInCurrentContext(this.myBuilder.getProvider())) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> {
                            if (!Disposer.isDisposed((Disposable)this.myBuilder)) {
                                DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.myBuilder).runAsync();
                            }
                        });
                    } else {
                        DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.myBuilder).runAsync();
                    }
                }, project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ThreadSafe
    private final class MyExternalChangeListener
    implements VirtualFileListener {
        private volatile boolean myDoHandleEvent = true;

        private MyExternalChangeListener() {
        }

        public void setDoHandleEvent(boolean doHandleEvent) {
            this.myDoHandleEvent = doHandleEvent;
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyExternalChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myDoHandleEvent && UmlFileEditorImpl.this.myFile.equals(event.getFile())) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        UmlFileEditorImpl.this.setUmlState(DiagramState.read(UmlFileEditorImpl.this.myFile.getInputStream()));
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/UmlFileEditorImpl$MyExternalChangeListener", "contentsChanged"));
        }
    }

    private final class MyDiagramListener
    implements DiagramActionsListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final MyExternalChangeListener myExternalListener;

        MyDiagramListener(@NotNull Project project, MyExternalChangeListener externalListener) {
            if (project == null) {
                MyDiagramListener.$$$reportNull$$$0(0);
            }
            if (externalListener == null) {
                MyDiagramListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myExternalListener = externalListener;
        }

        @Override
        public void actionPerformed(@NotNull DiagramActionsListener.DiagramActionEvent event) {
            if (event == null) {
                MyDiagramListener.$$$reportNull$$$0(2);
            }
            if (event.getBuilder() == UmlFileEditorImpl.this.getModelBuilder()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        this.myExternalListener.setDoHandleEvent(false);
                        UndoUtil.forceUndoIn((VirtualFile)UmlFileEditorImpl.this.myFile, () -> ((DiagramState)UmlFileEditorImpl.this.getState(FileEditorStateLevel.FULL)).saveTo(UmlFileEditorImpl.this.myFile, this.myProject));
                    }
                    finally {
                        this.myExternalListener.setDoHandleEvent(true);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyDiagramListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ThreadSafe
    private final class MyGraphSelectionListener
    implements Graph2DSelectionListener,
    Disposable {
        @NotNull
        private final HintUpdateSupply supply;

        private MyGraphSelectionListener() {
            this.supply = this.createHintUpdateSupply(UmlFileEditorImpl.this.getModelBuilder().getView().getCanvasComponent());
        }

        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent _graph2DSelectionEvent) {
            if (_graph2DSelectionEvent == null) {
                MyGraphSelectionListener.$$$reportNull$$$0(0);
            }
            if (!this.supply.shouldUpdateHint()) {
                return;
            }
            for (Node node : GraphSelectionService.getInstance().getSelectedNodes(UmlFileEditorImpl.this.getModelBuilder().getGraph())) {
                PsiElement element;
                DiagramNode<?> diagramNode = UmlFileEditorImpl.this.getModelBuilder().getNodeObject(node);
                if (diagramNode == null || (element = (PsiElement)UmlFileEditorImpl.tryGetPsiElementFrom(diagramNode.getIdentifyingElement()).orElse(null)) == null) continue;
                this.supply.updateHint(element);
                return;
            }
        }

        @NotNull
        private HintUpdateSupply createHintUpdateSupply(@NotNull JComponent canvasComponent) {
            if (canvasComponent == null) {
                MyGraphSelectionListener.$$$reportNull$$$0(1);
            }
            return new HintUpdateSupply(this, canvasComponent){

                @Nullable
                protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                    return null;
                }
            };
        }

        public void dispose() {
            UmlFileEditorImpl.this.getModelBuilder().getGraph().removeGraph2DSelectionListener((Graph2DSelectionListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_graph2DSelectionEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canvasComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyGraphSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onGraph2DSelectionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHintUpdateSupply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

