/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.graph.view.focusview.GraphFocusViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.uml.undo.UmlUndoableAction;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiagramFocusViewUndoableAction
extends BasicUndoableAction {
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final DiagramFileEditor myEditor;
    @NotNull
    private final GraphFocusViewProvider myFocusViewProvider;
    private final boolean myIsEnableFirst;
    @Nullable
    DiagramFullSnapshot myLastFocusViewSnapshot;

    DiagramFocusViewUndoableAction(@NotNull DiagramBuilder builder, @NotNull GraphFocusViewProvider focusViewProvider, boolean isEnableFirst) {
        if (builder == null) {
            DiagramFocusViewUndoableAction.$$$reportNull$$$0(0);
        }
        if (focusViewProvider == null) {
            DiagramFocusViewUndoableAction.$$$reportNull$$$0(1);
        }
        super(UmlUndoableAction.getAffectedDocuments(builder, new PsiFile[0]));
        this.myBuilder = builder;
        this.myEditor = Objects.requireNonNull(builder.getEditor());
        this.myFocusViewProvider = focusViewProvider;
        this.myIsEnableFirst = isEnableFirst;
    }

    public void undo() {
        if (this.myIsEnableFirst) {
            this.disableFocus();
        } else {
            this.enableFocus();
        }
    }

    public void redo() {
        if (this.myIsEnableFirst) {
            this.enableFocus();
        } else {
            this.disableFocus();
        }
    }

    public void enableFocus() {
        this.myFocusViewProvider.setupAndEnableFocusViewFor(this.myBuilder.getGraphBuilder());
        if (this.myLastFocusViewSnapshot != null) {
            this.myLastFocusViewSnapshot.restoreAsync(this.myEditor.getViewBuilder());
        }
    }

    public void disableFocus() {
        this.myLastFocusViewSnapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(this.myEditor.getViewBuilder());
        this.myFocusViewProvider.dropCurrentFocusView();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "focusViewProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/uml/core/actions/analysis/DiagramFocusViewUndoableAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

