/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationException
extends Exception {
    @NlsContexts.DialogTitle
    private String myTitle = ConfigurationException.getDefaultTitle();
    private ConfigurationQuickFix myQuickFix;
    private Configurable myOriginator;
    private boolean myIsHtmlMessage;

    public ConfigurationException(@NlsContexts.DialogMessage String message) {
        super(message);
    }

    public ConfigurationException(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        super(message);
        this.myTitle = title;
    }

    public ConfigurationException(@NlsContexts.DialogMessage String message, Throwable cause, @NlsContexts.DialogTitle String title) {
        super(message, cause);
        this.myTitle = title;
    }

    @NotNull
    public ConfigurationException withHtmlMessage() {
        this.myIsHtmlMessage = true;
        ConfigurationException configurationException = this;
        if (configurationException == null) {
            ConfigurationException.$$$reportNull$$$0(0);
        }
        return configurationException;
    }

    @Override
    @Deprecated
    @NlsContexts.DialogMessage
    public String getMessage() {
        return super.getMessage();
    }

    @NotNull
    public HtmlChunk getMessageHtml() {
        String message = this.getMessage();
        HtmlChunk htmlChunk = message == null ? HtmlChunk.empty() : (this.myIsHtmlMessage ? HtmlChunk.raw((String)message) : HtmlChunk.text((String)message));
        if (htmlChunk == null) {
            ConfigurationException.$$$reportNull$$$0(1);
        }
        return htmlChunk;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return this.myTitle;
    }

    public void setQuickFix(@Nullable Runnable quickFix) {
        this.myQuickFix = quickFix == null ? null : dataContext -> quickFix.run();
    }

    public void setQuickFix(@Nullable ConfigurationQuickFix quickFix) {
        this.myQuickFix = quickFix;
    }

    @Nullable
    public ConfigurationQuickFix getConfigurationQuickFix() {
        return this.myQuickFix;
    }

    @Nullable
    public Configurable getOriginator() {
        return this.myOriginator;
    }

    public void setOriginator(@Nullable Configurable originator) {
        this.myOriginator = originator;
    }

    public boolean shouldShowInDumbMode() {
        return true;
    }

    @NlsContexts.DialogTitle
    public static String getDefaultTitle() {
        return OptionsBundle.message("cannot.save.settings.default.dialog.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/options/ConfigurationException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withHtmlMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageHtml";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

