/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.checkers.CheckAnnotationIsConstraint;
import com.intellij.beanValidation.highlighting.checkers.CheckClassIsConstraintAnnotation;
import com.intellij.beanValidation.highlighting.checkers.CheckMissingParameters;
import com.intellij.beanValidation.model.xml.BvMappingsDomElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public final class BvConstraintMappingsInspection
extends BasicDomElementsInspection<BvMappingsDomElement> {
    private static final HashMap<String, BvChecker[]> CHECKERS = new HashMap();

    private static void register(String key, BvChecker ... checkers) {
        CHECKERS.put(key, checkers);
    }

    public BvConstraintMappingsInspection() {
        super(BvMappingsDomElement.class, new Class[0]);
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        GenericDomValue value;
        String checkerId;
        BvChecker[] checkers;
        if (element == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(2);
        }
        super.checkDomElement(element, holder, helper);
        if (element instanceof GenericDomValue && (checkers = CHECKERS.get(checkerId = BvConstraintMappingsInspection.getCheckerId(value = (GenericDomValue)element))) != null) {
            for (BvChecker checker : checkers) {
                checker.check(value, holder);
            }
        }
    }

    private static String getCheckerId(@NotNull GenericDomValue<?> value) {
        DomElement parent;
        if (value == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(3);
        }
        return (parent = value.getParent()) == null ? value.getXmlElementName() : parent.getXmlElementName() + "/" + value.getXmlElementName();
    }

    static {
        BvConstraintMappingsInspection.register("constraint/annotation", new CheckClassIsConstraintAnnotation(), new CheckMissingParameters());
        BvConstraintMappingsInspection.register("element/name", new CheckAnnotationIsConstraint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDomElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCheckerId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

