/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core.provider;

import com.intellij.ide.IdeView;
import com.intellij.liquibase.core.LiquibaseUtilKt;
import com.intellij.liquibase.core.extension.ChangelogDirectoryProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/core/provider/LiquibaseChangelogDirectoryProvider;", "Lcom/intellij/liquibase/core/extension/ChangelogDirectoryProvider;", "<init>", "()V", "getChangelogDirectory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.liquibase.core"})
public final class LiquibaseChangelogDirectoryProvider
implements ChangelogDirectoryProvider {
    @Override
    @Nullable
    public PsiDirectory getChangelogDirectory(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (ideView == null) {
            return null;
        }
        IdeView view = ideView;
        PsiDirectory[] psiDirectoryArray = view.getDirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
        PsiDirectory psiDirectory = (PsiDirectory)ArraysKt.firstOrNull((Object[])psiDirectoryArray);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory directory = psiDirectory;
        return LiquibaseUtilKt.isUnderDbChangelogDir(directory) ? directory : null;
    }
}

