/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypedEntity;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactBundle;
import com.intellij.react.ReactComponentContentUtil;
import com.intellij.react.fix.ReactPropUpdater;
import com.intellij.react.free.ReactPropTypesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PsiNavigateUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0096\u0002J\"\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J$\u0010&\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010(2\b\b\u0001\u0010)\u001a\u00020\u0005H\u0002J(\u0010*\u001a\u0004\u0018\u0001H+\"\n\b\u0000\u0010+\u0018\u0001*\u00020\u001b*\u00020\u001b2\u0006\u0010,\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\u0005*\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000500H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014 \u000b*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n0\u0005\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/react/fix/ReactUnresolvedReferenceToPropFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "unresolvedRef", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "componentName", "", "<init>", "(Lcom/intellij/lang/javascript/psi/JSReferenceExpression;Ljava/lang/String;)V", "myComponentName", "myRefName", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "getFamilyName", "getText", "startInWriteAction", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "invoke", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "preProcessReference", "componentSource", "parameterList", "Lcom/intellij/lang/javascript/psi/JSParameterList;", "createPropFromRef", "Lcom/intellij/lang/javascript/psi/JSProperty;", "ref", "propsType", "Lcom/intellij/lang/javascript/psi/JSRecordType;", "showError", "editor", "Lcom/intellij/openapi/editor/Editor;", "errorText", "replaceWith", "T", "text", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "getUniqueFor", "existed", "", "intellij.react.ultimate"})
@SourceDebugExtension(value={"SMAP\nReactUnresolvedReferenceToPropFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactUnresolvedReferenceToPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceToPropFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n89#1,2:105\n91#1:108\n89#1,2:109\n91#1:112\n1#2:107\n1#2:111\n1#2:113\n*S KotlinDebug\n*F\n+ 1 ReactUnresolvedReferenceToPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceToPropFix\n*L\n68#1:105,2\n68#1:108\n73#1:109,2\n73#1:112\n68#1:107\n73#1:111\n*E\n"})
public final class ReactUnresolvedReferenceToPropFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String myComponentName;
    private String myRefName;

    public ReactUnresolvedReferenceToPropFix(@NotNull JSReferenceExpression unresolvedRef, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)unresolvedRef, (String)"unresolvedRef");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        super((PsiElement)unresolvedRef);
        this.myComponentName = componentName;
        this.myRefName = unresolvedRef.getText();
    }

    @NotNull
    public String getFamilyName() {
        return ReactBundle.message("react.inspection.unresolved.prop.quick.fix.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.myRefName, (String)"myRefName");
        objectArray[1] = this.myComponentName;
        return ReactBundle.message("react.inspection.unresolved.ref.to.prop.fix.text", objectArray);
    }

    public boolean startInWriteAction() {
        return ApplicationKt.getApplication().isUnitTestMode();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (psiFile.getVirtualFile() == null) {
            return;
        }
        JSReferenceExpression unresolvedRef = (JSReferenceExpression)startElement;
        Editor editor = PsiEditorUtil.findEditor((PsiElement)startElement);
        JSPsiElementBase jSPsiElementBase = ReactComponentContentUtil.getContainingComponent((JSExpression)startElement);
        if (jSPsiElementBase == null) {
            return;
        }
        JSPsiElementBase component = jSPsiElementBase;
        String defaultPropsObjectName = this.myComponentName + "Props";
        JSTypedEntity propsTypeObject = ReactComponentContentUtil.INSTANCE.findOrCreateWritablePropsTypeObject((PsiElement)component, defaultPropsObjectName);
        if (propsTypeObject == null) {
            this.showError(project, editor, ReactBundle.message("react.inspection.unresolved.prop.validation.message.writable.props.not.found", new Object[0]));
            return;
        }
        ReactPropUpdater.Companion.create((PsiElement)component, propsTypeObject, defaultPropsObjectName, (Function0<? extends JSProperty>)((Function0)() -> ReactUnresolvedReferenceToPropFix.invoke$lambda$0(component, this, unresolvedRef))).withResultCallback((Function1<? super PsiElement, Unit>)((Function1)ReactUnresolvedReferenceToPropFix::invoke$lambda$1)).withParameterPreProcessor((Function1<? super JSParameterList, Unit>)((Function1)arg_0 -> ReactUnresolvedReferenceToPropFix.invoke$lambda$2(this, component, unresolvedRef, arg_0))).updateProps();
    }

    /*
     * WARNING - void declaration
     */
    private final void preProcessReference(PsiElement componentSource, JSReferenceExpression unresolvedRef, JSParameterList parameterList) {
        block6: {
            void $this$replaceWith$iv;
            if (componentSource instanceof JSClass) {
                void $this$replaceWith$iv2;
                ReactUnresolvedReferenceToPropFix reactUnresolvedReferenceToPropFix = this;
                PsiElement psiElement = (PsiElement)unresolvedRef;
                String text$iv = "this.props." + this.myRefName;
                boolean $i$f$replaceWith = false;
                Project project = $this$replaceWith$iv2.getProject();
                Language language = $this$replaceWith$iv2.getLanguage();
                Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
                JSElement it$iv = JSChangeUtil.createJSContentFromText((Project)project, (String)text$iv, (JSLanguageDialect)((JSLanguageDialect)language));
                boolean bl = false;
                it$iv = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it$iv), JSReferenceExpression.class);
                boolean bl2 = false;
                JSElement jSElement = it$iv;
                if (jSElement != null) {
                    PsiElement psiElement2 = $this$replaceWith$iv2.replace((PsiElement)jSElement);
                    if (!(psiElement2 instanceof JSReferenceExpression)) {
                        psiElement2 = null;
                    }
                    PsiElement cfr_ignored_0 = (PsiElement)((JSReferenceExpression)psiElement2);
                }
                return;
            }
            JSParameterListElement jSParameterListElement = parameterList;
            if (jSParameterListElement == null || (jSParameterListElement = jSParameterListElement.getParameters()) == null || (jSParameterListElement = (JSParameterListElement)ArraysKt.firstOrNull((Object[])jSParameterListElement)) == null) {
                return;
            }
            JSParameterListElement firstParameter = jSParameterListElement;
            if (firstParameter instanceof JSDestructuringParameter) break block6;
            ReactUnresolvedReferenceToPropFix $this$replaceWith$iv2 = this;
            PsiElement text$iv = (PsiElement)unresolvedRef;
            String text$iv2 = firstParameter.getName() + "." + this.myRefName;
            boolean $i$f$replaceWith = false;
            Project project = $this$replaceWith$iv.getProject();
            Language language = $this$replaceWith$iv.getLanguage();
            Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
            JSElement it$iv = JSChangeUtil.createJSContentFromText((Project)project, (String)text$iv2, (JSLanguageDialect)((JSLanguageDialect)language));
            boolean bl = false;
            it$iv = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it$iv), JSReferenceExpression.class);
            boolean bl3 = false;
            JSElement jSElement = it$iv;
            if (jSElement != null) {
                PsiElement psiElement = $this$replaceWith$iv.replace((PsiElement)jSElement);
                if (!(psiElement instanceof JSReferenceExpression)) {
                    psiElement = null;
                }
                PsiElement cfr_ignored_1 = (PsiElement)((JSReferenceExpression)psiElement);
            }
        }
    }

    private final JSProperty createPropFromRef(JSReferenceExpression ref, JSRecordType propsType) {
        String string = this.myRefName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myRefName");
        Object object = propsType;
        this.myRefName = this.getUniqueFor(string, object != null && (object = object.getPropertyNames()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        JSType refType = ReactComponentContentUtil.INSTANCE.findStateOrPropType(ref);
        Object object2 = refType;
        if (object2 == null || (object2 = object2.getTypeText(JSType.TypeTextFormat.CODE)) == null) {
            object2 = "unknown";
        }
        Object refTypeText = object2;
        PsiElement psiElement = JSChangeUtil.createObjectLiteralPropertyFromText((String)(this.myRefName + "?: " + (String)refTypeText), (PsiElement)((PsiElement)ref));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSProperty");
        return (JSProperty)psiElement;
    }

    private final void showError(Project project, Editor editor, @NlsSafe String errorText) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorText, (String)"", null);
    }

    private final /* synthetic */ <T extends PsiElement> T replaceWith(PsiElement $this$replaceWith, String text) {
        PsiElement psiElement;
        boolean $i$f$replaceWith = false;
        Project project = $this$replaceWith.getProject();
        Language language = $this$replaceWith.getLanguage();
        Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.JSLanguageDialect");
        JSElement it = JSChangeUtil.createJSContentFromText((Project)project, (String)text, (JSLanguageDialect)((JSLanguageDialect)language));
        boolean bl = false;
        PsiElement psiElement2 = (PsiElement)it;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        it = PsiTreeUtil.findChildOfType((PsiElement)psiElement2, PsiElement.class);
        boolean bl2 = false;
        JSElement jSElement = it;
        if (jSElement != null) {
            PsiElement psiElement3 = $this$replaceWith.replace((PsiElement)jSElement);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            psiElement = psiElement3;
        } else {
            psiElement = null;
        }
        return (T)psiElement;
    }

    private final String getUniqueFor(String $this$getUniqueFor, Collection<String> existed) {
        Object resultName = $this$getUniqueFor;
        int i = 1;
        while (existed.contains(resultName)) {
            resultName = $this$getUniqueFor + i;
            ++i;
        }
        return resultName;
    }

    private static final JSProperty invoke$lambda$0(JSPsiElementBase $component, ReactUnresolvedReferenceToPropFix this$0, JSReferenceExpression $unresolvedRef) {
        JSRecordType propsRecordType = ReactPropTypesUtil.INSTANCE.getResultPropsFromPsiElement((PsiElement)$component);
        return this$0.createPropFromRef($unresolvedRef, propsRecordType);
    }

    private static final Unit invoke$lambda$1(PsiElement it) {
        PsiNavigateUtil.navigate((PsiElement)it, (boolean)true);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$2(ReactUnresolvedReferenceToPropFix this$0, JSPsiElementBase $component, JSReferenceExpression $unresolvedRef, JSParameterList it) {
        this$0.preProcessReference((PsiElement)$component, $unresolvedRef, it);
        return Unit.INSTANCE;
    }
}

