/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.modulith.SpringModulithBundle;
import com.intellij.spring.modulith.SpringModulithLibraryUtilsKt;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithSimplifyEventListenerFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/modulith/highlighting/SpringModulithEventListenerInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "eventListenerCanBeSimplified", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.modulith"})
public final class SpringModulithEventListenerInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!SpringModulithLibraryUtilsKt.hasModulithEventsApi(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ SpringModulithEventListenerInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressIndicatorProvider.checkCanceled();
                PsiMethod psiMethod = element instanceof PsiMethod ? (PsiMethod)element : null;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod psiMethod2 = psiMethod;
                PsiElement psiElement = psiMethod2.getIdentifyingElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement identifier = psiElement;
                if (SpringModulithEventListenerInspection.access$eventListenerCanBeSimplified(this.this$0, psiMethod2)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SpringModulithSimplifyEventListenerFix()};
                    this.$holder.registerProblem(identifier, SpringModulithBundle.message("inspection.simplify.event.listener.declaration.message", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    private final boolean eventListenerCanBeSimplified(PsiMethod psiMethod) {
        boolean isAsync = psiMethod.hasAnnotation("org.springframework.scheduling.annotation.Async");
        boolean isTransactional = psiMethod.hasAnnotation("org.springframework.transaction.annotation.Transactional");
        boolean isTransactionalEventListener = psiMethod.hasAnnotation("org.springframework.transaction.event.TransactionalEventListener");
        if (isAsync && isTransactional && isTransactionalEventListener) {
            return true;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        boolean isClassTransactional = psiClass.hasAnnotation("org.springframework.transaction.annotation.Transactional");
        return isAsync && isTransactionalEventListener && isClassTransactional;
    }

    public static final /* synthetic */ boolean access$eventListenerCanBeSimplified(SpringModulithEventListenerInspection $this, PsiMethod psiMethod) {
        return $this.eventListenerCanBeSimplified(psiMethod);
    }
}

