/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.parser;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlParserDefinition;
import com.intellij.jpa.ql.parser._HqlLexer;
import com.intellij.jpa.ql.parser._JpqlLexer;
import com.intellij.jpa.ql.psi.QlTokenType;
import com.intellij.lang.Language;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class QlLexer
extends LookAheadLexer {
    public static final Map<String, IElementType> HQL_KEYWORDS = CollectionFactory.createCaseInsensitiveStringMap();
    public static final Map<String, IElementType> EJB_KEYWORDS = CollectionFactory.createCaseInsensitiveStringMap();
    public static final Map<String, IElementType> JPA_KEYWORDS = CollectionFactory.createCaseInsensitiveStringMap();
    public static final Map<String, IElementType> EQL_KEYWORDS = CollectionFactory.createCaseInsensitiveStringMap();
    private static final Set<String> optionalKeywords = CollectionFactory.createCaseInsensitiveStringSet();
    public static final Set<String> HQL_DATETIME_TYPES = new HashSet<String>();
    public static final Set<String> HQL_BOOLEAN_TYPES = new HashSet<String>();
    public static final Set<String> HQL_NUMERIC_TYPES = new HashSet<String>();
    public static final Set<String> HQL_ALL_TYPES = new HashSet<String>();
    public static final IElementType QL_QUAL_IDENTIFIER = new QlTokenType("identifier");
    public static final IElementType QL_IDENTIFIER = new QlTokenType("identifier");
    public static final IElementType QL_BACKTICKS_IDENTIFIER = new QlTokenType("backticks_identifier");
    public static final IElementType QL_STRING_UNCLOSED = new QlTokenType("unclosed string");
    public static final IElementType QL_MULTI_LINE_COMMENT = new QlTokenType("QL_MULTI_LINE_COMMENT");
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{QL_MULTI_LINE_COMMENT});
    public static final TokenSet QL_BINARY_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{QlTypes.QL_OP_PLUS, QlTypes.QL_OP_MINUS, QlTypes.QL_OP_CONCAT, QlTypes.QL_OP_DIV, QlTypes.QL_OP_MUL, QlTypes.QL_OP_EQ, QlTypes.QL_OP_GE, QlTypes.QL_OP_GT, QlTypes.QL_OP_LE, QlTypes.QL_OP_LT, QlTypes.QL_OP_NE});
    private final Map<String, IElementType> myKeywordMap;

    public static boolean isOptionalKeyword(String s) {
        return optionalKeywords.contains(s);
    }

    @NotNull
    public static Map<String, IElementType> getKeywordMap(@NotNull Language language) {
        if (language == null) {
            QlLexer.$$$reportNull$$$0(0);
        }
        Map<String, IElementType> map = language == JpqlLanguage.EJBQL ? EJB_KEYWORDS : (language == JpqlLanguage.HQL ? HQL_KEYWORDS : (language == JpqlLanguage.EQL ? EQL_KEYWORDS : JPA_KEYWORDS));
        if (map == null) {
            QlLexer.$$$reportNull$$$0(1);
        }
        return map;
    }

    public QlLexer(@NotNull Language language) {
        if (language == null) {
            QlLexer.$$$reportNull$$$0(2);
        }
        super((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter(QlLexer.getFlexLexer(language)), QlParserDefinition.QlParserTokenSets.WHITESPACES));
        this.myKeywordMap = QlLexer.getKeywordMap(language);
    }

    @NotNull
    private static FlexLexer getFlexLexer(@NotNull Language language) {
        if (language == null) {
            QlLexer.$$$reportNull$$$0(3);
        }
        if (language.is((Language)JpqlLanguage.HQL)) {
            return new _HqlLexer();
        }
        Language baseLanguage = language.getBaseLanguage();
        if (baseLanguage != null && baseLanguage.is((Language)JpqlLanguage.HQL)) {
            return new _HqlLexer();
        }
        return new _JpqlLexer();
    }

    public Set<String> getKeywords() {
        return this.myKeywordMap.keySet();
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        IElementType elementType;
        if (baseLexer == null) {
            QlLexer.$$$reportNull$$$0(4);
        }
        if (baseLexer.getTokenType() == QL_QUAL_IDENTIFIER) {
            this.advanceAs(baseLexer, QL_IDENTIFIER);
            return;
        }
        IElementType iElementType = elementType = baseLexer.getTokenType() == QL_IDENTIFIER ? this.myKeywordMap.get(baseLexer.getTokenText()) : null;
        if (elementType != null) {
            this.advanceAs(baseLexer, elementType);
        }
        super.lookAhead(baseLexer);
    }

    static {
        ContainerUtil.addAll(optionalKeywords, (Object[])new String[]{"ORDER", "GROUP", "MAX", "MIN", "KEY", "VALUE", "ENTRY", "MAP", "LIST", "ABS", "OBJECT", "AVG", "SUM", "COUNT", "EXTRACT", "CAST", "LOCATE", "ABS", "SQRT", "MOD", "NUMERIC", "INDEX", "MINELEMENT", "MAXELEMENT", "MININDEX", "MAXINDEX", "COALESCE", "NULLIF", "POSITION"});
        ContainerUtil.addAll(HQL_DATETIME_TYPES, (Object[])new String[]{"second", "minute", "hour", "day", "month", "quarter", "year", "date", "timestamp", "LocalDate", "LocalTime", "LocalDateTime", "instant", "ZonedDateTime", "time", "duration"});
        ContainerUtil.addAll(HQL_BOOLEAN_TYPES, (Object[])new String[]{"YesNo", "TrueFalse"});
        ContainerUtil.addAll(HQL_NUMERIC_TYPES, (Object[])new String[]{"integer", "long", "short", "byte", "float", "double", "char", "int", "BigDecimal", "BigInteger", "NumericBoolean"});
        HQL_ALL_TYPES.addAll(HQL_NUMERIC_TYPES);
        HQL_ALL_TYPES.addAll(HQL_DATETIME_TYPES);
        HQL_ALL_TYPES.addAll(HQL_BOOLEAN_TYPES);
        ContainerUtil.addAll(HQL_ALL_TYPES, (Object[])new String[]{"string", "boolean", "uuid", "character", "binary"});
        EJB_KEYWORDS.put("BY", QlTypes.QL_BY);
        EJB_KEYWORDS.put("COUNT", QlTypes.QL_COUNT);
        EJB_KEYWORDS.put("LIKE", QlTypes.QL_LIKE);
        EJB_KEYWORDS.put("OF", QlTypes.QL_OF);
        EJB_KEYWORDS.put("MOD", QlTypes.QL_MOD);
        EJB_KEYWORDS.put("WHERE", QlTypes.QL_WHERE);
        EJB_KEYWORDS.put("TRUE", QlTypes.QL_TRUE);
        EJB_KEYWORDS.put("IS", QlTypes.QL_IS);
        EJB_KEYWORDS.put("IN", QlTypes.QL_IN);
        EJB_KEYWORDS.put("EMPTY", QlTypes.QL_EMPTY);
        EJB_KEYWORDS.put("AVG", QlTypes.QL_AVG);
        EJB_KEYWORDS.put("MAX", QlTypes.QL_MAX);
        EJB_KEYWORDS.put("ORDER", QlTypes.QL_ORDER);
        EJB_KEYWORDS.put("AS", QlTypes.QL_AS);
        EJB_KEYWORDS.put("NULL", QlTypes.QL_NULL);
        EJB_KEYWORDS.put("MIN", QlTypes.QL_MIN);
        EJB_KEYWORDS.put("DISTINCT", QlTypes.QL_DISTINCT);
        EJB_KEYWORDS.put("DESC", QlTypes.QL_DESC);
        EJB_KEYWORDS.put("AND", QlTypes.QL_AND);
        EJB_KEYWORDS.put("MEMBER", QlTypes.QL_MEMBER);
        EJB_KEYWORDS.put("BETWEEN", QlTypes.QL_BETWEEN);
        EJB_KEYWORDS.put("SUM", QlTypes.QL_SUM);
        EJB_KEYWORDS.put("FALSE", QlTypes.QL_FALSE);
        EJB_KEYWORDS.put("ASC", QlTypes.QL_ASC);
        EJB_KEYWORDS.put("OBJECT", QlTypes.QL_OBJECT);
        EJB_KEYWORDS.put("NOT", QlTypes.QL_NOT);
        EJB_KEYWORDS.put("FROM", QlTypes.QL_FROM);
        EJB_KEYWORDS.put("SELECT", QlTypes.QL_SELECT);
        EJB_KEYWORDS.put("OR", QlTypes.QL_OR);
        EJB_KEYWORDS.put("CONCAT", QlTypes.QL_CONCAT);
        EJB_KEYWORDS.put("SUBSTRING", QlTypes.QL_SUBSTRING);
        EJB_KEYWORDS.put("LOCATE", QlTypes.QL_LOCATE);
        EJB_KEYWORDS.put("LENGTH", QlTypes.QL_LENGTH);
        EJB_KEYWORDS.put("ABS", QlTypes.QL_ABS);
        EJB_KEYWORDS.put("SQRT", QlTypes.QL_SQRT);
        JPA_KEYWORDS.putAll(EJB_KEYWORDS);
        JPA_KEYWORDS.put("THEN", QlTypes.QL_THEN);
        JPA_KEYWORDS.put("TRAILING", QlTypes.QL_TRAILING);
        JPA_KEYWORDS.put("SOME", QlTypes.QL_SOME);
        JPA_KEYWORDS.put("AVG", QlTypes.QL_AVG);
        JPA_KEYWORDS.put("JOIN", QlTypes.QL_JOIN);
        JPA_KEYWORDS.put("HAVING", QlTypes.QL_HAVING);
        JPA_KEYWORDS.put("SET", QlTypes.QL_SET);
        JPA_KEYWORDS.put("NULLIF", QlTypes.QL_NULLIF);
        JPA_KEYWORDS.put("SUBSTRING", QlTypes.QL_SUBSTRING);
        JPA_KEYWORDS.put("LIKE", QlTypes.QL_LIKE);
        JPA_KEYWORDS.put("ILIKE", QlTypes.QL_ILIKE);
        JPA_KEYWORDS.put("MAX", QlTypes.QL_MAX);
        JPA_KEYWORDS.put("INNER", QlTypes.QL_INNER);
        JPA_KEYWORDS.put("SQRT", QlTypes.QL_SQRT);
        JPA_KEYWORDS.put("KEY", QlTypes.QL_KEY);
        JPA_KEYWORDS.put("EMPTY", QlTypes.QL_EMPTY);
        JPA_KEYWORDS.put("SUM", QlTypes.QL_SUM);
        JPA_KEYWORDS.put("MIN", QlTypes.QL_MIN);
        JPA_KEYWORDS.put("ENTRY", QlTypes.QL_ENTRY);
        JPA_KEYWORDS.put("OF", QlTypes.QL_OF);
        JPA_KEYWORDS.put("OR", QlTypes.QL_OR);
        JPA_KEYWORDS.put("TRIM", QlTypes.QL_TRIM);
        JPA_KEYWORDS.put("PAD", QlTypes.QL_PAD);
        JPA_KEYWORDS.put("NEW", QlTypes.QL_NEW);
        JPA_KEYWORDS.put("ELSE", QlTypes.QL_ELSE);
        JPA_KEYWORDS.put("IS", QlTypes.QL_IS);
        JPA_KEYWORDS.put("FETCH", QlTypes.QL_FETCH);
        JPA_KEYWORDS.put("OBJECT", QlTypes.QL_OBJECT);
        JPA_KEYWORDS.put("IN", QlTypes.QL_IN);
        JPA_KEYWORDS.put("DESC", QlTypes.QL_DESC);
        JPA_KEYWORDS.put("ASC", QlTypes.QL_ASC);
        JPA_KEYWORDS.put("ESCAPE", QlTypes.QL_ESCAPE);
        JPA_KEYWORDS.put("UPPER", QlTypes.QL_UPPER);
        JPA_KEYWORDS.put("ANY", QlTypes.QL_ANY);
        JPA_KEYWORDS.put("EVERY", QlTypes.QL_EVERY);
        JPA_KEYWORDS.put("WHERE", QlTypes.QL_WHERE);
        JPA_KEYWORDS.put("VALUE", QlTypes.QL_VALUE);
        JPA_KEYWORDS.put("LOCAL", QlTypes.QL_LOCAL);
        JPA_KEYWORDS.put("DATE", QlTypes.QL_DATE);
        JPA_KEYWORDS.put("TIME", QlTypes.QL_TIME);
        JPA_KEYWORDS.put("DATETIME", QlTypes.QL_DATETIME);
        JPA_KEYWORDS.put("FALSE", QlTypes.QL_FALSE);
        JPA_KEYWORDS.put("MEMBER", QlTypes.QL_MEMBER);
        JPA_KEYWORDS.put("BETWEEN", QlTypes.QL_BETWEEN);
        JPA_KEYWORDS.put("NULL", QlTypes.QL_NULL);
        JPA_KEYWORDS.put("AND", QlTypes.QL_AND);
        JPA_KEYWORDS.put("GROUP", QlTypes.QL_GROUP);
        JPA_KEYWORDS.put("LEFT", QlTypes.QL_LEFT);
        JPA_KEYWORDS.put("RIGHT", QlTypes.QL_RIGHT);
        JPA_KEYWORDS.put("REPLACE", QlTypes.QL_REPLACE);
        JPA_KEYWORDS.put("ID", QlTypes.QL_ID);
        JPA_KEYWORDS.put("VERSION", QlTypes.QL_VERSION);
        JPA_KEYWORDS.put("FULL", QlTypes.QL_FULL);
        JPA_KEYWORDS.put("COALESCE", QlTypes.QL_COALESCE);
        JPA_KEYWORDS.put("CURRENT_DATE", QlTypes.QL_CURRENT_DATE);
        JPA_KEYWORDS.put("CURRENT_TIME", QlTypes.QL_CURRENT_TIME);
        JPA_KEYWORDS.put("CURRENT_TIMESTAMP", QlTypes.QL_CURRENT_TIMESTAMP);
        JPA_KEYWORDS.put("LOCAL_DATE", QlTypes.QL_LOCAL_DATE);
        JPA_KEYWORDS.put("LOCAL_DATETIME", QlTypes.QL_LOCAL_DATETIME);
        JPA_KEYWORDS.put("LOCAL_TIME", QlTypes.QL_LOCAL_TIME);
        JPA_KEYWORDS.put("TIMESTAMP", QlTypes.QL_TIMESTAMP);
        JPA_KEYWORDS.put("INSTANT", QlTypes.QL_INSTANT);
        JPA_KEYWORDS.put("OFFSET_DATETIME", QlTypes.QL_OFFSET_DATETIME);
        JPA_KEYWORDS.put("CURRENT", QlTypes.QL_CURRENT);
        JPA_KEYWORDS.put("DAY", QlTypes.QL_DAY);
        JPA_KEYWORDS.put("MONTH", QlTypes.QL_MONTH);
        JPA_KEYWORDS.put("YEAR", QlTypes.QL_YEAR);
        JPA_KEYWORDS.put("HOUR", QlTypes.QL_HOUR);
        JPA_KEYWORDS.put("MINUTE", QlTypes.QL_MINUTE);
        JPA_KEYWORDS.put("SECOND", QlTypes.QL_SECOND);
        JPA_KEYWORDS.put("BY", QlTypes.QL_BY);
        JPA_KEYWORDS.put("LOWER", QlTypes.QL_LOWER);
        JPA_KEYWORDS.put("SELECT", QlTypes.QL_SELECT);
        JPA_KEYWORDS.put("INSERT", QlTypes.QL_INSERT);
        JPA_KEYWORDS.put("INTO", QlTypes.QL_INTO);
        JPA_KEYWORDS.put("NOT", QlTypes.QL_NOT);
        JPA_KEYWORDS.put("OUTER", QlTypes.QL_OUTER);
        JPA_KEYWORDS.put("CASE", QlTypes.QL_CASE);
        JPA_KEYWORDS.put("WHEN", QlTypes.QL_WHEN);
        JPA_KEYWORDS.put("BOTH", QlTypes.QL_BOTH);
        JPA_KEYWORDS.put("TYPE", QlTypes.QL_TYPE);
        JPA_KEYWORDS.put("UPDATE", QlTypes.QL_UPDATE);
        JPA_KEYWORDS.put("LEADING", QlTypes.QL_LEADING);
        JPA_KEYWORDS.put("ORDER", QlTypes.QL_ORDER);
        JPA_KEYWORDS.put("AS", QlTypes.QL_AS);
        JPA_KEYWORDS.put("FROM", QlTypes.QL_FROM);
        JPA_KEYWORDS.put("LENGTH", QlTypes.QL_LENGTH);
        JPA_KEYWORDS.put("DISTINCT", QlTypes.QL_DISTINCT);
        JPA_KEYWORDS.put("ALL", QlTypes.QL_ALL);
        JPA_KEYWORDS.put("COUNT", QlTypes.QL_COUNT);
        JPA_KEYWORDS.put("TRUE", QlTypes.QL_TRUE);
        JPA_KEYWORDS.put("SIZE", QlTypes.QL_SIZE);
        JPA_KEYWORDS.put("DELETE", QlTypes.QL_DELETE);
        JPA_KEYWORDS.put("CONCAT", QlTypes.QL_CONCAT);
        JPA_KEYWORDS.put("INDEX", QlTypes.QL_INDEX);
        JPA_KEYWORDS.put("EXISTS", QlTypes.QL_EXISTS);
        JPA_KEYWORDS.put("LOCATE", QlTypes.QL_LOCATE);
        JPA_KEYWORDS.put("END", QlTypes.QL_END);
        JPA_KEYWORDS.put("ON", QlTypes.QL_ON);
        JPA_KEYWORDS.put("FUNCTION", QlTypes.QL_FUNCTION);
        JPA_KEYWORDS.put("TREAT", QlTypes.QL_TREAT);
        JPA_KEYWORDS.put("DATE_TRUNC", QlTypes.QL_DATE_TRUNC);
        JPA_KEYWORDS.put("TRUNC", QlTypes.QL_TRUNC);
        JPA_KEYWORDS.put("TRUNCATE", QlTypes.QL_TRUNCATE);
        JPA_KEYWORDS.put("NULLS", QlTypes.QL_NULLS);
        JPA_KEYWORDS.put("FIRST", QlTypes.QL_FIRST);
        JPA_KEYWORDS.put("LAST", QlTypes.QL_LAST);
        JPA_KEYWORDS.put("ELEMENTS", QlTypes.QL_ELEMENTS);
        JPA_KEYWORDS.put("NUMERIC", QlTypes.QL_NUMERIC);
        JPA_KEYWORDS.put("CEILING", QlTypes.QL_CEILING);
        JPA_KEYWORDS.put("EXP", QlTypes.QL_EXP);
        JPA_KEYWORDS.put("FLOOR", QlTypes.QL_FLOOR);
        JPA_KEYWORDS.put("FOLLOWING", QlTypes.QL_FOLLOWING);
        JPA_KEYWORDS.put("LN", QlTypes.QL_LN);
        JPA_KEYWORDS.put("LOG", QlTypes.QL_LOG);
        JPA_KEYWORDS.put("LOG10", QlTypes.QL_LOG10);
        JPA_KEYWORDS.put("POWER", QlTypes.QL_POWER);
        JPA_KEYWORDS.put("PRECEDING", QlTypes.QL_PRECEDING);
        JPA_KEYWORDS.put("ROUND", QlTypes.QL_ROUND);
        JPA_KEYWORDS.put("SIGN", QlTypes.QL_SIGN);
        JPA_KEYWORDS.put("EXTRACT", QlTypes.QL_EXTRACT);
        JPA_KEYWORDS.put("CAST", QlTypes.QL_CAST);
        JPA_KEYWORDS.put("UNION", QlTypes.QL_UNION);
        JPA_KEYWORDS.put("UNBOUNDED", QlTypes.QL_UNBOUNDED);
        JPA_KEYWORDS.put("EXCEPT", QlTypes.QL_EXCEPT);
        JPA_KEYWORDS.put("INTERSECT", QlTypes.QL_INTERSECT);
        JPA_KEYWORDS.put("LATERAL", QlTypes.QL_LATERAL);
        JPA_KEYWORDS.put("LIMIT", QlTypes.QL_LIMIT);
        JPA_KEYWORDS.put("OFFSET", QlTypes.QL_OFFSET);
        JPA_KEYWORDS.put("ROW", QlTypes.QL_ROW);
        JPA_KEYWORDS.put("ROWS", QlTypes.QL_ROWS);
        JPA_KEYWORDS.put("NEXT", QlTypes.QL_NEXT);
        JPA_KEYWORDS.put("WITH", QlTypes.QL_WITH);
        JPA_KEYWORDS.put("TIES", QlTypes.QL_TIES);
        JPA_KEYWORDS.put("ONLY", QlTypes.QL_ONLY);
        JPA_KEYWORDS.put("FILTER", QlTypes.QL_FILTER);
        JPA_KEYWORDS.put("OVER", QlTypes.QL_OVER);
        JPA_KEYWORDS.put("PARTITION", QlTypes.QL_PARTITION);
        JPA_KEYWORDS.put("LIST", QlTypes.QL_LIST);
        JPA_KEYWORDS.put("MAP", QlTypes.QL_MAP);
        JPA_KEYWORDS.put("LISTAGG", QlTypes.QL_LISTAGG);
        JPA_KEYWORDS.put("ARRAY_AGG", QlTypes.QL_ARRAY_AGG);
        JPA_KEYWORDS.put("WITHIN", QlTypes.QL_WITHIN);
        JPA_KEYWORDS.put("SIN", QlTypes.QL_SIN);
        JPA_KEYWORDS.put("COS", QlTypes.QL_COS);
        JPA_KEYWORDS.put("TAN", QlTypes.QL_TAN);
        JPA_KEYWORDS.put("ASIN", QlTypes.QL_ASIN);
        JPA_KEYWORDS.put("ACOS", QlTypes.QL_ACOS);
        JPA_KEYWORDS.put("ATAN", QlTypes.QL_ATAN);
        JPA_KEYWORDS.put("ATAN2", QlTypes.QL_ATAN2);
        JPA_KEYWORDS.put("SINH", QlTypes.QL_SINH);
        JPA_KEYWORDS.put("COSH", QlTypes.QL_COSH);
        JPA_KEYWORDS.put("TANH", QlTypes.QL_TANH);
        JPA_KEYWORDS.put("DEGREES", QlTypes.QL_DEGREES);
        JPA_KEYWORDS.put("RADIANT", QlTypes.QL_RADIANT);
        JPA_KEYWORDS.put("LEAST", QlTypes.QL_LEAST);
        JPA_KEYWORDS.put("GREATEST", QlTypes.QL_GREATEST);
        JPA_KEYWORDS.put("ARRAY", QlTypes.QL_ARRAY);
        JPA_KEYWORDS.put("ARRAY_APPEND", QlTypes.QL_ARRAY_APPEND);
        JPA_KEYWORDS.put("ARRAY_CONCAT", QlTypes.QL_ARRAY_CONCAT);
        JPA_KEYWORDS.put("ARRAY_CONTAINS", QlTypes.QL_ARRAY_CONTAINS);
        JPA_KEYWORDS.put("ARRAY_CONTAINS_NULLABLE", QlTypes.QL_ARRAY_CONTAINS_NULLABLE);
        JPA_KEYWORDS.put("ARRAY_FILL", QlTypes.QL_ARRAY_FILL);
        JPA_KEYWORDS.put("ARRAY_FILL_LIST", QlTypes.QL_ARRAY_FILL_LIST);
        JPA_KEYWORDS.put("ARRAY_GET", QlTypes.QL_ARRAY_GET);
        JPA_KEYWORDS.put("ARRAY_LENGTH", QlTypes.QL_ARRAY_LENGTH);
        JPA_KEYWORDS.put("ARRAY_LIST", QlTypes.QL_ARRAY_LIST);
        JPA_KEYWORDS.put("ARRAY_OVERLAPS", QlTypes.QL_ARRAY_OVERLAPS);
        JPA_KEYWORDS.put("ARRAY_OVERLAPS_NULLABLE", QlTypes.QL_ARRAY_OVERLAPS_NULLABLE);
        JPA_KEYWORDS.put("ARRAY_POSITION", QlTypes.QL_ARRAY_POSITION);
        JPA_KEYWORDS.put("ARRAY_POSITIONS", QlTypes.QL_ARRAY_POSITIONS);
        JPA_KEYWORDS.put("ARRAY_POSITIONS_LIST", QlTypes.QL_ARRAY_POSITIONS_LIST);
        JPA_KEYWORDS.put("ARRAY_PREPEND", QlTypes.QL_ARRAY_PREPEND);
        JPA_KEYWORDS.put("ARRAY_REMOVE", QlTypes.QL_ARRAY_REMOVE);
        JPA_KEYWORDS.put("ARRAY_REMOVE_INDEX", QlTypes.QL_ARRAY_REMOVE_INDEX);
        JPA_KEYWORDS.put("ARRAY_REPLACE", QlTypes.QL_ARRAY_REPLACE);
        JPA_KEYWORDS.put("ARRAY_SET", QlTypes.QL_ARRAY_SET);
        JPA_KEYWORDS.put("ARRAY_SLICE", QlTypes.QL_ARRAY_SLICE);
        JPA_KEYWORDS.put("ARRAY_TO_STRING", QlTypes.QL_ARRAY_TO_STRING);
        JPA_KEYWORDS.put("ARRAY_TRIM", QlTypes.QL_ARRAY_TRIM);
        JPA_KEYWORDS.put("MOD", QlTypes.QL_MOD);
        JPA_KEYWORDS.put("PERCENTILE_CONT", QlTypes.QL_PERCENTILE_CONT);
        JPA_KEYWORDS.put("PERCENTILE_DISC", QlTypes.QL_PERCENTILE_DISC);
        JPA_KEYWORDS.put("RANK", QlTypes.QL_RANK);
        JPA_KEYWORDS.put("DENSE_RANK", QlTypes.QL_DENSE_RANK);
        JPA_KEYWORDS.put("PERCENT_RANK", QlTypes.QL_PERCENT_RANK);
        JPA_KEYWORDS.put("CUME_DIST", QlTypes.QL_CUME_DIST);
        JPA_KEYWORDS.put("MODE", QlTypes.QL_MODE);
        JPA_KEYWORDS.put("MATERIALIZED", QlTypes.QL_MATERIALIZED);
        JPA_KEYWORDS.put("CYCLE", QlTypes.QL_CYCLE);
        JPA_KEYWORDS.put("SEARCH", QlTypes.QL_SEARCH);
        JPA_KEYWORDS.put("USING", QlTypes.QL_USING);
        JPA_KEYWORDS.put("TO", QlTypes.QL_TO);
        JPA_KEYWORDS.put("VALUES", QlTypes.QL_VALUES);
        JPA_KEYWORDS.put("CROSS", QlTypes.QL_CROSS);
        JPA_KEYWORDS.put("BREADTH", QlTypes.QL_BREADTH);
        JPA_KEYWORDS.put("DEFAULT", QlTypes.QL_DEFAULT);
        JPA_KEYWORDS.put("DEPTH", QlTypes.QL_DEPTH);
        JPA_KEYWORDS.put("CONFLICT", QlTypes.QL_CONFLICT);
        JPA_KEYWORDS.put("CONSTRAINT", QlTypes.QL_CONSTRAINT);
        JPA_KEYWORDS.put("DO", QlTypes.QL_DO);
        JPA_KEYWORDS.put("NOTHING", QlTypes.QL_NOTHING);
        JPA_KEYWORDS.put("COLLATE", QlTypes.QL_COLLATE);
        JPA_KEYWORDS.put("OVERLAY", QlTypes.QL_OVERLAY);
        JPA_KEYWORDS.put("FORMAT", QlTypes.QL_FORMAT);
        JPA_KEYWORDS.put("PLACING", QlTypes.QL_PLACING);
        JPA_KEYWORDS.put("VERSIONED", QlTypes.QL_VERSIONED);
        EQL_KEYWORDS.putAll(JPA_KEYWORDS);
        EQL_KEYWORDS.put("FUNC", QlTypes.QL_FUNC);
        EQL_KEYWORDS.put("SQl", QlTypes.QL_SQL);
        EQL_KEYWORDS.put("OPERATOR", QlTypes.QL_OPERATOR);
        EQL_KEYWORDS.put("TABLE", QlTypes.QL_TABLE);
        EQL_KEYWORDS.put("COLUMN", QlTypes.QL_COLUMN);
        EQL_KEYWORDS.put("NULLS", QlTypes.QL_NULLS);
        EQL_KEYWORDS.put("FIRST", QlTypes.QL_FIRST);
        HQL_KEYWORDS.putAll(JPA_KEYWORDS);
        HQL_KEYWORDS.put("YES", QlTypes.QL_YES);
        HQL_KEYWORDS.put("QUEST", QlTypes.QL_QUEST);
        HQL_KEYWORDS.put("FULL", QlTypes.QL_FULL);
        HQL_KEYWORDS.put("NO", QlTypes.QL_NO);
        HQL_KEYWORDS.put("NUMBER", QlTypes.QL_NUMBER);
        HQL_KEYWORDS.put("SEMICOLON", QlTypes.QL_SEMICOLON);
        HQL_KEYWORDS.put("INDICES", QlTypes.QL_INDICES);
        HQL_KEYWORDS.put("CLASS", QlTypes.QL_CLASS);
        HQL_KEYWORDS.put("PROPERTIES", QlTypes.QL_PROPERTIES);
        HQL_KEYWORDS.put("POSITION", QlTypes.QL_POSITION);
        HQL_KEYWORDS.put("COMMA", QlTypes.QL_COMMA);
        HQL_KEYWORDS.put("MINELEMENT", QlTypes.QL_MINELEMENT);
        HQL_KEYWORDS.put("WITH", QlTypes.QL_WITH);
        HQL_KEYWORDS.put("RIGHT", QlTypes.QL_RIGHT);
        HQL_KEYWORDS.put("MAXELEMENT", QlTypes.QL_MAXELEMENT);
        HQL_KEYWORDS.put("COLON", QlTypes.QL_COLON);
        HQL_KEYWORDS.put("MAXINDEX", QlTypes.QL_MAXINDEX);
        HQL_KEYWORDS.put("MININDEX", QlTypes.QL_MININDEX);
        HQL_KEYWORDS.put("STRING", QlTypes.QL_STRING);
        HQL_KEYWORDS.put("WITHIN", QlTypes.QL_WITHIN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ql/parser/QlLexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ql/parser/QlLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordMap";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFlexLexer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookAhead";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

