/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedContentTabWithStats;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u0019\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/XmlTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "detectFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "tryParseAndPrettify", "xmlFileType", "Lorg/jetbrains/annotations/NotNull;", "getXmlFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "createDocumentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nXmlTextVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/XmlTextVisualizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,117:1\n131#2,2:118\n*S KotlinDebug\n*F\n+ 1 XmlTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/XmlTextVisualizer\n*L\n46#1:118,2\n*E\n"})
public final class XmlTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String prettified = this.tryParseAndPrettify(value);
        if (prettified == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new VisualizedContentTabWithStats(prettified, this){
            final /* synthetic */ String $prettified;
            final /* synthetic */ XmlTextVisualizer this$0;
            {
                this.$prettified = $prettified;
                this.this$0 = $receiver;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.xml", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(XmlTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.XML;
            }

            public String formatText() {
                return this.$prettified;
            }

            protected FileType getFileType() {
                return XmlTextVisualizer.access$getXmlFileType(this.this$0);
            }
        });
    }

    @Nullable
    public FileType detectFileType(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.tryParseAndPrettify(value) != null ? this.getXmlFileType() : null;
    }

    private final String tryParseAndPrettify(String value) {
        String string;
        Character c;
        block4: {
            CharSequence $this$firstOrNull$iv = value;
            boolean $i$f$firstOrNull = false;
            for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$firstOrNull$iv.charAt(i);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                c = Character.valueOf(element$iv);
                break block4;
            }
            c = null;
        }
        char $this$firstOrNull$iv = '<';
        if (c == null || c.charValue() != $this$firstOrNull$iv) {
            return null;
        }
        try {
            InputSource src = new InputSource(new StringReader(value));
            DocumentBuilder builder = this.createDocumentBuilder();
            builder.setErrorHandler(null);
            Document document = builder.parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            string = out.toString();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    private final FileType getXmlFileType() {
        FileType fileType = FileTypeManager.getInstance().getStdFileType("XML");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getStdFileType(...)");
        return fileType;
    }

    @NotNull
    public final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newDefaultInstance();
        try {
            String feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            documentBuilder = dbf.newDocumentBuilder();
            Intrinsics.checkNotNull((Object)documentBuilder);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to create DOM parser", throwable);
        }
        return documentBuilder;
    }

    public static final /* synthetic */ FileType access$getXmlFileType(XmlTextVisualizer $this) {
        return $this.getXmlFileType();
    }
}

