/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/dom/XmlUniverseModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "handleChange", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "Companion", "intellij.spring.core"})
public final class XmlUniverseModificationTracker
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public XmlUniverseModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection messageBus = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBus.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void fileCreated(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            public void beforeFileDeletion(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.handleChange(virtualFile);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void handleChange(VirtualFile virtualFile) {
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
            this.incModificationCount();
        }
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final ModificationTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/dom/XmlUniverseModificationTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ModificationTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(XmlUniverseModificationTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ModificationTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

