/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringFeatureUsagesCollector;
import com.intellij.spring.SpringFeatures;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.actions.CompletablePopupBuilderImplKt;
import com.intellij.spring.model.actions.generate.GenerateSpringComponentActionKt;
import com.intellij.spring.templates.SpringFileTemplateDescriptor;
import com.intellij.spring.templates.SpringTemplateProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u000eH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/spring/model/actions/generate/GenerateSpringComponentAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "liveTemplates", "", "Lcom/intellij/spring/templates/SpringFileTemplateDescriptor;", "", "module", "Lcom/intellij/openapi/module/Module;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAccepted", "", "template", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "context", "Lcom/intellij/codeInsight/template/TemplateActionContext;", "contextTypes", "", "Lcom/intellij/codeInsight/template/TemplateContextType;", "findTemplate", "liveTemplate", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nGenerateSpringComponentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSpringComponentAction.kt\ncom/intellij/spring/model/actions/generate/GenerateSpringComponentAction\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n540#2:121\n525#2,6:122\n777#3:128\n873#3,2:129\n1391#3:131\n1480#3,2:132\n1642#3,10:134\n1915#3:144\n1916#3:146\n1652#3:147\n1586#3:148\n1661#3,3:149\n1482#3,3:152\n1205#3,2:155\n1282#3,4:157\n1#4:145\n*S KotlinDebug\n*F\n+ 1 GenerateSpringComponentAction.kt\ncom/intellij/spring/model/actions/generate/GenerateSpringComponentAction\n*L\n62#1:121\n62#1:122,6\n98#1:128\n98#1:129,2\n100#1:131\n100#1:132,2\n101#1:134,10\n101#1:144\n101#1:146\n101#1:147\n105#1:148\n105#1:149,3\n100#1:152,3\n106#1:155,2\n106#1:157,4\n101#1:145\n*E\n"})
public final class GenerateSpringComponentAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!SpringFeatures.GenerateSpringComponentAction.INSTANCE.isAvailable()) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2)) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!SpringLibraryUtil.hasSpringLibrary((Module)module2)) {
            return;
        }
        Map<SpringFileTemplateDescriptor, String> liveTemplates = this.liveTemplates(module2, psiFile2, editor2);
        e.getPresentation().setEnabledAndVisible(!liveTemplates.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        Map<SpringFileTemplateDescriptor, String> liveTemplates = this.liveTemplates(module2, psiFile2, editor2);
        String preSelectedTemplate = (String)dataContext2.getData(GenerateSpringComponentActionKt.getSPRING_TEMPLATE_KEY());
        if (preSelectedTemplate != null) {
            void $this$filterTo$iv$iv;
            Map<SpringFileTemplateDescriptor, String> $this$filter$iv = liveTemplates;
            boolean $i$f$filter = false;
            Map<SpringFileTemplateDescriptor, String> map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((SpringFileTemplateDescriptor)it.getKey()).getDisplayName(), (Object)preSelectedTemplate)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            String string = (String)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.values());
            if (string == null) {
                return;
            }
            String templateName = string;
            TemplateImpl templateImpl = this.findTemplate(templateName);
            if (templateImpl == null) {
                return;
            }
            TemplateImpl liveTemplate = templateImpl;
            Object[] objectArray = new PsiFile[]{psiFile2};
            WriteCommandAction.Builder builder = WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])objectArray);
            objectArray = new Object[]{templateName};
            builder.withName(SpringBundle.message("progress.creating.component", objectArray)).run(() -> GenerateSpringComponentAction.actionPerformed$lambda$1(project2, editor2, liveTemplate, dataContext2));
            return;
        }
        CompletablePopupBuilderImplKt.selectTemplate$default(project2, module2, psiFile2, null, liveTemplates.keySet(), (arg_0, arg_1) -> GenerateSpringComponentAction.actionPerformed$lambda$2(liveTemplates, this, project2, psiFile2, editor2, arg_0, arg_1), 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<SpringFileTemplateDescriptor, String> liveTemplates(Module module, PsiFile psiFile, Editor editor) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)psiFile, (Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)templateActionContext, (String)"expanding(...)");
        TemplateActionContext context = templateActionContext;
        Set set = TemplateManagerImpl.getApplicableContextTypes((TemplateActionContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getApplicableContextTypes(...)");
        Set contextTypes = set;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        PsiDirectory psiDirectory = psiFile.getContainingDirectory();
        if (psiDirectory == null) {
            return MapsKt.emptyMap();
        }
        PsiDirectory directory = psiDirectory;
        Iterable $this$filter$iv = SpringTemplateProvider.Companion.getTemplates(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpringFileTemplateDescriptor it = (SpringFileTemplateDescriptor)element$iv$iv;
            boolean bl = false;
            if (!projectFileIndex2.isUnderSourceRootOfType(directory.getVirtualFile(), it.getSourceSets())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            SpringFileTemplateDescriptor springTemplate = (SpringFileTemplateDescriptor)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = springTemplate.getLiveTemplates();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = object.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv2;
                boolean bl3 = false;
                TemplateImpl template = this.findTemplate(it);
                if ((template != null && this.isAccepted(template, context, contextTypes) ? it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List liveTemplates = (List)destination$iv$iv2;
            Iterable $this$map$iv = liveTemplates;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(TuplesKt.to((Object)springTemplate, (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }

    private final boolean isAccepted(TemplateImpl template, TemplateActionContext context, Set<? extends TemplateContextType> contextTypes) {
        return !template.isDeactivated() && (!context.isSurrounding() || template.isSelectionTemplate()) && TemplateManagerImpl.isApplicable((TemplateImpl)template, contextTypes);
    }

    private final TemplateImpl findTemplate(String liveTemplate) {
        if (!StringsKt.contains$default((CharSequence)liveTemplate, (CharSequence)"/", (boolean)false, (int)2, null)) {
            return null;
        }
        String[] stringArray = new String[]{"/"};
        List list = StringsKt.split$default((CharSequence)liveTemplate, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String group = (String)list.get(0);
        String name = (String)list.get(1);
        return TemplateSettings.getInstance().getTemplate(name, group);
    }

    private static final void actionPerformed$lambda$2$0$0(Project $project, Editor $editor, TemplateImpl $liveTemplate, String $beanClassName) {
        TemplateManager.getInstance((Project)$project).startTemplate($editor, (Template)$liveTemplate, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLASS_NAME", (Object)$beanClassName)), null);
    }

    private static final void actionPerformed$lambda$2$0(Project $project, PsiFile $psiFile, String $templateName, Editor $editor, TemplateImpl $liveTemplate, String $beanClassName) {
        Object[] objectArray = new PsiFile[]{$psiFile};
        WriteCommandAction.Builder builder = WriteCommandAction.writeCommandAction((Project)$project, (PsiFile[])objectArray);
        objectArray = new Object[]{$templateName};
        builder.withName(SpringBundle.message("progress.creating.component", objectArray)).run(() -> GenerateSpringComponentAction.actionPerformed$lambda$2$0$0($project, $editor, $liveTemplate, $beanClassName));
    }

    private static final void actionPerformed$lambda$1(Project $project, Editor $editor, TemplateImpl $liveTemplate, DataContext $dataContext) {
        TemplateManager.getInstance((Project)$project).startTemplate($editor, (Template)$liveTemplate, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLASS_NAME", (Object)$dataContext.getData(GenerateSpringComponentActionKt.getSPRING_CLASS_NAME_KEY()))), null);
    }

    private static final Unit actionPerformed$lambda$2(Map $liveTemplates, GenerateSpringComponentAction this$0, Project $project, PsiFile $psiFile, Editor $editor, SpringFileTemplateDescriptor template, String beanClassName) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)beanClassName, (String)"beanClassName");
        String string = (String)$liveTemplates.get(template);
        if (string == null) {
            return Unit.INSTANCE;
        }
        String templateName = string;
        TemplateImpl templateImpl = this$0.findTemplate(templateName);
        if (templateImpl == null) {
            return Unit.INSTANCE;
        }
        TemplateImpl liveTemplate = templateImpl;
        SpringFeatureUsagesCollector.INSTANCE.beanGeneratedEvent($project, template.getDisplayName(), templateName, $psiFile.getLanguage().getID());
        ApplicationManager.getApplication().invokeLater(() -> GenerateSpringComponentAction.actionPerformed$lambda$2$0($project, $psiFile, templateName, $editor, liveTemplate, beanClassName));
        return Unit.INSTANCE;
    }
}

