/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReferenceHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfigurationInspection;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.jam.utils.SpringResourceLocationsUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "<init>", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getTestingSqlConfig", "Lcom/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSqlConfig;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkContextConfiguration", "", "contextConfiguration", "Lcom/intellij/spring/model/jam/testContexts/ContextConfiguration;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "findContextXmlTargets", "", "Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "containingFile", "Lcom/intellij/psi/PsiFile;", "isTargetDirectory", "tc", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileTargetContext;", "hasInnerConfigurations", "configuration", "isLocationsAttributesDefined", "isLocationsAttributesDefinedInHierarchy", "processConfigurationsHierarchy", "processor", "Lcom/intellij/util/Processor;", "intellij.spring.core"})
public final class SpringContextConfigurationInspection
extends SpringUastInspectionBase {
    public SpringContextConfigurationInspection() {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(UClass.class)};
        super(kClassArray);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        SpringTestingSqlConfig sqlConfig;
        SpringTransactionConfiguration transactionConfiguration;
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UElement uElement = uClass.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement nameIdentifier = uElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass)) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        ContextConfiguration contextConfiguration = (ContextConfiguration)jamService.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass);
        if (contextConfiguration != null) {
            this.checkContextConfiguration(contextConfiguration, holder);
        }
        if ((transactionConfiguration = (SpringTransactionConfiguration)SpringTransactionConfiguration.META.getJamElement((PsiModifierListOwner)psiClass)) != null) {
            SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, transactionConfiguration.getTransactionManagerAttributeElement());
        }
        if ((sqlConfig = this.getTestingSqlConfig(psiClass)) != null) {
            SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getTransactionManagerElement());
            SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getDatasourceAttrElement());
        }
        return holder.getResultsArray();
    }

    private final SpringTestingSqlConfig getTestingSqlConfig(PsiClass psiClass) {
        SpringTestingSql testingSql;
        SpringTestingSqlConfig sqlConfig = (SpringTestingSqlConfig)SpringTestingSqlConfig.META.getJamElement((PsiModifierListOwner)psiClass);
        if (sqlConfig != null) {
            return sqlConfig;
        }
        SpringTestingSql springTestingSql = testingSql = (SpringTestingSql)SpringTestingSql.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        return springTestingSql != null ? springTestingSql.getSqlConfig() : null;
    }

    private final void checkContextConfiguration(ContextConfiguration contextConfiguration, ProblemsHolder holder) {
        Object[] objectArray;
        PsiAnnotation annotation;
        XmlFile xmlFile;
        if (this.isLocationsAttributesDefinedInHierarchy(contextConfiguration)) {
            for (JamStringAttributeElement attributeElement : contextConfiguration.getLocationElements()) {
                Intrinsics.checkNotNull((Object)attributeElement);
                SpringResourceLocationsUtil.INSTANCE.checkResourceLocation(holder, attributeElement);
            }
        } else if (SpringTestContextUtilImpl.isGenericXmlContextLoader(contextConfiguration) && (xmlFile = SpringTestContextUtilImpl.getDefaultLocation(contextConfiguration)) == null) {
            LocalQuickFix[] localQuickFixArray;
            PsiAnnotation psiAnnotation = contextConfiguration.getAnnotation();
            Intrinsics.checkNotNull((Object)psiAnnotation);
            annotation = psiAnnotation;
            PsiDirectory directory = annotation.getContainingFile().getContainingDirectory();
            String newContextFileName = SpringTestContextUtilImpl.getDefaultAppContextName(contextConfiguration);
            LocalQuickFix fix2 = null;
            if (directory != null) {
                Project project = holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiFile psiFile = annotation.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                List<TargetDirectory> directories = this.findContextXmlTargets(project, psiFile);
                fix2 = (LocalQuickFix)new CreateFilePathFix((PsiElement)annotation, new NewFileLocation(directories, newContextFileName), () -> SpringContextConfigurationInspection.checkContextConfiguration$lambda$0(annotation));
            }
            PsiElement psiElement = (PsiElement)annotation;
            objectArray = new Object[]{newContextFileName};
            String string = SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", objectArray);
            if (fix2 == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{fix2};
                localQuickFixArray = localQuickFixArray2;
            }
            objectArray = localQuickFixArray;
            holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
        if (SpringTestContextUtilImpl.isAnnotationConfigLoader(contextConfiguration)) {
            CommonProcessors.FindProcessor<ContextConfiguration> processor2 = new CommonProcessors.FindProcessor<ContextConfiguration>(){

                protected boolean accept(ContextConfiguration cc) {
                    Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
                    return cc.getConfigurationClasses().size() != 0;
                }
            };
            this.processConfigurationsHierarchy(contextConfiguration, (Processor<ContextConfiguration>)((Processor)processor2));
            if (!processor2.isFound() && !this.hasInnerConfigurations(contextConfiguration)) {
                LocalQuickFix[] localQuickFixArray;
                PsiAnnotation psiAnnotation = contextConfiguration.getAnnotation();
                Intrinsics.checkNotNull((Object)psiAnnotation);
                annotation = psiAnnotation;
                PsiClass psiClass = contextConfiguration.getPsiElement();
                if (psiClass == null) {
                    return;
                }
                PsiClass aClass = psiClass;
                LocalQuickFix fix3 = new LocalQuickFix(){

                    public String getFamilyName() {
                        String string = SpringBundle.message("SpringContextConfigurationInspection.create.nested.configuration.class", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }

                    public void applyFix(Project project, ProblemDescriptor descriptor) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        PsiClass configurationClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
                        if (configurationClass == null) {
                            return;
                        }
                        PsiClass existedClass = configurationClass.findInnerClassByName("ContextConfiguration", false);
                        if (existedClass != null) {
                            PsiModifierList psiModifierList = existedClass.getModifierList();
                            v1 = (PsiElement)(psiModifierList != null ? psiModifierList.addAnnotation("org.springframework.context.annotation.Configuration") : null);
                        } else {
                            PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)project).createClass("ContextConfiguration");
                            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"createClass(...)");
                            PsiClass innerClass = psiClass;
                            PsiModifierList modifierList = innerClass.getModifierList();
                            if (modifierList != null) {
                                modifierList.setModifierProperty("public", true);
                                modifierList.setModifierProperty("static", true);
                                modifierList.addAnnotation("org.springframework.context.annotation.Configuration");
                            }
                            v1 = configurationClass.add((PsiElement)innerClass);
                        }
                    }
                };
                PsiElement psiElement = (PsiElement)annotation;
                Object[] objectArray2 = new Object[]{aClass.getName() + "ContextConfiguration"};
                String string = SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", objectArray2);
                if (holder.isOnTheFly()) {
                    objectArray = new checkContextConfiguration.fix.1[]{fix3};
                    localQuickFixArray = (LocalQuickFix[])objectArray;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                objectArray2 = localQuickFixArray;
                holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray2, objectArray2.length));
            }
        }
    }

    private final List<TargetDirectory> findContextXmlTargets(Project project, PsiFile containingFile) {
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile != null) {
            PsiFileReferenceHelper psiFileReferenceHelper = PsiFileReferenceHelper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileReferenceHelper, (String)"getInstance(...)");
            PsiFileReferenceHelper helper2 = psiFileReferenceHelper;
            if (helper2.isMine(project, virtualFile)) {
                ArrayList<TargetDirectory> directories = new ArrayList<TargetDirectory>();
                Collection collection = helper2.getTargetContexts(project, virtualFile, false);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTargetContexts(...)");
                Collection targetContexts = collection;
                for (FileTargetContext tc : targetContexts) {
                    PsiDirectory directory;
                    Intrinsics.checkNotNull((Object)tc);
                    if (!this.isTargetDirectory(tc) || (directory = tc.getFileSystemItem().getManager().findDirectory(tc.getFileSystemItem().getVirtualFile())) == null) continue;
                    directories.add(new TargetDirectory(directory, tc.getPathToCreate()));
                }
                if (!((Collection)directories).isEmpty()) {
                    return directories;
                }
            }
        }
        return CollectionsKt.listOf((Object)new TargetDirectory(containingFile.getContainingDirectory()));
    }

    private final boolean isTargetDirectory(FileTargetContext tc) {
        PsiFileSystemItem context = tc.getFileSystemItem();
        return context.getVirtualFile() != null && context.isDirectory() && context.isValid() && context.getVirtualFile().isInLocalFileSystem();
    }

    private final boolean hasInnerConfigurations(ContextConfiguration configuration) {
        PsiClass psiClass = configuration.getPsiElement();
        if (psiClass == null) {
            return false;
        }
        PsiClass configurationClass = psiClass;
        PsiClass[] psiClassArray = configurationClass.getAllInnerClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getAllInnerClasses(...)");
        for (PsiClass psiClass2 : psiClassArray) {
            if (!psiClass2.hasModifierProperty("static") || JamService.getJamService((Project)psiClass2.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass2) == null) continue;
            return true;
        }
        return false;
    }

    private final boolean isLocationsAttributesDefined(ContextConfiguration contextConfiguration) {
        return contextConfiguration.hasLocationsAttribute() || contextConfiguration.hasValueAttribute();
    }

    private final boolean isLocationsAttributesDefinedInHierarchy(ContextConfiguration contextConfiguration) {
        CommonProcessors.FindProcessor<ContextConfiguration> searchLocationsProcessor2 = new CommonProcessors.FindProcessor<ContextConfiguration>(this){
            final /* synthetic */ SpringContextConfigurationInspection this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean accept(ContextConfiguration cc) {
                Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
                return SpringContextConfigurationInspection.access$isLocationsAttributesDefined(this.this$0, cc);
            }
        };
        this.processConfigurationsHierarchy(contextConfiguration, (Processor<ContextConfiguration>)((Processor)searchLocationsProcessor2));
        return searchLocationsProcessor2.isFound();
    }

    private final boolean processConfigurationsHierarchy(ContextConfiguration contextConfiguration, Processor<ContextConfiguration> processor2) {
        if (!processor2.process((Object)contextConfiguration)) {
            return false;
        }
        PsiClass psiClass = contextConfiguration.getPsiElement();
        if (psiClass != null) {
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            for (PsiClass superClass = psiClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                JamMemberMeta[] jamMemberMetaArray = new JamMemberMeta[]{SpringContextConfiguration.META};
                SpringContextConfiguration configuration = (SpringContextConfiguration)service.getJamElement((PsiElement)superClass, jamMemberMetaArray);
                if (configuration == null || processor2.process((Object)configuration)) continue;
                return false;
            }
        }
        return true;
    }

    private static final String checkContextConfiguration$lambda$0(PsiAnnotation $annotation) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$annotation));
        Intrinsics.checkNotNull((Object)module);
        Module module2 = module;
        Module[] moduleArray = new Module[]{module2};
        return SpringCommonUtils.getSpringXmlTemplate((Module[])moduleArray).getText();
    }

    public static final /* synthetic */ boolean access$isLocationsAttributesDefined(SpringContextConfigurationInspection $this, ContextConfiguration contextConfiguration) {
        return $this.isLocationsAttributesDefined(contextConfiguration);
    }
}

