/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.runtime;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.runtime.SpringRuntimeResolverService;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import com.intellij.util.PathUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u000fH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001b\u0010\n\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeResourceImpl;", "Lcom/intellij/spring/runtime/SpringRuntimeResource;", "description", "", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getPath", "displayName", "getDisplayName", "displayName$delegate", "Lkotlin/Lazy;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "icon$delegate", "navigatableRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/pom/Navigatable;", "hasDescription", "", "hasDetails", "isClassResource", "isXmlResource", "matchesClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "strict", "matchesXmlConfig", "xmlFile", "Lcom/intellij/psi/PsiFile;", "resourceContext", "Lcom/intellij/spring/runtime/SpringRuntimeResourceContext;", "findNavigatable", "findResourceNavigatable", "findResourceElement", "Lcom/intellij/psi/PsiElement;", "getCachedValue", "getFileIcon", "UrlNavigatable", "Companion", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringRuntimeResourceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringRuntimeResourceImpl.kt\ncom/intellij/spring/runtime/SpringRuntimeResourceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
public final class SpringRuntimeResourceImpl
implements SpringRuntimeResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final String path;
    @NotNull
    private final Lazy displayName$delegate;
    @NotNull
    private final Lazy icon$delegate;
    @Nullable
    private volatile WeakReference<Navigatable> navigatableRef;
    @NotNull
    public static final String FILE_PROTOCOL = "file:";
    @NotNull
    private static final String CLASS_PATH_RESOURCE_DESCRIPTION = "class path resource";
    @NotNull
    private static final String FILE_RESOURCE_DESCRIPTION = "file";
    @NotNull
    private static final String URL_RESOURCE_DESCRIPTION = "URL";
    @NotNull
    private static final String CLASS_DOT_EXTENSION = ".class";
    @NotNull
    private static final String XML_DOT_EXTENSION = ".xml";
    @NotNull
    private static final String DECLARATIVE_DESCRIPTION_SEPARATOR = " declared on ";

    public SpringRuntimeResourceImpl(@NotNull String description, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.description = description;
        this.path = path;
        this.displayName$delegate = LazyKt.lazy(() -> SpringRuntimeResourceImpl.displayName_delegate$lambda$0(this));
        this.icon$delegate = LazyKt.lazy(() -> SpringRuntimeResourceImpl.icon_delegate$lambda$0(this));
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getDisplayName() {
        Lazy lazy = this.displayName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public Icon getIcon() {
        Lazy lazy = this.icon$delegate;
        return (Icon)lazy.getValue();
    }

    public boolean hasDescription() {
        return ((CharSequence)this.getDescription()).length() > 0 && !StringsKt.equals((String)this.getDescription(), (String)"null", (boolean)true);
    }

    public boolean hasDetails() {
        return StringsKt.contains$default((CharSequence)this.getDescription(), (char)'[', (boolean)false, (int)2, null);
    }

    public boolean isClassResource() {
        return SpringRuntimeResourceImpl.Companion.isClassResource(this.getPath());
    }

    public boolean isXmlResource() {
        return SpringRuntimeResourceImpl.Companion.isXmlResource(this.getPath());
    }

    public boolean matchesClass(@NotNull PsiClass psiClass, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (!this.hasDescription()) {
            return false;
        }
        Object className = null;
        if (!this.hasDetails()) {
            className = StringsKt.substringBefore$default((String)this.getDescription(), (String)" defined in ", null, (int)2, null);
        } else {
            if (!this.isClassResource() || StringsKt.startsWith$default((String)this.getDescription(), (String)URL_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
                return false;
            }
            if (StringsKt.startsWith$default((String)this.getDescription(), (String)CLASS_PATH_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
                String string = StringUtil.trimEnd((String)this.getPath(), (String)CLASS_DOT_EXTENSION, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
                resourcePath = string;
                CharSequence charSequence = (CharSequence)resourcePath;
                Regex regex = new Regex("[\\\\/$]");
                String string2 = ".";
                className = resourcePath = regex.replace(charSequence, string2);
            } else if (StringsKt.startsWith$default((String)this.getDescription(), (String)FILE_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
                VirtualFile resourceFile;
                resourcePath = this.getPath();
                String innerClassesSuffix = null;
                int index = StringsKt.indexOf$default((CharSequence)((CharSequence)resourcePath), (char)'$', (int)0, (boolean)false, (int)6, null);
                if (index >= 0) {
                    String string = ((String)resourcePath).substring(index + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    innerClassesSuffix = StringUtil.trimEnd((String)string, (String)CLASS_DOT_EXTENSION, (boolean)true);
                    String string3 = ((String)resourcePath).substring(0, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String string4 = ((String)resourcePath).substring(((String)resourcePath).length() - 6);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    resourcePath = string3 + string4;
                }
                if ((resourceFile = VfsUtil.findFile((Path)Paths.get((String)resourcePath, new String[0]), (boolean)false)) == null || !resourceFile.isValid()) {
                    return false;
                }
                PsiFile psiFile = psiClass.getManager().findFile(resourceFile);
                if (psiFile instanceof PsiClassOwner) {
                    className = ((PsiClassOwner)psiFile).getPackageName() + "." + FileUtilRt.getNameWithoutExtension((String)((PsiClassOwner)psiFile).getName());
                }
                if (className != null && innerClassesSuffix != null) {
                    className = (String)className + "." + StringUtil.replace((String)innerClassesSuffix, (String)"$", (String)".");
                }
            }
        }
        if (className == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)className, (Object)psiClass.getQualifiedName())) {
            return true;
        }
        if (strict) {
            return false;
        }
        PsiClass resourceClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass((String)className, psiClass.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)resourceClass, (PsiClass)psiClass, (boolean)true);
    }

    public boolean matchesXmlConfig(@NotNull PsiFile xmlFile, @NotNull SpringRuntimeResourceContext resourceContext) {
        VirtualFile elementFile;
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)resourceContext, (String)"resourceContext");
        if (!(xmlFile instanceof XmlFile)) {
            return false;
        }
        if (!this.hasDescription()) {
            return false;
        }
        if (!this.hasDetails() || this.isClassResource()) {
            return false;
        }
        String resourcePath = this.getPath();
        boolean urlFileResource = false;
        if (StringsKt.startsWith$default((String)this.getDescription(), (String)URL_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)this.getPath(), (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                String string = this.getPath().substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                resourcePath = string;
                urlFileResource = true;
            } else {
                return false;
            }
        }
        if ((elementFile = ((XmlFile)xmlFile).getOriginalFile().getVirtualFile()) == null) {
            return false;
        }
        if (urlFileResource || StringsKt.startsWith$default((String)this.getDescription(), (String)FILE_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            String[] path;
            VirtualFile resourceFile;
            String[] stringArray;
            String[] it = stringArray = Paths.get(resourcePath, new String[0]);
            boolean bl = false;
            Object object = it.isAbsolute() ? stringArray : null;
            if (object == null) {
                stringArray = new String[]{resourcePath};
                object = Paths.get(resourceContext.getWorkingDirectory(), stringArray);
            }
            if ((resourceFile = VfsUtil.findFile((Path)(path = object), (boolean)false)) == null || !resourceFile.isValid()) {
                return false;
            }
            return Intrinsics.areEqual((Object)resourceFile, (Object)elementFile);
        }
        if (StringsKt.startsWith$default((String)this.getDescription(), (String)CLASS_PATH_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            String string = elementFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String elementPath = string;
            String string2 = PathUtil.toSystemIndependentName((String)elementPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            String string3 = PathUtil.toSystemIndependentName((String)resourcePath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
            return StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
        }
        return false;
    }

    @Nullable
    public Navigatable findNavigatable(@NotNull SpringRuntimeResourceContext resourceContext) {
        Intrinsics.checkNotNullParameter((Object)resourceContext, (String)"resourceContext");
        if (StringsKt.startsWith$default((String)this.getDescription(), (String)CLASS_PATH_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            return (Navigatable)SpringRuntimeResourceImpl.Companion.getClassPathResource(this.getPath(), resourceContext);
        }
        if (StringsKt.startsWith$default((String)this.getDescription(), (String)FILE_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            return (Navigatable)SpringRuntimeResourceImpl.Companion.getFileResource(this.getPath(), resourceContext);
        }
        if (StringsKt.startsWith$default((String)this.getDescription(), (String)URL_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.getDescription(), (String)"Config Server", (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)this.getPath(), (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                String sanitizedPath = SpringRuntimeResolverService.Companion.getInstance().removeFileProtocol(this.getPath());
                return (Navigatable)SpringRuntimeResourceImpl.Companion.getFileResource(sanitizedPath, resourceContext);
            }
            return new UrlNavigatable(this.getPath());
        }
        int declarativeIndex = StringsKt.lastIndexOf$default((CharSequence)this.getDescription(), (String)DECLARATIVE_DESCRIPTION_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        if (declarativeIndex >= 0) {
            String string = this.getDescription().substring(declarativeIndex + 13);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String className = string;
            return (Navigatable)SpringRuntimeResourceImpl.Companion.getClassByShortName(className, resourceContext.getProject(), resourceContext.getSearchScope());
        }
        return null;
    }

    @Nullable
    public Navigatable findResourceNavigatable(@NotNull SpringRuntimeResourceContext resourceContext) {
        Intrinsics.checkNotNullParameter((Object)resourceContext, (String)"resourceContext");
        if (!this.hasDescription()) {
            return null;
        }
        Navigatable navigatable = this.getCachedValue(resourceContext);
        if (navigatable != null) {
            return navigatable;
        }
        navigatable = !this.hasDetails() ? (Navigatable)Companion.findClass$intellij_spring_core(this.getDescription(), resourceContext.getProject(), resourceContext.getSearchScope()) : this.findNavigatable(resourceContext);
        this.navigatableRef = new WeakReference<Navigatable>(navigatable);
        return navigatable;
    }

    @Nullable
    public PsiElement findResourceElement(@NotNull SpringRuntimeResourceContext resourceContext) {
        Intrinsics.checkNotNullParameter((Object)resourceContext, (String)"resourceContext");
        Navigatable navigatable = this.findResourceNavigatable(resourceContext);
        return navigatable instanceof PsiElement ? (PsiElement)navigatable : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Navigatable getCachedValue(SpringRuntimeResourceContext resourceContext) {
        Navigatable navigatable = (Navigatable)SoftReference.dereference((Reference)this.navigatableRef);
        if (navigatable == null) {
            return null;
        }
        Navigatable navigatable2 = navigatable;
        if (!(navigatable2 instanceof PsiElement)) return navigatable2;
        if (!((PsiElement)navigatable2).isValid()) return null;
        if (navigatable2 instanceof PsiClass) {
            if (!this.matchesClass((PsiClass)navigatable2, false)) return null;
            return navigatable2;
        }
        if (!(navigatable2 instanceof XmlFile)) return navigatable2;
        if (!this.matchesXmlConfig((PsiFile)navigatable2, resourceContext)) return null;
        return navigatable2;
    }

    private final Icon getFileIcon() {
        return this.isClassResource() ? AllIcons.Nodes.Class : (this.isXmlResource() ? SpringApiIcons.SpringConfig : null);
    }

    private static final String displayName_delegate$lambda$0(SpringRuntimeResourceImpl this$0) {
        List list;
        int nameStart;
        if (!this$0.hasDescription()) {
            String string = SpringBundle.message("spring.application.auto.configuration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String displayName = this$0.getDescription();
        int indexStart = StringsKt.lastIndexOf$default((CharSequence)displayName, (String)"/", (int)0, (boolean)false, (int)6, null);
        int indexEnd = StringsKt.lastIndexOf$default((CharSequence)displayName, (String)"]", (int)0, (boolean)false, (int)6, null);
        if (indexEnd > -1 && indexStart < 0 && (nameStart = StringsKt.lastIndexOf$default((CharSequence)displayName, (String)"[", (int)0, (boolean)false, (int)6, null)) >= 0 && StringsKt.indexOf$default((CharSequence)displayName, (String)".", (int)nameStart, (boolean)false, (int)4, null) > -1) {
            indexStart = nameStart;
        }
        if (indexStart > -1 && indexEnd > -1 && indexStart < indexEnd) {
            String string = displayName.substring(indexStart + 1, indexEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            displayName = string;
        }
        if (SpringRuntimeResourceImpl.Companion.isXmlResource(displayName = StringsKt.removePrefix((String)displayName, (CharSequence)FILE_PROTOCOL))) {
            return displayName;
        }
        int declarativeIndex = StringsKt.lastIndexOf$default((CharSequence)displayName, (String)DECLARATIVE_DESCRIPTION_SEPARATOR, (int)0, (boolean)false, (int)6, null);
        if (declarativeIndex >= 0) {
            String string = displayName.substring(declarativeIndex + 13);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            displayName = string;
            char[] cArray = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)displayName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            int index = StringsKt.lastIndexOf$default((CharSequence)(displayName = StringsKt.removeSuffix((String)displayName, (CharSequence)CLASS_DOT_EXTENSION)), (String)".", (int)0, (boolean)false, (int)6, null);
            if (index > -1) {
                String string = displayName.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                displayName = string;
            }
            char[] cArray = new char[]{'$'};
            list = StringsKt.split$default((CharSequence)displayName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        List names2 = list;
        StringBuilder sb = new StringBuilder();
        sb.append((String)names2.get(names2.size() - 1));
        for (int i = names2.size() - 2; -1 < i; --i) {
            sb.append(" in ");
            sb.append((String)names2.get(i));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Icon icon_delegate$lambda$0(SpringRuntimeResourceImpl this$0) {
        if (!this$0.hasDescription()) {
            return SpringApiIcons.SpringJavaConfig;
        }
        if (!this$0.hasDetails()) {
        }
        if (StringsKt.startsWith$default((String)this$0.getDescription(), (String)CLASS_PATH_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this$0.getDescription(), (String)FILE_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            return this$0.getFileIcon();
        }
        if (StringsKt.startsWith$default((String)this$0.getDescription(), (String)URL_RESOURCE_DESCRIPTION, (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)this$0.getPath(), (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                return this$0.getFileIcon();
            }
            return JavaUltimateIcons.Javaee.Web_xml;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J'\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001bJ\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeResourceImpl$Companion;", "", "<init>", "()V", "FILE_PROTOCOL", "", "CLASS_PATH_RESOURCE_DESCRIPTION", "FILE_RESOURCE_DESCRIPTION", "URL_RESOURCE_DESCRIPTION", "CLASS_DOT_EXTENSION", "XML_DOT_EXTENSION", "DECLARATIVE_DESCRIPTION_SEPARATOR", "getClassPathResource", "Lcom/intellij/psi/NavigatablePsiElement;", "path", "resourceContext", "Lcom/intellij/spring/runtime/SpringRuntimeResourceContext;", "getFileResource", "getClassByShortName", "Lcom/intellij/psi/PsiClass;", "shortClassName", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClass", "className", "findClass$intellij_spring_core", "findInnerClass", "psiClass", "innerClassesSuffix", "isClassResource", "", "isXmlResource", "intellij.spring.core"})
    @SourceDebugExtension(value={"SMAP\nSpringRuntimeResourceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringRuntimeResourceImpl.kt\ncom/intellij/spring/runtime/SpringRuntimeResourceImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,455:1\n1#2:456\n742#3,9:457\n37#4,2:466\n*S KotlinDebug\n*F\n+ 1 SpringRuntimeResourceImpl.kt\ncom/intellij/spring/runtime/SpringRuntimeResourceImpl$Companion\n*L\n415#1:457,9\n415#1:466,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final NavigatablePsiElement getClassPathResource(String path, SpringRuntimeResourceContext resourceContext) {
            PsiElement element;
            PsiReference reference;
            if (this.isClassResource(path)) {
                String string = StringUtil.trimEnd((String)path, (String)SpringRuntimeResourceImpl.CLASS_DOT_EXTENSION, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
                String classPath = string;
                CharSequence charSequence = classPath;
                Regex regex = new Regex("[\\\\/]");
                String string2 = ".";
                classPath = regex.replace(charSequence, string2);
                return (NavigatablePsiElement)this.findClass$intellij_spring_core(classPath, resourceContext.getProject(), resourceContext.getSearchScope());
            }
            Module module = resourceContext.getModule();
            if (module == null) {
                return null;
            }
            PsiElement runConfigurationElement = resourceContext.getRunConfigurationElement();
            if (runConfigurationElement == null) {
                return null;
            }
            Module[] moduleArray = new Module[]{module};
            PsiReference[] psiReferenceArray = new FilePathReferenceProvider().getReferencesByElement(runConfigurationElement, path, 0, true, moduleArray);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesByElement(...)");
            PsiReference[] references = psiReferenceArray;
            if (!(references.length == 0) && (reference = references[references.length - 1]) != null && (element = reference.resolve()) != null) {
                return (NavigatablePsiElement)element.getContainingFile();
            }
            return null;
        }

        private final NavigatablePsiElement getFileResource(String path, SpringRuntimeResourceContext resourceContext) {
            String[] file;
            VirtualFile resourceFile;
            String[] stringArray;
            int index;
            Object filePath = path;
            String innerClassesSuffix = null;
            if (this.isClassResource((String)filePath) && (index = StringsKt.indexOf$default((CharSequence)((CharSequence)filePath), (char)'$', (int)0, (boolean)false, (int)6, null)) >= 0) {
                String string = ((String)filePath).substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                innerClassesSuffix = StringUtil.trimEnd((String)string, (String)SpringRuntimeResourceImpl.CLASS_DOT_EXTENSION, (boolean)true);
                String string2 = ((String)filePath).substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = ((String)filePath).substring(((String)filePath).length() - 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                filePath = string2 + string3;
            }
            String[] it = stringArray = Paths.get((String)filePath, new String[0]);
            boolean bl = false;
            Object object = it.isAbsolute() ? stringArray : null;
            if (object == null) {
                stringArray = new String[]{filePath};
                object = Paths.get(resourceContext.getWorkingDirectory(), stringArray);
            }
            if ((resourceFile = VfsUtil.findFile((Path)(file = object), (boolean)false)) != null && resourceFile.isValid()) {
                PsiFile psiFile = PsiManager.getInstance((Project)resourceContext.getProject()).findFile(resourceFile);
                if (psiFile instanceof PsiClassOwner) {
                    String className = ((PsiClassOwner)psiFile).getPackageName() + "." + FileUtilRt.getNameWithoutExtension((String)((PsiClassOwner)psiFile).getName());
                    PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)resourceContext.getProject(), (String)className, (GlobalSearchScope)resourceContext.getSearchScope());
                    if (psiClass != null && innerClassesSuffix != null) {
                        psiClass = this.findInnerClass(psiClass, innerClassesSuffix);
                    }
                    if (psiClass != null) {
                        return (NavigatablePsiElement)psiClass;
                    }
                }
                return (NavigatablePsiElement)psiFile;
            }
            return null;
        }

        private final PsiClass getClassByShortName(String shortClassName, Project project, GlobalSearchScope searchScope) {
            String innerClassesSuffix;
            String string;
            int separatorIndex = StringsKt.indexOf$default((CharSequence)shortClassName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (separatorIndex >= 0) {
                String string2 = shortClassName.substring(0, separatorIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = shortClassName;
            }
            String className = string;
            Collection classes = JavaShortClassNameIndex.getInstance().getClasses(className, project, searchScope);
            if (separatorIndex >= 0) {
                String string3 = shortClassName.substring(separatorIndex + 1);
                v3 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                v3 = innerClassesSuffix = null;
            }
            if (innerClassesSuffix == null) {
                Intrinsics.checkNotNull((Object)classes);
                return (PsiClass)CollectionsKt.firstOrNull((Iterable)classes);
            }
            for (PsiClass psiClass : classes) {
                Intrinsics.checkNotNull((Object)psiClass);
                PsiClass innerClass = this.findInnerClass(psiClass, innerClassesSuffix);
                if (innerClass == psiClass) continue;
                return innerClass;
            }
            return null;
        }

        @Nullable
        public final PsiClass findClass$intellij_spring_core(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
            PsiClass psiClass;
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            String name = className;
            String innerClassesSuffix = null;
            int index = StringsKt.indexOf$default((CharSequence)name, (char)'$', (int)0, (boolean)false, (int)6, null);
            if (index >= 0) {
                String string = name.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                innerClassesSuffix = string;
                String string2 = name.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                name = string2;
            }
            if ((psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)name, (GlobalSearchScope)searchScope)) == null || innerClassesSuffix == null) {
                return psiClass;
            }
            return this.findInnerClass(psiClass, innerClassesSuffix);
        }

        /*
         * WARNING - void declaration
         */
        private final PsiClass findInnerClass(PsiClass psiClass, String innerClassesSuffix) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            PsiClass parent = psiClass;
            Object object = innerClassesSuffix;
            Regex regex = new Regex("\\$");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            block3: for (String innerClassName : thisCollection$iv.toArray(new String[0])) {
                if (((CharSequence)innerClassName).length() == 0) {
                    return parent;
                }
                if (StringUtil.isDecimalDigit((char)innerClassName.charAt(0))) {
                    try {
                        int classIndex = Integer.parseInt(innerClassName) - 1;
                        for (AnonymousElementProvider provider : AnonymousElementProvider.EP_NAME.getExtensionList()) {
                            PsiElement[] elements;
                            Intrinsics.checkNotNullExpressionValue((Object)provider.getAnonymousElements((PsiElement)parent), (String)"getAnonymousElements(...)");
                            if (classIndex >= elements.length) continue;
                            PsiElement anonymousElement = elements[classIndex];
                            if (!(anonymousElement instanceof PsiClass)) {
                                return parent;
                            }
                            parent = (PsiClass)anonymousElement;
                            continue block3;
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return parent;
                    }
                }
                PsiClass innerClass = parent.findInnerClassByName(innerClassName, false);
                if (innerClass == null) {
                    return parent;
                }
                parent = innerClass;
            }
            return parent;
        }

        private final boolean isClassResource(String path) {
            return StringUtil.endsWithIgnoreCase((String)path, (String)SpringRuntimeResourceImpl.CLASS_DOT_EXTENSION);
        }

        private final boolean isXmlResource(String path) {
            return StringsKt.endsWith((String)path, (String)SpringRuntimeResourceImpl.XML_DOT_EXTENSION, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0082\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeResourceImpl$UrlNavigatable;", "Lcom/intellij/pom/Navigatable;", "url", "", "<init>", "(Ljava/lang/String;)V", "navigate", "", "requestFocus", "", "canNavigate", "equals", "other", "", "hashCode", "", "intellij.spring.core"})
    private static final class UrlNavigatable
    implements Navigatable {
        @NotNull
        private final String url;

        public UrlNavigatable(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.url);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof UrlNavigatable) {
                return Intrinsics.areEqual((Object)this.url, (Object)((UrlNavigatable)other).url);
            }
            return false;
        }

        public int hashCode() {
            return this.url.hashCode();
        }
    }
}

