/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SwingUndoManagerWrapper;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoManagerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UndoRedoAction
extends DumbAwareAction
implements LightEditCompatible {
    public static final Key<Boolean> IGNORE_SWING_UNDO_MANAGER = new Key("IGNORE_SWING_UNDO_MANAGER");
    private static final Logger LOG = Logger.getInstance(UndoRedoAction.class);
    private boolean myActionInProgress;

    public UndoRedoAction() {
        this.setEnabledInModalContext(true);
    }

    protected abstract boolean isAvailable(FileEditor var1, UndoManager var2);

    protected abstract void perform(FileEditor var1, UndoManager var2);

    protected abstract Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getActionNameAndDescription(FileEditor var1, UndoManager var2);

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            UndoRedoAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        FileEditor editor2 = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
        UndoManager undoManager = this.getUndoManager(editor2, dataContext2, false);
        if (undoManager == null) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setEnabled(this.isAvailable(editor2, undoManager));
        Pair<String, String> pair = this.getActionNameAndDescription(editor2, undoManager);
        presentation2.setText((String)pair.first);
        presentation2.setDescription((String)pair.second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext2;
        FileEditor editor2;
        UndoManager undoManager;
        if (event == null) {
            UndoRedoAction.$$$reportNull$$$0(1);
        }
        if ((undoManager = this.getUndoManager(editor2 = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2 = event.getDataContext()), dataContext2, true)) == null) {
            return;
        }
        this.myActionInProgress = true;
        try {
            this.perform(editor2, undoManager);
        }
        finally {
            this.myActionInProgress = false;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            UndoRedoAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @Nullable
    private UndoManager getUndoManager(@Nullable FileEditor editor2, DataContext dataContext2, boolean isActionPerformed) {
        return UndoRedoAction.getUndoManager(editor2, dataContext2, this.myActionInProgress, isActionPerformed);
    }

    @ApiStatus.Internal
    @Nullable
    public static UndoManager getUndoManager(@Nullable FileEditor editor2, DataContext dataContext2, boolean isActionInProgress, boolean isActionPerformed) {
        for (UndoManagerProvider provider : UndoManagerProvider.EP_NAME.getExtensionList()) {
            UndoManager providedManager = provider.getUndoManager(dataContext2);
            if (providedManager == null) continue;
            return providedManager;
        }
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
        if (component2 instanceof JTextComponent && !ClientProperty.isTrue((Component)component2, IGNORE_SWING_UNDO_MANAGER)) {
            return SwingUndoManagerWrapper.fromContext(dataContext2);
        }
        JRootPane rootPane = null;
        JBPopup popup2 = null;
        if (editor2 == null) {
            rootPane = UIUtil.getRootPane((Component)component2);
            popup2 = rootPane != null ? (JBPopup)rootPane.getClientProperty("JBPopup") : null;
            boolean modalPopup = popup2 != null && popup2.isModalContext();
            boolean modalContext = Boolean.TRUE.equals(PlatformCoreDataKeys.IS_MODAL_CONTEXT.getData(dataContext2));
            if (modalPopup || modalContext) {
                return SwingUndoManagerWrapper.fromContext(dataContext2);
            }
        }
        if (isActionInProgress && isActionPerformed) {
            LOG.error("Recursive undo invocation attempt, component: %s, fileEditor: %s, rootPane: %s, popup: %s".formatted(component2, editor2, rootPane, popup2));
            return null;
        }
        Project project2 = UndoRedoAction.getProject(editor2, dataContext2);
        return project2 != null && !project2.isDefault() ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
    }

    @Nullable
    private static Project getProject(FileEditor editor2, DataContext dataContext2) {
        if (editor2 instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)editor2;
            return textEditor.getEditor().getProject();
        }
        return (Project)CommonDataKeys.PROJECT.getData(dataContext2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/UndoRedoAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/UndoRedoAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

