/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileFlavorProvider;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FileCopyPasteUtil {
    private static final Logger LOG = Logger.getInstance(FileCopyPasteUtil.class);
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor};

    private FileCopyPasteUtil() {
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(0);
        }
        return FileCopyPasteUtil.createDataFlavor(mimeType, null, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(1);
        }
        return FileCopyPasteUtil.createDataFlavor(mimeType, klass, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass, boolean register2) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(2);
        }
        try {
            FlavorMap map2;
            DataFlavor flavor2;
            DataFlavor dataFlavor = flavor2 = klass != null ? new DataFlavor(mimeType + ";class=" + klass.getName(), null, klass.getClassLoader()) : new DataFlavor(mimeType);
            if (register2 && (map2 = SystemFlavorMap.getDefaultFlavorMap()) instanceof SystemFlavorMap) {
                ((SystemFlavorMap)map2).addUnencodedNativeForFlavor(flavor2, mimeType);
            }
            return flavor2;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static DataFlavor createJvmDataFlavor(@NotNull Class<?> klass) {
        if (klass == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(3);
        }
        return FileCopyPasteUtil.createDataFlavor("application/x-java-jvm-local-objectref", klass, false);
    }

    public static boolean isFileListFlavorAvailable() {
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(FLAVORS);
    }

    public static boolean isFileListFlavorAvailable(@NotNull DnDEvent event) {
        if (event == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(4);
        }
        return ContainerUtil.or((Object[])FLAVORS, arg_0 -> ((DnDEvent)event).isDataFlavorSupported(arg_0));
    }

    public static boolean isFileListFlavorAvailable(DataFlavor @NotNull [] transferFlavors) {
        if (transferFlavors == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(5);
        }
        Set<DataFlavor> supported = Set.of(FLAVORS);
        return ContainerUtil.exists((Object[])transferFlavors, f -> f != null && supported.contains(f));
    }

    public static @Unmodifiable @Nullable List<File> getFileList(@NotNull Transferable transferable) {
        List<Path> files2;
        if (transferable == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(6);
        }
        return (files2 = FileCopyPasteUtil.getFiles(transferable)) != null ? ContainerUtil.map(files2, Path::toFile) : null;
    }

    public static @Unmodifiable @Nullable List<Path> getFiles(@NotNull Transferable transferable) {
        if (transferable == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(7);
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files2 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return ContainerUtil.mapNotNull((Collection)files2, file2 -> !Strings.isEmptyOrSpaces((CharSequence)file2.getPath()) ? file2.toPath() : null);
            }
            return LinuxDragAndDropSupport.getFiles(transferable);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static List<File> getFileListFromAttachedObject(Object attached) {
        List<File> result2 = attached instanceof FileFlavorProvider ? ((FileFlavorProvider)attached).asFileList() : (attached instanceof DnDNativeTarget.EventInfo ? FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)attached).getTransferable()) : null);
        List<Object> list2 = result2 == null ? List.of() : result2;
        if (list2 == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public static @NotNull List<@NotNull VirtualFile> getVirtualFileListFromAttachedObject(Object attached) {
        List<File> files2 = FileCopyPasteUtil.getFileListFromAttachedObject(attached);
        if (files2.isEmpty()) {
            List<VirtualFile> list2 = List.of();
            if (list2 == null) {
                FileCopyPasteUtil.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        for (File file2 : files2) {
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
            if (virtualFile2 == null) continue;
            result2.add(virtualFile2);
            virtualFile2.getFileType();
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferFlavors";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/FileCopyPasteUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/FileCopyPasteUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileListFromAttachedObject";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileListFromAttachedObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJvmDataFlavor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileListFlavorAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

