/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.FixedHotfixGroupElement;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.HotfixGroupElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorViewStructure
extends AbstractTreeStructure {
    private final ErrorTreeElement myRoot = new MyRootElement();
    private final List<String> myGroupNames = new ArrayList<String>();
    private final Map<String, GroupingElement> myGroupNameToElementMap = new HashMap<String, GroupingElement>();
    private final Map<String, List<NavigatableMessageElement>> myGroupNameToMessagesMap = new HashMap<String, List<NavigatableMessageElement>>();
    private final Map<ErrorTreeElementKind, List<ErrorTreeElement>> mySimpleMessages = new EnumMap<ErrorTreeElementKind, List<ErrorTreeElement>>(ErrorTreeElementKind.class);
    private final Object myLock = new Object();
    private static final ErrorTreeElementKind[] ourMessagesOrder = new ErrorTreeElementKind[]{ErrorTreeElementKind.INFO, ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE, ErrorTreeElementKind.GENERIC};
    private final Project myProject;
    private final boolean myCanHideWarnings;

    public ErrorViewStructure(Project project2, boolean canHideWarnings) {
        this.myProject = project2;
        this.myCanHideWarnings = canHideWarnings;
    }

    @NotNull
    public Object getRootElement() {
        ErrorTreeElement errorTreeElement = this.myRoot;
        if (errorTreeElement == null) {
            ErrorViewStructure.$$$reportNull$$$0(0);
        }
        return errorTreeElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                List<ErrorTreeElement> elements = entry.getValue();
                if (elements == null || elements.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasMessages(@NotNull Set<ErrorTreeElementKind> kinds) {
        if (kinds == null) {
            ErrorViewStructure.$$$reportNull$$$0(1);
        }
        return this.hasMessages(kinds, element -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages(@NotNull Set<ErrorTreeElementKind> kinds, Predicate<? super ErrorTreeElement> filter2) {
        if (kinds == null) {
            ErrorViewStructure.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> messages;
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                if (!kinds.contains(entry.getKey()) || (messages = entry.getValue()) == null || messages.isEmpty()) continue;
                for (ErrorTreeElement message : messages) {
                    if (!filter2.test(message)) continue;
                    return true;
                }
            }
            for (Map.Entry<Object, List<ErrorTreeElement>> entry : this.myGroupNameToMessagesMap.entrySet()) {
                messages = entry.getValue();
                if (messages == null || messages.isEmpty()) continue;
                for (ErrorTreeElement message : messages) {
                    if (!filter2.test(message) || !kinds.contains(message.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ErrorTreeElement @NotNull [] getChildElements(@NotNull Object element) {
        int n;
        ErrorTreeElementKind[] errorTreeElementKindArray;
        ArrayList<ErrorTreeElement> children2;
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(3);
        }
        if (element == this.myRoot) {
            children2 = new ArrayList<ErrorTreeElement>();
            Object object = this.myLock;
            synchronized (object) {
                errorTreeElementKindArray = ourMessagesOrder;
                n = errorTreeElementKindArray.length;
            }
        } else {
            if (element instanceof GroupingElement) {
                Object object = this.myLock;
                synchronized (object) {
                    List<NavigatableMessageElement> children3 = this.myGroupNameToMessagesMap.get(((GroupingElement)element).getName());
                    if (children3 != null && !children3.isEmpty()) {
                        if (this.isFilteringNeeded()) {
                            ArrayList<NavigatableMessageElement> filtered = new ArrayList<NavigatableMessageElement>(children3.size());
                            for (NavigatableMessageElement navigatableMessageElement : children3) {
                                if (this.shouldHide(navigatableMessageElement.getKind())) continue;
                                filtered.add(navigatableMessageElement);
                            }
                            ErrorTreeElement[] errorTreeElementArray = filtered.toArray(ErrorTreeElement.EMPTY_ARRAY);
                            // MONITOREXIT @DISABLED, blocks:[16, 4, 13, 14, 15] lbl25 : MonitorExitStatement: MONITOREXIT : var2_3
                            if (errorTreeElementArray == null) {
                                ErrorViewStructure.$$$reportNull$$$0(5);
                            }
                            return errorTreeElementArray;
                        }
                        ErrorTreeElement[] errorTreeElementArray = children3.toArray(new NavigatableMessageElement[0]);
                        // MONITOREXIT @DISABLED, blocks:[16, 4, 14, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var2_3
                        if (errorTreeElementArray == null) {
                            ErrorViewStructure.$$$reportNull$$$0(6);
                        }
                        return errorTreeElementArray;
                    }
                }
            }
            if (ErrorTreeElement.EMPTY_ARRAY == null) {
                ErrorViewStructure.$$$reportNull$$$0(7);
            }
            return ErrorTreeElement.EMPTY_ARRAY;
        }
        {
            for (int j = 0; j < n; ++j) {
                List<ErrorTreeElement> elems;
                ErrorTreeElementKind kind = errorTreeElementKindArray[j];
                if (this.shouldHide(kind) || (elems = this.mySimpleMessages.get(kind)) == null) continue;
                children2.addAll(elems);
            }
            for (String myGroupName : this.myGroupNames) {
                GroupingElement groupingElement = this.myGroupNameToElementMap.get(myGroupName);
                if (!this.shouldShowFileElement(groupingElement)) continue;
                children2.add(groupingElement);
            }
        }
        ErrorTreeElement[] errorTreeElementArray = children2.toArray(ErrorTreeElement.EMPTY_ARRAY);
        if (errorTreeElementArray == null) {
            ErrorViewStructure.$$$reportNull$$$0(4);
        }
        return errorTreeElementArray;
    }

    private boolean isFilteringNeeded() {
        if (!this.myCanHideWarnings) {
            return false;
        }
        ErrorTreeViewConfiguration config = ErrorTreeViewConfiguration.getInstance(this.myProject);
        return config.isHideWarnings() || config.isHideInfoMessages();
    }

    private boolean shouldHide(ErrorTreeElementKind kind) {
        if (!this.myCanHideWarnings) {
            return false;
        }
        return switch (kind) {
            case ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE -> ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings();
            case ErrorTreeElementKind.INFO -> ErrorTreeViewConfiguration.getInstance(this.myProject).isHideInfoMessages();
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShowFileElement(GroupingElement groupingElement) {
        if (!this.isFilteringNeeded()) {
            return this.getChildCount(groupingElement) > 0;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            if (children2 != null) {
                for (NavigatableMessageElement child : children2) {
                    if (this.shouldHide(child.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(8);
        }
        if (element instanceof GroupingElement || element instanceof SimpleMessageElement) {
            return this.myRoot;
        }
        if (element instanceof NavigatableMessageElement) {
            GroupingElement result2 = ((NavigatableMessageElement)element).getParent();
            return result2 == null ? this.myRoot : result2;
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(9);
        }
        return new ErrorTreeNodeDescriptor(this.myProject, parentDescriptor, (ErrorTreeElement)element);
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public ErrorTreeElement addMessage(@NotNull ErrorTreeElementKind kind, String @NotNull [] text2, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            ErrorViewStructure.$$$reportNull$$$0(11);
        }
        if (underFileGroup == null && file2 == null) {
            return this.addSimpleMessageElement(new SimpleMessageElement(kind, text2, data2));
        }
        if (file2 == null) {
            line = -1;
            column = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int guiColumn = column < 0 ? -1 : column + 1;
        VirtualFile group2 = underFileGroup == null ? file2 : underFileGroup;
        VirtualFile nav = file2 == null ? underFileGroup : file2;
        return this.addNavigatableMessage(group2.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text2, data2, NewErrorTreeViewPanel.createExportPrefix(guiLine), NewErrorTreeViewPanel.createRendererPrefix(guiLine, guiColumn), group2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getGroupChildrenData(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupName);
            if (children2 == null || children2.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (NavigatableMessageElement child : children2) {
                Object data2 = child.getData();
                if (data2 == null) continue;
                result2.add(data2);
            }
            return result2;
        }
    }

    public void addFixedHotfixGroup(String text2, List<? extends SimpleErrorData> children2) {
        FixedHotfixGroupElement group2 = new FixedHotfixGroupElement(text2, null, null);
        this.addGroupPlusElements(text2, group2, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<? extends SimpleErrorData> children2, MutableErrorTreeView view2) {
        String text2 = hotfixData.getErrorText();
        HotfixGroupElement group2 = new HotfixGroupElement(text2, null, null, (Consumer<? super HotfixGate>)hotfixData.getFix(), hotfixData.getFixComment(), view2);
        this.addGroupPlusElements(text2, group2, children2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupPlusElements(String text2, GroupingElement group2, List<? extends SimpleErrorData> children2) {
        ArrayList<MyNavigatableWithDataElement> elements = new ArrayList<MyNavigatableWithDataElement>();
        for (SimpleErrorData simpleErrorData : children2) {
            elements.add(new MyNavigatableWithDataElement(this.myProject, simpleErrorData.getKind(), group2, simpleErrorData.getMessages(), simpleErrorData.getVf(), NewErrorTreeViewPanel.createExportPrefix(-1), NewErrorTreeViewPanel.createRendererPrefix(-1, -1)));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.add(text2);
            this.myGroupNameToElementMap.put(text2, group2);
            this.myGroupNameToMessagesMap.put(text2, elements);
        }
    }

    public ErrorTreeElement addMessage(@NotNull ErrorTreeElementKind kind, String[] text2, Object data2) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(12);
        }
        return this.addSimpleMessage(kind, text2, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<NavigatableMessageElement> removeNavigatableMessage(@NotNull String groupName, @NotNull ErrorTreeElementKind kind, @NotNull Navigatable navigatable) {
        if (groupName == null) {
            ErrorViewStructure.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(14);
        }
        if (navigatable == null) {
            ErrorViewStructure.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
        if (elements == null) {
            List<NavigatableMessageElement> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            ErrorViewStructure.$$$reportNull$$$0(16);
            return list2;
        }
        int i2 = 0;
        ArrayList<NavigatableMessageElement> removed = new ArrayList<NavigatableMessageElement>();
        while (true) {
            if (i2 >= elements.size()) {
                ArrayList<NavigatableMessageElement> arrayList = removed;
                // MONITOREXIT : object
                if (arrayList != null) return arrayList;
                ErrorViewStructure.$$$reportNull$$$0(17);
                return arrayList;
            }
            NavigatableMessageElement element = elements.get(i2);
            if (element.getNavigatable() == navigatable && element.getKind() == kind) {
                removed.add(element);
                elements.remove(i2);
                continue;
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<NavigatableMessageElement> removeAllNavigatableMessagesInGroup(@NotNull String groupName) {
        if (groupName == null) {
            ErrorViewStructure.$$$reportNull$$$0(18);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
        if (elements == null) {
            List<NavigatableMessageElement> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            ErrorViewStructure.$$$reportNull$$$0(19);
            return list2;
        }
        ArrayList<NavigatableMessageElement> removed = new ArrayList<NavigatableMessageElement>(elements);
        elements.clear();
        ArrayList<NavigatableMessageElement> arrayList = removed;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        ErrorViewStructure.$$$reportNull$$$0(20);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement addNavigatableMessage(@Nullable String groupName, Navigatable navigatable, @NotNull ErrorTreeElementKind kind, String[] message, Object data2, String exportText, String rendererTextPrefix, VirtualFile file2) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(21);
        }
        if (groupName == null) {
            return this.addSimpleMessageElement(new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
            if (elements == null) {
                elements = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements);
            }
            NavigatableMessageElement element = new NavigatableMessageElement(kind, this.getGroupingElement(groupName, data2, file2), message, navigatable, exportText, rendererTextPrefix);
            elements.add(element);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@NotNull String groupName, @NotNull NavigatableMessageElement navigatableMessageElement) {
        if (groupName == null) {
            ErrorViewStructure.$$$reportNull$$$0(22);
        }
        if (navigatableMessageElement == null) {
            ErrorViewStructure.$$$reportNull$$$0(23);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
            if (elements == null) {
                elements = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements);
            }
            if (!this.myGroupNameToElementMap.containsKey(groupName)) {
                this.myGroupNames.add(groupName);
                this.myGroupNameToElementMap.put(groupName, navigatableMessageElement.getParent());
            }
            elements.add(navigatableMessageElement);
        }
    }

    private ErrorTreeElement addSimpleMessage(@NotNull ErrorTreeElementKind kind, String[] text2, Object data2) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(24);
        }
        return this.addSimpleMessageElement(new SimpleMessageElement(kind, text2, data2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement addSimpleMessageElement(ErrorTreeElement element) {
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> elements = this.mySimpleMessages.get(element.getKind());
            if (elements == null) {
                elements = new ArrayList<ErrorTreeElement>();
                this.mySimpleMessages.put(element.getKind(), elements);
            }
            elements.add(element);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GroupingElement lookupGroupingElement(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGroupNameToElementMap.get(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupingElement getGroupingElement(String groupName, Object data2, VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            GroupingElement element = this.myGroupNameToElementMap.get(groupName);
            if (element != null) {
                return element;
            }
            element = this.createGroupingElement(groupName, data2, file2);
            this.myGroupNames.add(groupName);
            this.myGroupNameToElementMap.put(groupName, element);
            return element;
        }
    }

    @NotNull
    protected GroupingElement createGroupingElement(String groupName, Object data2, VirtualFile file2) {
        return new GroupingElement(groupName, data2, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(GroupingElement groupingElement) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            return children2 == null ? 0 : children2.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.clear();
            this.myGroupNameToElementMap.clear();
            this.myGroupNameToMessagesMap.clear();
            this.mySimpleMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(25);
        }
        if (this.shouldHide(kind)) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> simpleMessages = this.mySimpleMessages.get(kind);
            if (simpleMessages != null && !simpleMessages.isEmpty()) {
                return simpleMessages.get(0);
            }
            for (String path : this.myGroupNames) {
                List<NavigatableMessageElement> messages = this.myGroupNameToMessagesMap.get(path);
                if (messages == null) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kind.equals((Object)navigatableMessageElement.getKind())) continue;
                    return navigatableMessageElement;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.remove(name2);
            this.myGroupNameToElementMap.remove(name2);
            this.myGroupNameToMessagesMap.remove(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ErrorTreeElement element) {
        if (element == this.myRoot) {
            return;
        }
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            this.removeGroup(groupingElement.getName());
            VirtualFile virtualFile2 = groupingElement.getFile();
            if (virtualFile2 != null) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiFile psiFile;
                    PsiFile psiFile2 = psiFile = virtualFile2.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(virtualFile2) : null;
                    if (psiFile != null) {
                        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile, (Object)this);
                    }
                });
            }
        } else if (element instanceof NavigatableMessageElement) {
            NavigatableMessageElement navElement = (NavigatableMessageElement)element;
            GroupingElement parent = navElement.getParent();
            if (parent != null) {
                Object object = this.myLock;
                synchronized (object) {
                    List<NavigatableMessageElement> groupMessages = this.myGroupNameToMessagesMap.get(parent.getName());
                    if (groupMessages != null) {
                        groupMessages.remove(navElement);
                    }
                }
            }
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<ErrorTreeElement> simples = this.mySimpleMessages.get(element.getKind());
                if (simples != null) {
                    simples.remove(element);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 8, 9, 10, 11, 12, 13, 14, 15, 18, 21, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/errorTreeView/ErrorViewStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatableMessageElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/errorTreeView/ErrorViewStructure";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNavigatableMessage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllNavigatableMessagesInGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasMessages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeNavigatableMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeAllNavigatableMessagesInGroup";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addNavigatableMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 8, 9, 10, 11, 12, 13, 14, 15, 18, 21, 22, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyRootElement
    extends ErrorTreeElement {
        private MyRootElement() {
        }

        @Override
        public String[] getText() {
            return null;
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public String getExportTextPrefix() {
            return "";
        }
    }

    private static final class MyNavigatableWithDataElement
    extends NavigatableMessageElement {
        private final VirtualFile myVf;
        private final CustomizeColoredTreeCellRenderer myCustomizeColoredTreeCellRenderer;

        private MyNavigatableWithDataElement(Project project2, @NotNull ErrorTreeElementKind kind, GroupingElement parent, String[] message, final @NotNull VirtualFile vf, String exportText, String rendererTextPrefix) {
            if (kind == null) {
                MyNavigatableWithDataElement.$$$reportNull$$$0(0);
            }
            if (vf == null) {
                MyNavigatableWithDataElement.$$$reportNull$$$0(1);
            }
            super(kind, parent, message, (Navigatable)new OpenFileDescriptor(project2, vf, -1, -1), exportText, rendererTextPrefix);
            this.myVf = vf;
            this.myCustomizeColoredTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer2, JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                    Icon icon2 = myVf.getFileType().getIcon();
                    renderer2.setIcon(icon2);
                    String[] messages = this.getText();
                    String text2 = messages == null || messages.length == 0 ? vf.getPresentableUrl() : messages[0];
                    renderer2.append(text2);
                }
            };
        }

        @Override
        public Object getData() {
            return this.myVf;
        }

        @Override
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myCustomizeColoredTreeCellRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vf";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/errorTreeView/ErrorViewStructure$MyNavigatableWithDataElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

