/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ui.TargetUIType;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.LafEntry;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoImpl;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoKt;
import com.intellij.ide.ui.laf.UiThemeProviderListManagerKt;
import com.intellij.ide.ui.laf.UiThemeRemapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0017J\u001a\u0010\u0018\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u000eJ\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u001f\u001a\u00020 J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0017\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b*J\u0012\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ide/ui/laf/UiThemeProviderListManager;", "", "<init>", "()V", "themeDescriptors", "", "Lcom/intellij/ide/ui/laf/LafEntry;", "getLaFs", "Lkotlin/sequences/Sequence;", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfo;", "getLaFListSize", "", "findThemeByName", "name", "", "findThemeById", "id", "findThemeBeanHolderById", "Lcom/intellij/ide/ui/UITheme;", "findDefaultParent", "isDark", "", "themeId", "findDefaultParent$intellij_platform_ide_impl", "findThemeSupplierById", "Ljava/util/function/Supplier;", "getDescriptors", "getDescriptors$intellij_platform_ide_impl", "getThemeJson", "", "getThemeListForTargetUI", "targetUI", "Lcom/intellij/ide/ui/TargetUIType;", "getBundledThemeListForTargetUI", "themeProviderAdded", "provider", "Lcom/intellij/ide/ui/UIThemeProvider;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "themeProviderAdded$intellij_platform_ide_impl", "themeProviderRemoved", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfoImpl;", "themeProviderRemoved$intellij_platform_ide_impl", "findLaFById", "findLaFByProviderId", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUiThemeProviderListManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemeProviderListManager.kt\ncom/intellij/ide/ui/laf/UiThemeProviderListManager\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n9#2,4:184\n184#3,2:188\n1342#3,2:190\n1#4:192\n629#5,12:193\n629#5,12:205\n296#5,2:217\n*S KotlinDebug\n*F\n+ 1 UiThemeProviderListManager.kt\ncom/intellij/ide/ui/laf/UiThemeProviderListManager\n*L\n32#1:184,4\n77#1:188,2\n120#1:190,2\n136#1:193,12\n137#1:205,12\n154#1:217,2\n*E\n"})
public final class UiThemeProviderListManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile List<LafEntry> themeDescriptors;
    @NotNull
    public static final String DEFAULT_DARK_PARENT_THEME = "Darcula";
    @NotNull
    public static final String DEFAULT_LIGHT_PARENT_THEME = "IntelliJ";

    public UiThemeProviderListManager() {
        String name$iv = "compute LaF list";
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)name$iv) : null;
        UiThemeProviderListManager uiThemeProviderListManager = this;
        boolean bl = false;
        List result$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)UIThemeProvider.EP_NAME.filterableLazySequence(), arg_0 -> UiThemeProviderListManager.lambda$0$0(this, arg_0)));
        Activity activity = activity$iv;
        if (activity != null) {
            activity.end();
        }
        List list2 = List.copyOf(result$iv);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        uiThemeProviderListManager.themeDescriptors = list2;
    }

    @NotNull
    public final Sequence<UIThemeLookAndFeelInfo> getLaFs() {
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), UiThemeProviderListManager::getLaFs$lambda$0);
    }

    public final int getLaFListSize() {
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        return list2.size();
    }

    @Nullable
    public final UIThemeLookAndFeelInfo findThemeByName(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Sequence<UIThemeLookAndFeelInfo> $this$firstOrNull$iv = this.getLaFs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UIThemeLookAndFeelInfo it = (UIThemeLookAndFeelInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final UIThemeLookAndFeelInfo findThemeById(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Supplier<? extends UIThemeLookAndFeelInfo> supplier = this.findThemeSupplierById(id2);
        return supplier != null ? supplier.get() : null;
    }

    private final UITheme findThemeBeanHolderById(String id2) {
        Object object = this.findLaFById(id2);
        return object != null && (object = ((LafEntry)object).theme) != null && (object = (UIThemeLookAndFeelInfoImpl)object.get()) != null ? ((UIThemeLookAndFeelInfoImpl)object).getTheme() : null;
    }

    @Nullable
    public final UITheme findDefaultParent$intellij_platform_ide_impl(boolean isDark, @NotNull String themeId) {
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        if (isDark) {
            if (!Intrinsics.areEqual((Object)themeId, (Object)DEFAULT_DARK_PARENT_THEME)) {
                return this.findThemeBeanHolderById(DEFAULT_DARK_PARENT_THEME);
            }
        } else if (!Intrinsics.areEqual((Object)themeId, (Object)DEFAULT_LIGHT_PARENT_THEME)) {
            return this.findThemeBeanHolderById(DEFAULT_LIGHT_PARENT_THEME);
        }
        return null;
    }

    @Nullable
    public final Supplier<? extends UIThemeLookAndFeelInfo> findThemeSupplierById(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        LafEntry lafEntry = this.findLaFById(id2);
        return lafEntry != null ? lafEntry.theme : null;
    }

    @NotNull
    public final List<LafEntry> getDescriptors$intellij_platform_ide_impl() {
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        return list2;
    }

    @Nullable
    public final byte[] getThemeJson(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        LafEntry lafEntry = this.findLaFById(id2);
        if (lafEntry == null) {
            return null;
        }
        LafEntry entry = lafEntry;
        return entry.bean.getThemeJson(entry.pluginDescriptor);
    }

    @NotNull
    public final Sequence<UIThemeLookAndFeelInfo> getThemeListForTargetUI(@NotNull TargetUIType targetUI) {
        Intrinsics.checkNotNullParameter((Object)targetUI, (String)"targetUI");
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), arg_0 -> UiThemeProviderListManager.getThemeListForTargetUI$lambda$0(targetUI, arg_0)), UiThemeProviderListManager::getThemeListForTargetUI$lambda$1);
    }

    @NotNull
    public final List<UIThemeLookAndFeelInfo> getBundledThemeListForTargetUI(@NotNull TargetUIType targetUI) {
        Intrinsics.checkNotNullParameter((Object)targetUI, (String)"targetUI");
        List themes = new ArrayList();
        Sequence<UIThemeLookAndFeelInfo> $this$forEach$iv = this.getThemeListForTargetUI(targetUI);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIThemeLookAndFeelInfo info = (UIThemeLookAndFeelInfo)element$iv;
            boolean bl = false;
            if (UIThemeLookAndFeelInfoKt.isThemeFromPlugin((UIThemeLookAndFeelInfo)info)) continue;
            themes.add(info);
        }
        return themes;
    }

    @Nullable
    public final LafEntry themeProviderAdded$intellij_platform_ide_impl(@NotNull UIThemeProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (this.findLaFByProviderId(provider) != null) {
            return null;
        }
        LafEntry lafEntry = new LafEntry((Supplier)new SynchronizedClearableLazy(() -> UiThemeProviderListManager.themeProviderAdded$lambda$0(this, provider, pluginDescriptor)), provider, pluginDescriptor);
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        this.themeDescriptors = CollectionsKt.plus((Collection)list2, (Object)lafEntry);
        return lafEntry;
    }

    @Nullable
    public final UIThemeLookAndFeelInfoImpl themeProviderRemoved$intellij_platform_ide_impl(@NotNull UIThemeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        LafEntry lafEntry = this.findLaFByProviderId(provider);
        if (lafEntry == null) {
            return null;
        }
        LafEntry oldLaF = lafEntry;
        List<LafEntry> list2 = this.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        this.themeDescriptors = CollectionsKt.minus((Iterable)list2, (Object)oldLaF);
        return oldLaF.theme.get();
    }

    private final LafEntry findLaFById(String id2) {
        LafEntry lafEntry;
        block4: {
            LafEntry entry;
            LafEntry lafEntry2 = entry = UiThemeProviderListManager.findLaFById$lookUp(this, id2);
            if (lafEntry2 != null) {
                return lafEntry2;
            }
            for (LazyExtension it : UiThemeRemapper.EP_NAME.filterableLazySequence()) {
                LafEntry lafEntry3;
                LafEntry lafEntry4;
                String remappedId;
                boolean bl = false;
                UiThemeRemapper uiThemeRemapper = (UiThemeRemapper)it.getInstance();
                String string = remappedId = uiThemeRemapper != null ? uiThemeRemapper.mapLaFId(id2) : null;
                if (remappedId != null) {
                    String p0;
                    boolean bl2 = false;
                    lafEntry4 = UiThemeProviderListManager.findLaFById$lookUp(this, p0);
                } else {
                    lafEntry4 = null;
                }
                if ((lafEntry3 = lafEntry4) == null) continue;
                lafEntry = lafEntry3;
                break block4;
            }
            lafEntry = null;
        }
        return lafEntry;
    }

    private final LafEntry findLaFByProviderId(UIThemeProvider provider) {
        LafEntry lafEntry;
        String string = provider.id;
        if (string != null) {
            String it = string;
            boolean bl = false;
            lafEntry = this.findLaFById(it);
        } else {
            lafEntry = null;
        }
        return lafEntry;
    }

    private static final UITheme lambda$0$0$0$0(UiThemeProviderListManager this$0) {
        return this$0.findThemeBeanHolderById(DEFAULT_DARK_PARENT_THEME);
    }

    private static final UITheme lambda$0$0$0$1(UiThemeProviderListManager this$0) {
        return this$0.findThemeBeanHolderById(DEFAULT_LIGHT_PARENT_THEME);
    }

    private static final UIThemeLookAndFeelInfoImpl lambda$0$0$0(UIThemeProvider $provider, LazyExtension $item, UiThemeProviderListManager this$0) {
        UIThemeLookAndFeelInfoImpl uIThemeLookAndFeelInfoImpl;
        UITheme theme;
        UITheme uITheme;
        String string = $provider.id;
        if (Intrinsics.areEqual((Object)string, (Object)DEFAULT_DARK_PARENT_THEME)) {
            uITheme = $provider.createTheme$intellij_platform_ide_impl(null, null, null, $item.getPluginDescriptor());
        } else if (Intrinsics.areEqual((Object)string, (Object)DEFAULT_LIGHT_PARENT_THEME)) {
            uITheme = $provider.createTheme$intellij_platform_ide_impl(this$0.findThemeBeanHolderById(DEFAULT_DARK_PARENT_THEME), null, null, $item.getPluginDescriptor());
        } else {
            List<LafEntry> list2 = this$0.themeDescriptors;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
                list2 = null;
            }
            UITheme parentTheme = UiThemeProviderListManagerKt.access$findParentTheme(list2, $provider.parentTheme);
            uITheme = $provider.createTheme$intellij_platform_ide_impl(parentTheme, (Function0<UITheme>)((Function0)() -> UiThemeProviderListManager.lambda$0$0$0$0(this$0)), (Function0<UITheme>)((Function0)() -> UiThemeProviderListManager.lambda$0$0$0$1(this$0)), $item.getPluginDescriptor());
        }
        UITheme uITheme2 = theme = uITheme;
        if (uITheme2 != null) {
            UIThemeLookAndFeelInfoImpl uIThemeLookAndFeelInfoImpl2;
            UITheme it = uITheme2;
            boolean bl = false;
            UIThemeLookAndFeelInfoImpl it2 = uIThemeLookAndFeelInfoImpl2 = new UIThemeLookAndFeelInfoImpl(it);
            boolean bl2 = false;
            it2.setRestartRequired($provider.isRestartRequired);
            uIThemeLookAndFeelInfoImpl = uIThemeLookAndFeelInfoImpl2;
        } else {
            uIThemeLookAndFeelInfoImpl = null;
        }
        return uIThemeLookAndFeelInfoImpl;
    }

    private static final LafEntry lambda$0$0(UiThemeProviderListManager this$0, LazyExtension item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        UIThemeProvider uIThemeProvider = (UIThemeProvider)item.getInstance();
        if (uIThemeProvider == null) {
            return null;
        }
        UIThemeProvider provider = uIThemeProvider;
        SynchronizedClearableLazy supplier = new SynchronizedClearableLazy(() -> UiThemeProviderListManager.lambda$0$0$0(provider, item, this$0));
        return new LafEntry((Supplier)supplier, provider, item.getPluginDescriptor());
    }

    private static final UIThemeLookAndFeelInfoImpl getLaFs$lambda$0(LafEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.theme.get();
    }

    private static final boolean getThemeListForTargetUI$lambda$0(TargetUIType $targetUI, LafEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTargetUiType() == $targetUI;
    }

    private static final UIThemeLookAndFeelInfoImpl getThemeListForTargetUI$lambda$1(LafEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.theme.get();
    }

    /*
     * WARNING - void declaration
     */
    private static final UITheme themeProviderAdded$lambda$0$0(UiThemeProviderListManager this$0) {
        void var3_3;
        List<LafEntry> list2 = this$0.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        Iterable $this$single$iv = list2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            LafEntry it = (LafEntry)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)DEFAULT_DARK_PARENT_THEME)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        UIThemeLookAndFeelInfoImpl uIThemeLookAndFeelInfoImpl = ((LafEntry)var3_3).theme.get();
        return uIThemeLookAndFeelInfoImpl != null ? uIThemeLookAndFeelInfoImpl.getTheme() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final UITheme themeProviderAdded$lambda$0$1(UiThemeProviderListManager this$0) {
        void var3_3;
        List<LafEntry> list2 = this$0.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        Iterable $this$single$iv = list2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            LafEntry it = (LafEntry)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)DEFAULT_LIGHT_PARENT_THEME)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        UIThemeLookAndFeelInfoImpl uIThemeLookAndFeelInfoImpl = ((LafEntry)var3_3).theme.get();
        return uIThemeLookAndFeelInfoImpl != null ? uIThemeLookAndFeelInfoImpl.getTheme() : null;
    }

    private static final UIThemeLookAndFeelInfoImpl themeProviderAdded$lambda$0(UiThemeProviderListManager this$0, UIThemeProvider $provider, PluginDescriptor $pluginDescriptor) {
        UIThemeLookAndFeelInfoImpl uIThemeLookAndFeelInfoImpl;
        List<LafEntry> list2 = this$0.themeDescriptors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
            list2 = null;
        }
        UITheme parentTheme = UiThemeProviderListManagerKt.access$findParentTheme(list2, $provider.parentTheme);
        UITheme uITheme = $provider.createTheme$intellij_platform_ide_impl(parentTheme, (Function0<UITheme>)((Function0)() -> UiThemeProviderListManager.themeProviderAdded$lambda$0$0(this$0)), (Function0<UITheme>)((Function0)() -> UiThemeProviderListManager.themeProviderAdded$lambda$0$1(this$0)), $pluginDescriptor);
        if (uITheme == null) {
            return null;
        }
        UITheme theme = uITheme;
        UIThemeLookAndFeelInfoImpl it = uIThemeLookAndFeelInfoImpl = new UIThemeLookAndFeelInfoImpl(theme);
        boolean bl = false;
        it.setRestartRequired($provider.isRestartRequired);
        return uIThemeLookAndFeelInfoImpl;
    }

    private static final LafEntry findLaFById$lookUp(UiThemeProviderListManager this$0, String id2) {
        Object v1;
        block2: {
            List<LafEntry> list2 = this$0.themeDescriptors;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"themeDescriptors");
                list2 = null;
            }
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LafEntry it = (LafEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/ui/laf/UiThemeProviderListManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/ui/laf/UiThemeProviderListManager;", "DEFAULT_DARK_PARENT_THEME", "", "DEFAULT_LIGHT_PARENT_THEME", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nUiThemeProviderListManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemeProviderListManager.kt\ncom/intellij/ide/ui/laf/UiThemeProviderListManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,183:1\n42#2,3:184\n*S KotlinDebug\n*F\n+ 1 UiThemeProviderListManager.kt\ncom/intellij/ide/ui/laf/UiThemeProviderListManager$Companion\n*L\n22#1:184,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UiThemeProviderListManager getInstance() {
            boolean $i$f$service = false;
            Class<UiThemeProviderListManager> serviceClass$iv = UiThemeProviderListManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (UiThemeProviderListManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

