/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionButtonLook {
    public static final ActionButtonLook SYSTEM_LOOK = new ActionButtonLook(){
        private ActionButtonLook delegate;
        {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.delegate = new IdeaActionButtonLook();
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, int state2) {
            this.delegate.paintBackground(g, component2, state2);
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
            this.delegate.paintBackground(g, component2, color);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state2) {
            this.delegate.paintBorder(g, component2, state2);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
            this.delegate.paintBorder(g, component2, color);
        }

        @Override
        public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            if (g == null) {
                1.$$$reportNull$$$0(0);
            }
            if (rect == null) {
                1.$$$reportNull$$$0(1);
            }
            if (color == null) {
                1.$$$reportNull$$$0(2);
            }
            this.delegate.paintLookBackground(g, rect, color);
        }

        @Override
        public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            if (g == null) {
                1.$$$reportNull$$$0(3);
            }
            if (rect == null) {
                1.$$$reportNull$$$0(4);
            }
            if (color == null) {
                1.$$$reportNull$$$0(5);
            }
            this.delegate.paintLookBorder(g, rect, color);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rect";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionButtonLook$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintLookBackground";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintLookBorder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final ActionButtonLook INPLACE_LOOK = new ActionButtonLook(){

        @Override
        public void paintBackground(Graphics g, JComponent component2, int state2) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state2) {
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
        }
    };

    public <ButtonType extends JComponent> void paintBackground(Graphics g, ButtonType button2) {
        this.paintBackground(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public <ButtonType extends JComponent> void paintBorder(Graphics g, ButtonType button2) {
        this.paintBorder(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public void paintBackground(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state2) {
        Color color = this.getStateBackground(component2, state2);
        if (color == null) {
            return;
        }
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        this.paintLookBackground(g, rect, color);
    }

    @Nullable
    protected Color getStateBackground(JComponent component2, int state2) {
        return state2 == 0 ? (component2.isBackgroundSet() ? component2.getBackground() : null) : (state2 == -1 ? JBUI.CurrentTheme.ActionButton.pressedBackground() : JBUI.CurrentTheme.ActionButton.hoverBackground());
    }

    public void paintBackground(Graphics g, JComponent component2, Color color) {
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        this.paintLookBackground(g, rect, color);
    }

    public void paintBorder(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state2) {
        if (state2 == 0 && !component2.isBackgroundSet()) {
            return;
        }
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        Color color = state2 == -1 ? JBUI.CurrentTheme.ActionButton.pressedBorder() : JBUI.CurrentTheme.ActionButton.hoverBorder();
        this.paintLookBorder(g, rect, color);
    }

    public void paintBorder(Graphics g, JComponent component2, Color color) {
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        this.paintLookBorder(g, rect, color);
    }

    public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
        if (g == null) {
            ActionButtonLook.$$$reportNull$$$0(0);
        }
        if (rect == null) {
            ActionButtonLook.$$$reportNull$$$0(1);
        }
        if (color == null) {
            ActionButtonLook.$$$reportNull$$$0(2);
        }
    }

    public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
        if (g == null) {
            ActionButtonLook.$$$reportNull$$$0(3);
        }
        if (rect == null) {
            ActionButtonLook.$$$reportNull$$$0(4);
        }
        if (color == null) {
            ActionButtonLook.$$$reportNull$$$0(5);
        }
    }

    public void updateUI() {
    }

    @ActionButtonComponent.ButtonState
    protected int getState(ActionButtonComponent button2) {
        return button2.getPopState();
    }

    @NotNull
    public Icon getDisabledIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            ActionButtonLook.$$$reportNull$$$0(6);
        }
        Icon icon3 = IconLoader.getDisabledIcon((Icon)icon2);
        if (icon3 == null) {
            ActionButtonLook.$$$reportNull$$$0(7);
        }
        return icon3;
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2) {
        Point iconPos = this.getIconPosition(actionButton, icon2);
        this.paintIcon(g, actionButton, icon2, iconPos.x, iconPos.y);
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2, int x, int y) {
        ActionButtonLook.paintIconImpl(g, actionButton, icon2, x, y);
    }

    @ApiStatus.Internal
    protected static void paintIconImpl(Graphics g, ActionButtonComponent actionButton, Icon icon2, int x, int y) {
        icon2.paintIcon(actionButton instanceof Component ? (Component)actionButton : null, g, x, y);
    }

    public void paintDownArrow(Graphics g, ActionButtonComponent actionButton, Icon originalIcon, Icon arrowIcon) {
        Point iconPos = this.getIconPosition(actionButton, originalIcon);
        int arrowIconX = iconPos.x + 1 + (originalIcon.getIconWidth() - arrowIcon.getIconWidth());
        int arrowIconY = iconPos.y + 1 + (originalIcon.getIconHeight() - arrowIcon.getIconHeight());
        arrowIcon.paintIcon(actionButton instanceof Component ? (Component)actionButton : null, g, arrowIconX, arrowIconY);
    }

    @ActionButtonComponent.ButtonState
    public static int getButtonState(boolean isEnabled, boolean isHovered, boolean isFocused, boolean isPressedByMouse, boolean isPressedByKeyboard) {
        if (!isEnabled) {
            return 0;
        }
        if (isPressedByMouse || isPressedByKeyboard) {
            return -1;
        }
        if (isHovered) {
            return 1;
        }
        if (isFocused) {
            return 2;
        }
        return 0;
    }

    protected Point getIconPosition(ActionButtonComponent actionButton, Icon icon2) {
        Rectangle rect = new Rectangle(actionButton.getWidth(), actionButton.getHeight());
        JBInsets.removeFrom((Rectangle)rect, (Insets)actionButton.getInsets());
        if (actionButton instanceof ActionButton) {
            ActionButton realButton = (ActionButton)actionButton;
            JBInsets.removeFrom((Rectangle)rect, (Insets)realButton.getIconInsets());
        }
        int x = rect.x + (rect.width - icon2.getIconWidth()) / 2;
        int y = rect.y + (rect.height - icon2.getIconHeight()) / 2;
        return new Point(x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ActionButtonLook";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionButtonLook";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintLookBackground";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paintLookBorder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledIcon";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

