/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.CommandId;
import com.intellij.openapi.command.impl.PerformedCommand;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record CommandMergerFlushReason(@NotNull String reason, @Nullable Command currentCommand, @Nullable Command nextCommand) {
    @NotNull
    private final String reason;
    static CommandMergerFlushReason CLEAR_STACKS = CommandMergerFlushReason.create("CLEAR_STACKS");
    static CommandMergerFlushReason CLEAR_QUEUE = CommandMergerFlushReason.create("CLEAR_QUEUE");
    static CommandMergerFlushReason GET_LAST_GROUP = CommandMergerFlushReason.create("GET_LAST_GROUP");
    static CommandMergerFlushReason MANAGER_FORCE = CommandMergerFlushReason.create("MANAGER_FORCE");
    static CommandMergerFlushReason UNDO = CommandMergerFlushReason.create("UNDO");
    static CommandMergerFlushReason REDO = CommandMergerFlushReason.create("REDO");

    CommandMergerFlushReason(@NotNull String reason, @Nullable Command currentCommand, @Nullable Command nextCommand) {
        if (reason == null) {
            CommandMergerFlushReason.$$$reportNull$$$0(0);
        }
    }

    @NotNull
    static CommandMergerFlushReason cannotMergeCommands(@NotNull String reason, @Nullable String currentCommandName, @Nullable Reference<Object> currentGroupId, boolean isCurrentTransparent, boolean isCurrentGlobal, @NotNull PerformedCommand nextCommand) {
        if (reason == null) {
            CommandMergerFlushReason.$$$reportNull$$$0(1);
        }
        if (nextCommand == null) {
            CommandMergerFlushReason.$$$reportNull$$$0(2);
        }
        CommandId nextCommandId = nextCommand.commandId();
        String nextCommandName = nextCommand.commandName();
        Object nextGroupId = nextCommand.groupId();
        boolean isNextTransparent = nextCommand.isTransparent();
        boolean isNextGlobal = nextCommand.isGlobal();
        return new CommandMergerFlushReason(reason, new Command(null, currentCommandName, currentGroupId, isCurrentTransparent, isCurrentGlobal), new Command(nextCommandId, nextCommandName, nextGroupId, isNextTransparent, isNextGlobal));
    }

    @NotNull
    private static CommandMergerFlushReason create(@NotNull String reason) {
        if (reason == null) {
            CommandMergerFlushReason.$$$reportNull$$$0(3);
        }
        return new CommandMergerFlushReason(reason, null, null);
    }

    @Override
    public String toString() {
        if (this.currentCommand == null && this.nextCommand == null) {
            return "Reason{" + this.reason + "}";
        }
        return "Reason{" + this.reason + ", current=" + String.valueOf(this.currentCommand) + ", next=" + String.valueOf(this.nextCommand) + "}";
    }

    @NotNull
    public String reason() {
        String string = this.reason;
        if (string == null) {
            CommandMergerFlushReason.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandMergerFlushReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandMergerFlushReason";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cannotMergeCommands";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private record Command(@Nullable CommandId commandId, @Nullable String commandName, @Nullable Object groupId, boolean isTransparent, boolean isGlobal) {
        @Override
        public String toString() {
            Object object;
            ArrayList<Object> str = new ArrayList<Object>(3);
            str.add(this.commandName == null ? null : "'" + this.commandName + "''");
            Object object2 = this.groupId;
            if (object2 instanceof Reference) {
                Reference ref2 = (Reference)object2;
                object = SoftReference.dereference((Reference)ref2);
            } else {
                object = this.groupId;
            }
            str.add(object);
            if (this.commandId != null) {
                str.add(this.commandId);
            }
            if (this.isTransparent) {
                str.add("transparent");
            }
            if (this.isGlobal) {
                str.add("global");
            }
            return str.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

