/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.impl.ForeignCommandException;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableActionType;
import com.intellij.openapi.command.impl.cmd.CmdEvent;
import com.intellij.openapi.command.impl.cmd.CmdIdService;
import com.intellij.openapi.command.impl.cmd.UndoMeta;
import com.intellij.openapi.command.impl.cmd.UndoableActionMeta;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0004\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0014\u0010\u0015\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\f\u0010\u0017\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/command/impl/ForeignCommandProcessor;", "", "<init>", "()V", "currentCommand", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/command/impl/cmd/CmdEvent;", "tokenToFinish", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "isUndoDisabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "setUndoDisabled", "", "value", "startCommand", "cmdStartEvent", "finishCommand", "cmdFinishEvent", "applyCmdMeta", "startPlatformCommand", "cmdEvent", "startPlatformTransparent", "assertStartAllowed", "assertFinishAllowed", "undoManager", "Lcom/intellij/openapi/command/impl/UndoManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ForeignCommandProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<CmdEvent> currentCommand = new AtomicReference();
    @NotNull
    private final AtomicReference<AutoCloseable> tokenToFinish = new AtomicReference();
    @NotNull
    private final AtomicBoolean isUndoDisabled = new AtomicBoolean();

    public final boolean isUndoDisabled() {
        return this.isUndoDisabled.get();
    }

    public final void setUndoDisabled(boolean value) {
        this.isUndoDisabled.set(value);
    }

    @Nullable
    public final CmdEvent currentCommand() {
        return this.currentCommand.get();
    }

    public final void startCommand(@NotNull CmdEvent cmdStartEvent) {
        Intrinsics.checkNotNullParameter((Object)cmdStartEvent, (String)"cmdStartEvent");
        this.assertStartAllowed(cmdStartEvent);
        CmdIdService.Companion.getInstance().register(cmdStartEvent.id());
        this.currentCommand.set(cmdStartEvent);
        AutoCloseable token = cmdStartEvent.isTransparent() ? this.startPlatformTransparent() : this.startPlatformCommand(cmdStartEvent);
        this.tokenToFinish.set(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishCommand(@NotNull CmdEvent cmdFinishEvent) {
        Intrinsics.checkNotNullParameter((Object)cmdFinishEvent, (String)"cmdFinishEvent");
        this.assertFinishAllowed();
        AutoCloseable token = this.tokenToFinish.getAndSet(null);
        try {
            if (token == null) {
                throw new ForeignCommandException("unexpected state: no command token to finish");
            }
            this.applyCmdMeta(cmdFinishEvent);
            this.currentCommand.set(cmdFinishEvent);
            token.close();
        }
        finally {
            this.currentCommand.set(null);
        }
    }

    private final void applyCmdMeta(CmdEvent cmdFinishEvent) {
        for (UndoMeta undoMeta : cmdFinishEvent.meta().undoMeta()) {
            Project undoProject = undoMeta.undoProject();
            UndoManagerImpl undoManager = this.undoManager(undoProject);
            for (UndoableActionMeta actionMeta : undoMeta.undoableActions()) {
                UndoableAction undoableAction;
                UndoableActionType actionType = actionMeta.type();
                Collection<DocumentReference> affectedDocuments = actionMeta.affectedDocuments();
                boolean isGlobal = actionMeta.isGlobal();
                Intrinsics.checkNotNullExpressionValue((Object)UndoableActionType.getAction(actionType, affectedDocuments, isGlobal), (String)"getAction(...)");
                undoManager.undoableActionPerformed(undoableAction);
            }
            if (!undoMeta.isForcedGlobal()) continue;
            undoManager.markCurrentCommandAsGlobal();
        }
    }

    private final AutoCloseable startPlatformCommand(CmdEvent cmdEvent) {
        CommandProcessorEx commandProcessor = this.commandProcessor();
        CommandToken commandToken = commandProcessor.startCommand(cmdEvent.project(), cmdEvent.name(), cmdEvent.groupId(), cmdEvent.confirmationPolicy());
        if (commandToken == null) {
            this.currentCommand.set(null);
            throw new ForeignCommandException("failed to start foreign command with platform CommandProcessor, probably domestic command is already in progress " + commandProcessor.getCurrentCommand());
        }
        return () -> ForeignCommandProcessor.startPlatformCommand$lambda$0(commandProcessor, commandToken);
    }

    private final AutoCloseable startPlatformTransparent() {
        AutoCloseable autoCloseable = this.commandProcessor().withUndoTransparentAction();
        Intrinsics.checkNotNullExpressionValue((Object)autoCloseable, (String)"withUndoTransparentAction(...)");
        return autoCloseable;
    }

    private final void assertStartAllowed(CmdEvent cmdEvent) {
        ThreadingAssertions.assertEventDispatchThread();
        Project project2 = cmdEvent.project();
        if (project2 != null && project2.isDisposed()) {
            throw new ForeignCommandException("cannot perform command in disposed project: " + project2);
        }
        if (this.currentCommand() != null) {
            throw new ForeignCommandException("cannot perform foreign command during another foreign command " + this.currentCommand());
        }
        CommandProcessorEx commandProcessor = this.commandProcessor();
        if (commandProcessor.isCommandInProgress()) {
            throw new ForeignCommandException("cannot perform foreign command during domestic command " + commandProcessor.getCurrentCommand());
        }
        if (commandProcessor.isUndoTransparentActionInProgress()) {
            throw new ForeignCommandException("cannot perform foreign command during domestic transparent action");
        }
    }

    private final void assertFinishAllowed() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentCommand() == null) {
            throw new ForeignCommandException("cannot finish foreign command without starting it");
        }
    }

    private final UndoManagerImpl undoManager(Project project2) {
        UndoManager undoManager = project2 == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        return (UndoManagerImpl)undoManager;
    }

    private final CommandProcessorEx commandProcessor() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Intrinsics.checkNotNull((Object)commandProcessor, (String)"null cannot be cast to non-null type com.intellij.openapi.command.CommandProcessorEx");
        return (CommandProcessorEx)commandProcessor;
    }

    private static final void startPlatformCommand$lambda$0(CommandProcessorEx $commandProcessor, CommandToken $commandToken) {
        $commandProcessor.finishCommand($commandToken, null);
    }

    @JvmStatic
    @NotNull
    public static final ForeignCommandProcessor getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/command/impl/ForeignCommandProcessor$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/command/impl/ForeignCommandProcessor;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nForeignCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForeignCommandProcessor.kt\ncom/intellij/openapi/command/impl/ForeignCommandProcessor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,154:1\n30#2,2:155\n*S KotlinDebug\n*F\n+ 1 ForeignCommandProcessor.kt\ncom/intellij/openapi/command/impl/ForeignCommandProcessor$Companion\n*L\n148#1:155,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ForeignCommandProcessor getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<ForeignCommandProcessor> serviceClass$iv = ForeignCommandProcessor.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ForeignCommandProcessor)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

