/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VfsThreadingUtil;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AsyncEventSupport {
    private static final Logger LOG = Logger.getInstance(AsyncEventSupport.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<AsyncFileListener> EP_NAME = new ExtensionPointName("com.intellij.vfs.asyncListener");
    @ApiStatus.Internal
    public static final ExtensionPointName<AsyncFileListener> EP_NAME_BACKGROUNDABLE = new ExtensionPointName("com.intellij.vfs.asyncListenerBackgroundable");
    @NotNull
    private static final Set<List<? extends VFileEvent>> asyncProcessedEvents = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)HashingStrategy.identity());
    @NotNull
    private static final Map<List<? extends VFileEvent>, List<AsyncFileListener.ChangeApplier>> appliers = CollectionFactory.createSmallMemoryFootprintMap((int)1);

    public static void startListening() {
        Application app = ApplicationManager.getApplication();
        Disposer.register((Disposable)app, AsyncEventSupport::ensureAllEventsProcessed);
        app.getMessageBus().simpleConnect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (asyncProcessedEvents.contains(events)) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
                AsyncEventSupport.appliers.put(events, appliers);
                AsyncEventSupport.beforeVfsChange(appliers);
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (asyncProcessedEvents.contains(events)) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.appliers.remove(events);
                if (appliers == null || appliers.isEmpty()) {
                    return;
                }
                AsyncEventSupport.afterVfsChange(appliers);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void ensureAllEventsProcessed() {
        LOG.assertTrue(asyncProcessedEvents.isEmpty(), (Object)("Some VFS events were not properly processed " + String.valueOf(asyncProcessedEvents)));
        LOG.assertTrue(appliers.isEmpty(), (Object)("Some VFS events were not processed after VFS change performed " + String.valueOf(appliers)));
    }

    @NotNull
    static List<AsyncFileListener.ChangeApplier> runAsyncListeners(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(0);
        }
        if (events.isEmpty()) {
            List<AsyncFileListener.ChangeApplier> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncEventSupport.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing " + String.valueOf(events));
        }
        final ArrayList<AsyncFileListener.ChangeApplier> appliers = new ArrayList<AsyncFileListener.ChangeApplier>();
        ArrayList<AsyncFileListener.ChangeApplier> appliersBackgroundable = new ArrayList<AsyncFileListener.ChangeApplier>();
        List allListeners = ((VirtualFileManagerImpl)VirtualFileManager.getInstance()).withAsyncFileListeners(EP_NAME.getExtensionList());
        List allListenersBackgroundable = ((VirtualFileManagerImpl)VirtualFileManager.getInstance()).withAsyncFileListenersBackgroundable(EP_NAME_BACKGROUNDABLE.getExtensionList());
        AsyncEventSupport.collectAppliers(events, allListeners, appliers);
        AsyncEventSupport.collectAppliers(events, allListenersBackgroundable, appliersBackgroundable);
        appliersBackgroundable.add(new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                if (appliers.isEmpty()) {
                    return;
                }
                VfsThreadingUtil.runActionOnEdtRegardlessOfCurrentThread(() -> AsyncEventSupport.invokeAppliers(appliers, AsyncFileListener.ChangeApplier::beforeVfsChange));
            }

            public void afterVfsChange() {
                if (appliers.isEmpty()) {
                    return;
                }
                VfsThreadingUtil.runActionOnEdtRegardlessOfCurrentThread(() -> AsyncEventSupport.invokeAppliers(appliers, AsyncFileListener.ChangeApplier::afterVfsChange));
            }
        });
        ArrayList<AsyncFileListener.ChangeApplier> arrayList = appliersBackgroundable;
        if (arrayList == null) {
            AsyncEventSupport.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    private static void collectAppliers(@NotNull List<? extends VFileEvent> events, List<AsyncFileListener> allListeners, List<AsyncFileListener.ChangeApplier> appliers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void markAsynchronouslyProcessedEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(4);
        }
        asyncProcessedEvents.add(events);
    }

    public static void unmarkAsynchronouslyProcessedEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(asyncProcessedEvents.remove(events));
    }

    private static void beforeVfsChange(@NotNull List<AsyncFileListener.ChangeApplier> appliers) {
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(6);
        }
        AsyncEventSupport.invokeAppliers(appliers, AsyncFileListener.ChangeApplier::beforeVfsChange);
    }

    private static void invokeAppliers(List<AsyncFileListener.ChangeApplier> appliers, Consumer<AsyncFileListener.ChangeApplier> consumer) {
        for (AsyncFileListener.ChangeApplier applier : appliers) {
            PingProgress.interactWithEdtProgress();
            try {
                consumer.accept(applier);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static void afterVfsChange(@NotNull List<AsyncFileListener.ChangeApplier> appliers) {
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(7);
        }
        AsyncEventSupport.invokeAppliers(appliers, AsyncFileListener.ChangeApplier::afterVfsChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    static void processEventsFromRefresh(@NotNull List<CompoundVFileEvent> events, @NotNull List<AsyncFileListener.ChangeApplier> appliers, boolean excludeAsyncListeners) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(8);
        }
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertWriteAccess();
        AsyncEventSupport.beforeVfsChange(appliers);
        try {
            ((PersistentFSImpl)PersistentFS.getInstance()).processEventsImpl(events, excludeAsyncListeners);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error(e);
        }
        finally {
            AsyncEventSupport.afterVfsChange(appliers);
        }
    }

    private static /* synthetic */ void lambda$collectAppliers$0(List appliers, AsyncFileListener listener2, List events) {
        ContainerUtil.addIfNotNull((Collection)appliers, (Object)listener2.prepareChange(events));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncListeners";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAppliers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markAsynchronouslyProcessedEvents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unmarkAsynchronouslyProcessedEvents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeVfsChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterVfsChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processEventsFromRefresh";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

