/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.gdpr.Version;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBAccountInfoServiceHolder;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.time.Instant;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface JBAccountInfoService {
    @Nullable
    public JBAData getUserData();

    @Nullable
    default public String getIdToken() {
        return null;
    }

    default public @NotNull CompletableFuture<@Nullable String> getJbaIdToken() {
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> this.getIdToken(), AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            JBAccountInfoService.$$$reportNull$$$0(0);
        }
        return completableFuture;
    }

    @NotNull
    default public Future<String> getAccessToken() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            JBAccountInfoService.$$$reportNull$$$0(1);
        }
        return completableFuture;
    }

    @Deprecated
    default public void invokeJBALogin(@Nullable Consumer<? super String> userIdConsumer, @Nullable Runnable onFailure) {
        block2: {
            try {
                LoginSession loginSession = this.startLoginSession(LoginMode.AUTO);
                loginSession.onCompleted().thenAccept(result2 -> {
                    if (result2 instanceof LoginResult.LoginSuccessful) {
                        LoginResult.LoginSuccessful $b$0 = (LoginResult.LoginSuccessful)result2;
                        try {
                            JBAData patt1$temp;
                            JBAData user2 = patt1$temp = $b$0.jbaUser();
                            if (userIdConsumer != null) {
                                userIdConsumer.accept(user2.id);
                            }
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    if (!(result2 instanceof LoginResult.LoginFailed)) return;
                    if (onFailure == null) return;
                    onFailure.run();
                });
            }
            catch (Throwable e) {
                Logger.getInstance(JBAccountInfoService.class).error(e);
                if (onFailure == null) break block2;
                onFailure.run();
            }
        }
    }

    @NotNull
    public @NotNull CompletableFuture<@NotNull JbaServiceConfiguration> getServiceConfiguration();

    @NotNull
    default public LoginSession startLoginSession(@NotNull LoginMode loginMode) {
        if (loginMode == null) {
            JBAccountInfoService.$$$reportNull$$$0(2);
        }
        LoginSession loginSession = this.startLoginSession(loginMode, Map.of());
        if (loginSession == null) {
            JBAccountInfoService.$$$reportNull$$$0(3);
        }
        return loginSession;
    }

    @NotNull
    default public LoginSession startLoginSession(@NotNull LoginMode loginMode, @NotNull @NotNull Map<@NotNull String, @NotNull String> clientMetadata) {
        if (loginMode == null) {
            JBAccountInfoService.$$$reportNull$$$0(4);
        }
        if (clientMetadata == null) {
            JBAccountInfoService.$$$reportNull$$$0(5);
        }
        LoginSession loginSession = this.startLoginSession(loginMode, null, clientMetadata);
        if (loginSession == null) {
            JBAccountInfoService.$$$reportNull$$$0(6);
        }
        return loginSession;
    }

    @NotNull
    public LoginSession startLoginSession(@NotNull LoginMode var1, @Nullable String var2, @NotNull @NotNull Map<@NotNull String, @NotNull String> var3);

    @NotNull
    public CompletableFuture<LogoutResult> performLogout();

    @NotNull
    public @NotNull CompletableFuture<@NotNull LicenseListResult> getAvailableLicenses(@NotNull String var1);

    @NotNull
    public @NotNull CompletableFuture<@NotNull LicenseListResult> getLicenses(@NotNull String var1, int var2);

    @NotNull
    public @NotNull CompletableFuture<@NotNull LicenseListResult> issueTrialLicense(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public @NotNull CompletableFuture<@NotNull LicenseListResult> dryRunIssueTrialLicense(@NotNull String var1);

    @NotNull
    public @NotNull CompletableFuture<@NotNull AgreementAcceptanceResult> recordAgreementAcceptance(@NotNull String var1, @NotNull String var2, @NotNull Version var3);

    @Nullable
    public static JBAccountInfoService getInstance() {
        if (AppMode.isRemoteDevHost()) {
            return (JBAccountInfoService)ApplicationManager.getApplication().getService(JBAccountInfoService.class);
        }
        return JBAccountInfoServiceHolder.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBAccountInfoService";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loginMode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJbaIdToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessToken";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBAccountInfoService";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startLoginSession";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startLoginSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static enum LoginMode {
        AUTO,
        MANUAL;

    }

    public static interface LoginSession
    extends AutoCloseable {
        @NotNull
        public @NotNull CompletableFuture<@NotNull LoginResult> onCompleted();

        @Override
        public void close();
    }

    public static sealed interface LoginResult {

        public record LoginFailed(@NlsSafe @NotNull String errorMessage) implements LoginResult
        {
            @NlsSafe
            @NotNull
            private final String errorMessage;

            public LoginFailed(@NlsSafe @NotNull String errorMessage) {
                if (errorMessage == null) {
                    LoginFailed.$$$reportNull$$$0(0);
                }
            }

            @NlsSafe
            @NotNull
            public String errorMessage() {
                String string = this.errorMessage;
                if (string == null) {
                    LoginFailed.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LoginResult$LoginFailed";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LoginResult$LoginFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public record LoginSuccessful(@NotNull JBAData jbaUser) implements LoginResult
        {
            @NotNull
            private final JBAData jbaUser;

            public LoginSuccessful(@NotNull JBAData jbaUser) {
                if (jbaUser == null) {
                    LoginSuccessful.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public JBAData jbaUser() {
                JBAData jBAData = this.jbaUser;
                if (jBAData == null) {
                    LoginSuccessful.$$$reportNull$$$0(1);
                }
                return jBAData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jbaUser";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LoginResult$LoginSuccessful";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LoginResult$LoginSuccessful";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "jbaUser";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static final class JBAData {
        @NotNull
        public final String id;
        @NlsSafe
        @Nullable
        public final String loginName;
        @NlsSafe
        @Nullable
        public final String email;
        @NlsSafe
        @Nullable
        public final String presentableName;

        public JBAData(@NotNull String userId, @Nullable String loginName, @Nullable String email, @Nullable String presentableName) {
            if (userId == null) {
                JBAData.$$$reportNull$$$0(0);
            }
            this.id = userId;
            this.loginName = loginName;
            this.email = email;
            this.presentableName = presentableName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userId", "com/intellij/ui/JBAccountInfoService$JBAData", "<init>"));
        }
    }

    public static interface AuthStateListener
    extends EventListener {
        @NotNull
        public static final Topic<AuthStateListener> TOPIC = new Topic(AuthStateListener.class);

        public void authStateChanged(@Nullable JBAData var1);
    }

    public static enum AuthRequired implements LicenseListResult,
    AgreementAcceptanceResult
    {
        INSTANCE;


        public String toString() {
            return "AuthRequired";
        }
    }

    public static sealed interface AgreementAcceptanceResult
    permits AckAccepted, RequestFailed, AuthRequired {

        public record RequestFailed(@NlsSafe @NotNull String errorMessage) implements AgreementAcceptanceResult
        {
            @NlsSafe
            @NotNull
            private final String errorMessage;

            public RequestFailed(@NlsSafe @NotNull String errorMessage) {
                if (errorMessage == null) {
                    RequestFailed.$$$reportNull$$$0(0);
                }
            }

            @NlsSafe
            @NotNull
            public String errorMessage() {
                String string = this.errorMessage;
                if (string == null) {
                    RequestFailed.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$AgreementAcceptanceResult$RequestFailed";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$AgreementAcceptanceResult$RequestFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public record AckAccepted(@Nullable EndUserAgreement.Document newerDocument) implements AgreementAcceptanceResult
        {
        }
    }

    public static sealed interface LicenseListResult
    permits LicenseList, RequestFailed, RequestDeclined, AuthRequired {

        public record RequestFailed(@NlsSafe @NotNull String errorMessage) implements LicenseListResult
        {
            @NlsSafe
            @NotNull
            private final String errorMessage;

            public RequestFailed(@NlsSafe @NotNull String errorMessage) {
                if (errorMessage == null) {
                    RequestFailed.$$$reportNull$$$0(0);
                }
            }

            @NlsSafe
            @NotNull
            public String errorMessage() {
                String string = this.errorMessage;
                if (string == null) {
                    RequestFailed.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$RequestFailed";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$RequestFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public record RequestDeclined(@NotNull String errorCode, @NlsSafe @NotNull String message) implements LicenseListResult
        {
            @NotNull
            private final String errorCode;
            @NlsSafe
            @NotNull
            private final String message;

            public RequestDeclined(@NotNull String errorCode, @NlsSafe @NotNull String message) {
                if (errorCode == null) {
                    RequestDeclined.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    RequestDeclined.$$$reportNull$$$0(1);
                }
            }

            @NotNull
            public String errorCode() {
                String string = this.errorCode;
                if (string == null) {
                    RequestDeclined.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NlsSafe
            @NotNull
            public String message() {
                String string = this.message;
                if (string == null) {
                    RequestDeclined.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorCode";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$RequestDeclined";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$RequestDeclined";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorCode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "message";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }

        public record LicenseList(@NotNull @NotNull List<@NotNull JbaLicense> licenses) implements LicenseListResult
        {
            @NotNull
            private final @NotNull List<@NotNull JbaLicense> licenses;

            public LicenseList(@NotNull @NotNull List<@NotNull JbaLicense> licenses) {
                if (licenses == null) {
                    LicenseList.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public @NotNull List<@NotNull JbaLicense> licenses() {
                List<JbaLicense> list2 = this.licenses;
                if (list2 == null) {
                    LicenseList.$$$reportNull$$$0(1);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "licenses";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$LicenseList";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LicenseListResult$LicenseList";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "licenses";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static enum LicenseeType {
        UNKNOWN,
        COMPANY,
        INDIVIDUAL,
        STUDENT,
        OPENSOURCE,
        CLASSROOM;

    }

    public static enum LicensePack {
        ALL_PRODUCTS_PACK,
        DOTULTIMATE,
        STUDENT,
        NONE;

    }

    public static enum LicenseKind {
        STANDARD,
        TRIAL,
        FREE;

    }

    public record JbaLicense(@NlsSafe @NotNull String licenseId, @NotNull String jbaUserId, @NotNull LicenseKind licenseKind, @NotNull LicenseeType licenseeType, @NotNull LicensePack licensePack, @NlsSafe @NotNull String licensedTo, @Nullable Instant expiresOn) {
        @NlsSafe
        @NotNull
        private final String licenseId;
        @NotNull
        private final String jbaUserId;
        @NotNull
        private final LicenseKind licenseKind;
        @NotNull
        private final LicenseeType licenseeType;
        @NotNull
        private final LicensePack licensePack;
        @NlsSafe
        @NotNull
        private final String licensedTo;

        public JbaLicense(@NlsSafe @NotNull String licenseId, @NotNull String jbaUserId, @NotNull LicenseKind licenseKind, @NotNull LicenseeType licenseeType, @NotNull LicensePack licensePack, @NlsSafe @NotNull String licensedTo, @Nullable Instant expiresOn) {
            if (licenseId == null) {
                JbaLicense.$$$reportNull$$$0(0);
            }
            if (jbaUserId == null) {
                JbaLicense.$$$reportNull$$$0(1);
            }
            if (licenseKind == null) {
                JbaLicense.$$$reportNull$$$0(2);
            }
            if (licenseeType == null) {
                JbaLicense.$$$reportNull$$$0(3);
            }
            if (licensePack == null) {
                JbaLicense.$$$reportNull$$$0(4);
            }
            if (licensedTo == null) {
                JbaLicense.$$$reportNull$$$0(5);
            }
        }

        @NlsSafe
        @NotNull
        public String licenseId() {
            String string = this.licenseId;
            if (string == null) {
                JbaLicense.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String jbaUserId() {
            String string = this.jbaUserId;
            if (string == null) {
                JbaLicense.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public LicenseKind licenseKind() {
            LicenseKind licenseKind = this.licenseKind;
            if (licenseKind == null) {
                JbaLicense.$$$reportNull$$$0(8);
            }
            return licenseKind;
        }

        @NotNull
        public LicenseeType licenseeType() {
            LicenseeType licenseeType = this.licenseeType;
            if (licenseeType == null) {
                JbaLicense.$$$reportNull$$$0(9);
            }
            return licenseeType;
        }

        @NotNull
        public LicensePack licensePack() {
            LicensePack licensePack = this.licensePack;
            if (licensePack == null) {
                JbaLicense.$$$reportNull$$$0(10);
            }
            return licensePack;
        }

        @NlsSafe
        @NotNull
        public String licensedTo() {
            String string = this.licensedTo;
            if (string == null) {
                JbaLicense.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "licenseId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jbaUserId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "licenseKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "licenseeType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "licensePack";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "licensedTo";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/JBAccountInfoService$JbaLicense";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/JBAccountInfoService$JbaLicense";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "licenseId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jbaUserId";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "licenseKind";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "licenseeType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "licensePack";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "licensedTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static sealed interface LogoutResult {

        public record LogoutFailed(@NlsSafe @NotNull String errorMessage) implements LogoutResult
        {
            @NlsSafe
            @NotNull
            private final String errorMessage;

            public LogoutFailed(@NlsSafe @NotNull String errorMessage) {
                if (errorMessage == null) {
                    LogoutFailed.$$$reportNull$$$0(0);
                }
            }

            @NlsSafe
            @NotNull
            public String errorMessage() {
                String string = this.errorMessage;
                if (string == null) {
                    LogoutFailed.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/JBAccountInfoService$LogoutResult$LogoutFailed";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/JBAccountInfoService$LogoutResult$LogoutFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public record LogoutSuccessful() implements LogoutResult
        {
        }
    }

    public record JbaOAuthProvider(@NotNull String id, @NlsSafe @NotNull String name, @NotNull String logoUrl, @NotNull String logoDarkUrl) {
        @NotNull
        private final String id;
        @NlsSafe
        @NotNull
        private final String name;
        @NotNull
        private final String logoUrl;
        @NotNull
        private final String logoDarkUrl;

        public JbaOAuthProvider(@NotNull String id2, @NlsSafe @NotNull String name2, @NotNull String logoUrl, @NotNull String logoDarkUrl) {
            if (id2 == null) {
                JbaOAuthProvider.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                JbaOAuthProvider.$$$reportNull$$$0(1);
            }
            if (logoUrl == null) {
                JbaOAuthProvider.$$$reportNull$$$0(2);
            }
            if (logoDarkUrl == null) {
                JbaOAuthProvider.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public String id() {
            String string = this.id;
            if (string == null) {
                JbaOAuthProvider.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                JbaOAuthProvider.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String logoUrl() {
            String string = this.logoUrl;
            if (string == null) {
                JbaOAuthProvider.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String logoDarkUrl() {
            String string = this.logoDarkUrl;
            if (string == null) {
                JbaOAuthProvider.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logoUrl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logoDarkUrl";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/JBAccountInfoService$JbaOAuthProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/JBAccountInfoService$JbaOAuthProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "id";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logoUrl";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logoDarkUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public record JbaServiceConfiguration(@NotNull String accountUrl, @NotNull String signupUrl, @Nullable String paymentMethodsUrl, @NotNull @NotNull List<@NotNull JbaOAuthProvider> authProviders) {
        @NotNull
        private final String accountUrl;
        @NotNull
        private final String signupUrl;
        @NotNull
        private final @NotNull List<@NotNull JbaOAuthProvider> authProviders;

        public JbaServiceConfiguration(@NotNull String accountUrl, @NotNull String signupUrl, @Nullable String paymentMethodsUrl, @NotNull @NotNull List<@NotNull JbaOAuthProvider> authProviders) {
            if (accountUrl == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(0);
            }
            if (signupUrl == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(1);
            }
            if (authProviders == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public String accountUrl() {
            String string = this.accountUrl;
            if (string == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String signupUrl() {
            String string = this.signupUrl;
            if (string == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public @NotNull List<@NotNull JbaOAuthProvider> authProviders() {
            List<JbaOAuthProvider> list2 = this.authProviders;
            if (list2 == null) {
                JbaServiceConfiguration.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accountUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signupUrl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authProviders";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/JBAccountInfoService$JbaServiceConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/JBAccountInfoService$JbaServiceConfiguration";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "accountUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "signupUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "authProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

