/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefBrowserBuilder {
    @Nullable
    JBCefClient myClient;
    @Nullable
    String myUrl;
    @Nullable
    CefBrowser myCefBrowser;
    @Nullable
    JBCefOSRHandlerFactory myOSRHandlerFactory;
    boolean myIsOffScreenRendering = RegistryManager.getInstance().is("ide.browser.jcef.osr.enabled") || JBCefApp.getInstance().isRemoteEnabled();
    boolean myCreateImmediately;
    boolean myEnableOpenDevToolsMenuItem;
    boolean myMouseWheelEventEnable = true;
    int myWindowlessFrameRate = RegistryManager.getInstance().intValue("ide.browser.jcef.osr.framerate", 0);

    @NotNull
    public JBCefBrowserBuilder setOffScreenRendering(boolean isOffScreenRendering) {
        if (!isOffScreenRendering && JBCefApp.getInstance().isRemoteEnabled()) {
            Logger.getInstance(JBCefBrowserBuilder.class).warn("Trying to create windowed browser when remote-mode is enabled. Settings isOffScreenRendering=false will be ignored.");
            this.myIsOffScreenRendering = true;
            JBCefBrowserBuilder jBCefBrowserBuilder = this;
            if (jBCefBrowserBuilder == null) {
                JBCefBrowserBuilder.$$$reportNull$$$0(0);
            }
            return jBCefBrowserBuilder;
        }
        this.myIsOffScreenRendering = isOffScreenRendering;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(1);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setClient(@Nullable JBCefClient client2) {
        this.myClient = client2;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(2);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setUrl(@Nullable String url) {
        this.myUrl = url;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(3);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setCefBrowser(@Nullable CefBrowser browser) {
        this.myCefBrowser = browser;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(4);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setCreateImmediately(boolean createImmediately) {
        this.myCreateImmediately = createImmediately;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(5);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setOSRHandlerFactory(@Nullable JBCefOSRHandlerFactory factory2) {
        this.myOSRHandlerFactory = factory2;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(6);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setEnableOpenDevToolsMenuItem(boolean enableOpenDevToolsMenuItem) {
        this.myEnableOpenDevToolsMenuItem = enableOpenDevToolsMenuItem;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(7);
        }
        return jBCefBrowserBuilder;
    }

    @Deprecated
    @NotNull
    public JBCefBrowser createBrowser() {
        JBCefBrowser jBCefBrowser = this.build();
        if (jBCefBrowser == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(8);
        }
        return jBCefBrowser;
    }

    @NotNull
    public JBCefBrowser build() {
        JBCefBrowser jBCefBrowser = JBCefBrowser.create(this);
        if (jBCefBrowser == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(9);
        }
        return jBCefBrowser;
    }

    @NotNull
    public JBCefBrowserBuilder setMouseWheelEventEnable(boolean mouseWheelEventEnable) {
        this.myMouseWheelEventEnable = mouseWheelEventEnable;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(10);
        }
        return jBCefBrowserBuilder;
    }

    @NotNull
    public JBCefBrowserBuilder setWindowlessFramerate(int framerate) {
        this.myWindowlessFrameRate = framerate;
        JBCefBrowserBuilder jBCefBrowserBuilder = this;
        if (jBCefBrowserBuilder == null) {
            JBCefBrowserBuilder.$$$reportNull$$$0(11);
        }
        return jBCefBrowserBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/jcef/JBCefBrowserBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setOffScreenRendering";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setCefBrowser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setCreateImmediately";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setOSRHandlerFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setEnableOpenDevToolsMenuItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createBrowser";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setMouseWheelEventEnable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setWindowlessFramerate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

