/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefAppArmorUtils;
import com.intellij.ui.jcef.JBCefNotifications;
import com.intellij.util.messages.Topic;
import java.util.concurrent.atomic.AtomicReference;
import org.cef.CefSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class JBCefHealthMonitor {
    private static final Logger LOG = Logger.getInstance(JBCefHealthMonitor.class);
    private static final JBCefHealthMonitor ourInstance = new JBCefHealthMonitor();
    @NotNull
    private final AtomicReference<Status> myStatus = new AtomicReference<Status>(Status.UNKNOWN);

    public static JBCefHealthMonitor getInstance() {
        return ourInstance;
    }

    @NotNull
    public Status getStatus() {
        Status status2 = this.myStatus.get();
        if (status2 == null) {
            JBCefHealthMonitor.$$$reportNull$$$0(0);
        }
        return status2;
    }

    boolean isReady() {
        return this.myStatus.get() != Status.UNKNOWN;
    }

    void performHealthCheckAsync(CefSettings settings, Runnable onHealthCheckCompleted) {
        assert (this.getStatus() == Status.UNKNOWN);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.performHealthCheckImpl(settings);
            assert (this.getStatus() != Status.UNKNOWN);
            if (this.getStatus() != Status.OK) {
                ((JBCefHealthCheckTopic)ApplicationManager.getApplication().getMessageBus().syncPublisher(JBCefHealthCheckTopic.TOPIC)).onHealthHealthStatusChanged(this.getStatus());
                if (this.myStatus.get() == Status.UNPRIVILEGED_USER_NS_DISABLED) {
                    JBCefNotifications.showAppArmorNotification();
                }
                return;
            }
            onHealthCheckCompleted.run();
        });
    }

    void onGpuProcessFailed() {
        if (this.myStatus.compareAndSet(Status.UNKNOWN, Status.GPU_PROCESS_FAILED)) {
            ((JBCefHealthCheckTopic)ApplicationManager.getApplication().getMessageBus().syncPublisher(JBCefHealthCheckTopic.TOPIC)).onHealthHealthStatusChanged(this.getStatus());
        }
    }

    private void performHealthCheckImpl(CefSettings settings) {
        if (SystemInfoRt.isLinux) {
            if (!settings.no_sandbox && JBCefAppArmorUtils.areUnprivilegedUserNamespacesRestricted()) {
                this.myStatus.compareAndSet(Status.UNKNOWN, Status.UNPRIVILEGED_USER_NS_DISABLED);
                return;
            }
            if (JBCefHealthMonitor.isRunUnderUnixSuperuser() && !Registry.is((String)"ide.browser.jcef.run-under-superuser.allowed")) {
                this.myStatus.compareAndSet(Status.UNKNOWN, Status.RUN_UNDER_SUPER_USER);
                return;
            }
        }
        this.myStatus.compareAndSet(Status.UNKNOWN, Status.OK);
    }

    private static boolean isRunUnderUnixSuperuser() {
        if (!SystemInfoRt.isUnix) {
            return false;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath("id").withParameters(new String[]{"-u"});
        try {
            CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler2.runProcess();
            if (output.getExitCode() != 0) {
                LOG.warn("Failed to run 'id -u': " + output.getStderr());
                return false;
            }
            if (output.getStdout().strip().equals("0")) {
                LOG.warn("The IDE is run under superuser.");
                return true;
            }
            return false;
        }
        catch (ExecutionException ex) {
            LOG.warn("Failed to check the user id: " + ex.getMessage());
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/jcef/JBCefHealthMonitor", "getStatus"));
    }

    public static enum Status {
        UNKNOWN,
        OK,
        UNPRIVILEGED_USER_NS_DISABLED,
        RUN_UNDER_SUPER_USER,
        GPU_PROCESS_FAILED;

    }

    public static interface JBCefHealthCheckTopic {
        public static final Topic<JBCefHealthCheckTopic> TOPIC = Topic.create((String)"JBCefHealthCheckTopic", JBCefHealthCheckTopic.class);

        public void onHealthHealthStatusChanged(@NotNull Status var1);
    }
}

