/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.popup.HeavyWeightPopup;
import com.intellij.ui.popup.PopupComponent;
import com.intellij.ui.popup.PopupComponentFactory;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/popup/LocalPopupComponentFactory;", "Lcom/intellij/ui/popup/PopupComponentFactory;", "<init>", "()V", "createPopupComponent", "Lcom/intellij/ui/popup/PopupComponent;", "type", "Lcom/intellij/ui/popup/PopupComponentFactory$PopupType;", "owner", "Ljava/awt/Component;", "content", "x", "", "y", "jbPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "DialogPopupWrapper", "AwtPopupWrapper", "intellij.platform.ide.impl"})
public class LocalPopupComponentFactory
implements PopupComponentFactory {
    @Override
    @NotNull
    public PopupComponent createPopupComponent(@NotNull PopupComponentFactory.PopupType type, @NotNull Component owner, @NotNull Component content2, int x, int y, @NotNull JBPopup jbPopup) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)jbPopup, (String)"jbPopup");
        if (type == PopupComponentFactory.PopupType.DIALOG) {
            return new DialogPopupWrapper(owner, content2, x, y, jbPopup);
        }
        PopupFactory factory2 = PopupFactory.getSharedInstance();
        int oldType = PopupUtil.getPopupType((PopupFactory)factory2);
        if (type == PopupComponentFactory.PopupType.HEAVYWEIGHT) {
            PopupUtil.setPopupType((PopupFactory)factory2, (int)2);
        }
        Popup popup2 = factory2.getPopup(owner, content2, x, y);
        if (oldType >= 0) {
            PopupUtil.setPopupType((PopupFactory)factory2, (int)oldType);
        }
        Intrinsics.checkNotNull((Object)popup2);
        return new AwtPopupWrapper(popup2, jbPopup);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/popup/LocalPopupComponentFactory$AwtPopupWrapper;", "Lcom/intellij/ui/popup/PopupComponent;", "popup", "Ljavax/swing/Popup;", "myJBPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "<init>", "(Ljavax/swing/Popup;Lcom/intellij/openapi/ui/popup/JBPopup;)V", "hide", "", "dispose", "", "show", "getWindow", "Ljava/awt/Window;", "setRequestFocus", "requestFocus", "Companion", "intellij.platform.ide.impl"})
    public static final class AwtPopupWrapper
    implements PopupComponent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Popup popup;
        @NotNull
        private final JBPopup myJBPopup;

        public AwtPopupWrapper(@NotNull Popup popup2, @NotNull JBPopup myJBPopup) {
            Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
            Intrinsics.checkNotNullParameter((Object)myJBPopup, (String)"myJBPopup");
            this.popup = popup2;
            this.myJBPopup = myJBPopup;
        }

        @Override
        public void hide(boolean dispose) {
            Window window = this.getWindow();
            if (!dispose) {
                ThreadContext.resetThreadContext(() -> AwtPopupWrapper.hide$lambda$0(window));
                return;
            }
            RootPaneContainer rootPaneContainer = window instanceof RootPaneContainer ? (RootPaneContainer)((Object)window) : null;
            JRootPane rootPane = rootPaneContainer != null ? rootPaneContainer.getRootPane() : null;
            this.popup.hide();
            DialogWrapper.cleanupRootPane((JRootPane)rootPane);
            DialogWrapper.cleanupWindowListeners((Window)window);
        }

        @Override
        public void show() {
            Window window = this.getWindow();
            if (window != null) {
                Companion.fixFlickering$intellij_platform_ide_impl(window, false);
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("JBPopup", this.myJBPopup);
                }
            }
            this.popup.show();
            if (window != null) {
                Companion.fixFlickering$intellij_platform_ide_impl(window, true);
            }
        }

        @Override
        @Nullable
        public Window getWindow() {
            Popup popup2 = this.popup;
            HeavyWeightPopup heavyWeightPopup = popup2 instanceof HeavyWeightPopup ? (HeavyWeightPopup)popup2 : null;
            Window window = heavyWeightPopup != null ? heavyWeightPopup.getWindow() : null;
            return window instanceof JWindow ? (JWindow)window : null;
        }

        @Override
        public void setRequestFocus(boolean requestFocus) {
        }

        private static final Unit hide$lambda$0(Window $window) {
            block0: {
                Window window = $window;
                if (window == null) break block0;
                window.setVisible(false);
            }
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/popup/LocalPopupComponentFactory$AwtPopupWrapper$Companion;", "", "<init>", "()V", "fixFlickering", "", "window", "Ljava/awt/Window;", "opaque", "", "fixFlickering$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public final void fixFlickering$intellij_platform_ide_impl(@NotNull Window window, boolean opaque) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                try {
                    if (StartupUiUtil.isUnderDarcula() && SystemInfoRt.isMac && Registry.Companion.is("darcula.fix.native.flickering", false)) {
                        window.setOpacity(opaque ? 1.0f : 0.0f);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/popup/LocalPopupComponentFactory$DialogPopupWrapper;", "Lcom/intellij/ui/popup/PopupComponent;", "owner", "Ljava/awt/Component;", "content", "x", "", "y", "jbPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "<init>", "(Ljava/awt/Component;Ljava/awt/Component;IILcom/intellij/openapi/ui/popup/JBPopup;)V", "myDialog", "Ljavax/swing/JDialog;", "myRequestFocus", "", "setRequestFocus", "", "requestFocus", "getWindow", "Ljava/awt/Window;", "hide", "dispose", "show", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalPopupComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPopupComponentFactory.kt\ncom/intellij/ui/popup/LocalPopupComponentFactory$DialogPopupWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
    public static final class DialogPopupWrapper
    implements PopupComponent {
        @NotNull
        private final JDialog myDialog;
        private boolean myRequestFocus;

        public DialogPopupWrapper(@NotNull Component owner, @NotNull Component content2, int x, int y, @NotNull JBPopup jbPopup) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)jbPopup, (String)"jbPopup");
            this.myRequestFocus = true;
            if (!UIUtil.isShowing((Component)owner)) {
                boolean bl = false;
                String string = "Popup owner must be showing, owner " + owner.getClass();
                throw new IllegalArgumentException(string.toString());
            }
            Window window = ComponentUtil.getWindow((Component)owner);
            Window window2 = window;
            this.myDialog = window2 instanceof Frame ? new JDialog((Frame)window) : (window2 instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
            this.myDialog.getContentPane().setLayout(new BorderLayout());
            this.myDialog.getContentPane().add(content2, "Center");
            this.myDialog.getRootPane().putClientProperty("JBPopup", jbPopup);
            this.myDialog.getRootPane().setWindowDecorationStyle(0);
            this.myDialog.setUndecorated(true);
            this.myDialog.setBackground(UIUtil.getPanelBackground());
            this.myDialog.pack();
            this.myDialog.setLocation(x, y);
        }

        @Override
        public void setRequestFocus(boolean requestFocus) {
            this.myRequestFocus = requestFocus;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return this.myDialog;
        }

        @Override
        public void hide(boolean dispose) {
            this.myDialog.setVisible(false);
            if (dispose) {
                this.myDialog.dispose();
                this.myDialog.getRootPane().putClientProperty("JBPopup", null);
            }
        }

        @Override
        public void show() {
            if (!this.myRequestFocus) {
                this.myDialog.setFocusableWindowState(false);
            }
            AwtPopupWrapper.Companion.fixFlickering$intellij_platform_ide_impl(this.myDialog, false);
            this.myDialog.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ DialogPopupWrapper this$0;
                {
                    this.this$0 = $receiver;
                }

                public void windowClosed(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DialogPopupWrapper.access$getMyDialog$p(this.this$0).removeWindowListener(this);
                }
            });
            this.myDialog.setVisible(true);
            AwtPopupWrapper.Companion.fixFlickering$intellij_platform_ide_impl(this.myDialog, true);
            SwingUtilities.invokeLater(() -> DialogPopupWrapper.show$lambda$0(this));
        }

        private static final void show$lambda$0(DialogPopupWrapper this$0) {
            this$0.myDialog.setFocusableWindowState(true);
        }

        public static final /* synthetic */ JDialog access$getMyDialog$p(DialogPopupWrapper $this) {
            return $this.myDialog;
        }
    }
}

