/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.javac.JpsFileObject;

final class FileObjectKindFilter<T> {
    private final Function<? super T, String> myToNameConverter;
    private final Map<JavaFileObject.Kind, Predicate<T>> myFilterMap;

    FileObjectKindFilter(Function<? super T, String> toNameConverter) {
        this.myToNameConverter = toNameConverter;
        EnumMap<JavaFileObject.Kind, Predicate<Object>> filterMap = new EnumMap<JavaFileObject.Kind, Predicate<Object>>(JavaFileObject.Kind.class);
        for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (kind == JavaFileObject.Kind.OTHER) {
                filterMap.put(kind, data -> JpsFileObject.findKind(this.myToNameConverter.apply(data)) == JavaFileObject.Kind.OTHER);
                continue;
            }
            filterMap.put(kind, data -> {
                String name = this.myToNameConverter.apply(data);
                return name.regionMatches(true, name.length() - kind.extension.length(), kind.extension, 0, kind.extension.length());
            });
        }
        this.myFilterMap = Collections.unmodifiableMap(filterMap);
    }

    public Predicate<T> getFor(Set<JavaFileObject.Kind> kinds) {
        Iterator<JavaFileObject.Kind> it = kinds.iterator();
        if (it.hasNext()) {
            JavaFileObject.Kind kind = it.next();
            if (!it.hasNext()) {
                return this.myFilterMap.get((Object)kind);
            }
        }
        return data -> {
            for (JavaFileObject.Kind kind : kinds) {
                if (!this.myFilterMap.get((Object)kind).test(data)) continue;
                return true;
            }
            return false;
        };
    }
}

