/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class Iterators {
    public static boolean isEmpty(Iterable<?> iterable) {
        return Iterators.isEmptyCollection(iterable) || !iterable.iterator().hasNext();
    }

    public static boolean isEmptyCollection(Iterable<?> iterable) {
        return iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
    }

    public static <T> boolean contains(Iterable<? extends T> iterable, @NotNull T obj) {
        if (obj == null) {
            Iterators.$$$reportNull$$$0(0);
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(obj);
        }
        if (iterable != null) {
            for (T o : iterable) {
                if (!obj.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static int count(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int count = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> cond) {
        if (iterable != null) {
            for (T o : iterable) {
                if (!cond.test(o)) continue;
                return o;
            }
        }
        return null;
    }

    public static <C extends Collection<? super T>, T> C collect(Iterable<? extends T> iterable, C acc) {
        return Iterators.collect(iterable != null ? iterable.iterator() : null, acc);
    }

    public static <C extends Collection<? super T>, T> C collect(Iterator<? extends T> it, C acc) {
        if (it != null) {
            while (it.hasNext()) {
                acc.add(it.next());
            }
        }
        return acc;
    }

    public static <T> Iterable<T> lazyIterable(Supplier<? extends Iterable<T>> provider) {
        Supplier delegate = Iterators.cachedValue(provider);
        return () -> ((Iterable)delegate.get()).iterator();
    }

    public static <T> Iterator<T> lazyIterator(final Supplier<? extends Iterator<T>> provider) {
        return new Iterator<T>(){
            private final Supplier<? extends Iterator<T>> delegate;
            {
                this.delegate = Iterators.cachedValue(provider);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.get().hasNext();
            }

            @Override
            public T next() {
                return this.delegate.get().next();
            }
        };
    }

    public static <T> Iterable<T> flat(Iterable<? extends T> first, Iterable<? extends T> second) {
        if (Iterators.isEmptyCollection(first)) {
            return Iterators.isEmptyCollection(second) ? Collections.emptyList() : second;
        }
        if (Iterators.isEmptyCollection(second)) {
            return first;
        }
        return () -> Iterators.flat(first.iterator(), second.iterator());
    }

    public static <T> Iterator<T> flat(final Iterator<? extends T> first, final Iterator<? extends T> second) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return first.hasNext() || second.hasNext();
            }

            @Override
            public T next() {
                return first.hasNext() ? first.next() : second.next();
            }
        };
    }

    public static <T> Iterable<T> flat(Collection<? extends Iterable<? extends T>> parts) {
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        if (parts.size() == 1) {
            return parts.iterator().next();
        }
        return Iterators.flat(parts);
    }

    public static <T> Iterable<T> flat(Iterable<? extends Iterable<? extends T>> parts) {
        return Iterators.isEmptyCollection(parts) ? Collections.emptyList() : () -> Iterators.flat(Iterators.map(parts.iterator(), Iterators::asIterator));
    }

    public static <T> Iterator<T> flat(final Iterator<? extends Iterator<T>> groupsIterator) {
        return new Iterator<T>(){
            private Iterator<T> currentGroup;

            @Override
            public boolean hasNext() {
                return this.findNext() != null;
            }

            @Override
            public T next() {
                Iterator group = this.findNext();
                if (group != null) {
                    return group.next();
                }
                throw new NoSuchElementException();
            }

            private Iterator<T> findNext() {
                if (this.currentGroup == null || !this.currentGroup.hasNext()) {
                    do {
                        Iterator iterator = this.currentGroup = groupsIterator.hasNext() ? (Iterator)groupsIterator.next() : null;
                    } while (this.currentGroup != null && !this.currentGroup.hasNext());
                }
                return this.currentGroup;
            }
        };
    }

    public static <I> Iterator<I> asIterator(Iterable<? extends I> from) {
        return from == null ? Collections.emptyIterator() : from.iterator();
    }

    public static <T> Iterable<T> asIterable(T elem) {
        return () -> Iterators.asIterator(elem);
    }

    public static <T> Iterable<T> asIterable(T[] elem) {
        return elem == null ? Collections.emptyList() : Arrays.asList(elem);
    }

    public static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final ListIterator li = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return li.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return li.previous();
                    }
                };
            }
        };
    }

    public static <T> Iterator<T> asIterator(final T elem) {
        return new Iterator<T>(){
            private boolean available = true;

            @Override
            public boolean hasNext() {
                return this.available;
            }

            @Override
            public T next() {
                if (this.available) {
                    this.available = false;
                    return elem;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <I, O> Iterable<O> map(Iterable<? extends I> from, Function<? super I, ? extends O> mapper) {
        return Iterators.isEmptyCollection(from) ? Collections.emptyList() : () -> Iterators.map(from.iterator(), mapper);
    }

    public static <I, O> Iterator<O> map(final Iterator<? extends I> it, final Function<? super I, ? extends O> mapper) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public O next() {
                return mapper.apply(it.next());
            }
        };
    }

    public static <T> Iterable<T> filter(Iterable<? extends T> it, Predicate<? super T> predicate) {
        return Iterators.isEmptyCollection(it) ? Collections.emptyList() : () -> Iterators.filter(it.iterator(), predicate);
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> it, final Predicate<? super T> predicate) {
        return new Iterator<T>(){
            private T current = null;
            private boolean isPending = false;

            @Override
            public boolean hasNext() {
                if (!this.isPending) {
                    this.findNext();
                }
                return this.isPending;
            }

            @Override
            public T next() {
                try {
                    if (!this.isPending) {
                        this.findNext();
                        if (!this.isPending) {
                            throw new NoSuchElementException();
                        }
                    }
                    Object t = this.current;
                    return t;
                }
                finally {
                    this.current = null;
                    this.isPending = false;
                }
            }

            private void findNext() {
                this.isPending = false;
                this.current = null;
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!predicate.test(next)) continue;
                    this.isPending = true;
                    this.current = next;
                    break;
                }
            }
        };
    }

    public static <T> Iterable<T> filterWithOrder(Iterable<? extends T> from, Iterable<? extends Predicate<? super T>> predicates) {
        return Iterators.isEmptyCollection(predicates) || Iterators.isEmptyCollection(from) ? Collections.emptyList() : () -> Iterators.filterWithOrder(from.iterator(), predicates.iterator());
    }

    public static <T> Iterator<T> filterWithOrder(final Iterator<? extends T> from, Iterator<? extends Predicate<? super T>> predicates) {
        return Iterators.flat(Iterators.map(predicates, new Function<Predicate<? super T>, Iterator<T>>(){
            final List<T> buffer = new LinkedList();

            @Override
            public Iterator<T> apply(Predicate<? super T> pred) {
                if (!this.buffer.isEmpty()) {
                    Iterator it = this.buffer.iterator();
                    while (it.hasNext()) {
                        Object elem = it.next();
                        if (!pred.test(elem)) continue;
                        it.remove();
                        return Iterators.asIterator(elem);
                    }
                }
                while (from.hasNext()) {
                    Object elem = from.next();
                    if (pred.test(elem)) {
                        return Iterators.asIterator(elem);
                    }
                    this.buffer.add(elem);
                }
                this.buffer.clear();
                return Collections.emptyIterator();
            }
        }));
    }

    public static <T> Iterable<T> unique(Iterable<? extends T> it) {
        return Iterators.isEmptyCollection(it) ? Collections.emptyList() : () -> Iterators.unique(it.iterator());
    }

    public static <T> Iterator<T> unique(Iterator<? extends T> it) {
        Supplier<Set> processed = Iterators.cachedValue(HashSet::new);
        return Iterators.filter(it, (? super T e) -> ((Set)processed.get()).add(e));
    }

    public static <T> Iterable<T> uniqueBy(Iterable<? extends T> it, Supplier<? extends Predicate<T>> predicateFactory) {
        return Iterators.isEmptyCollection(it) ? Collections.emptyList() : () -> Iterators.filter(it.iterator(), (Predicate)predicateFactory.get());
    }

    public static <T> boolean equals(Iterable<? extends T> s1, Iterable<? extends T> s2) {
        return Iterators.equals(s1, s2, Object::equals);
    }

    public static <T> boolean equals(Iterable<? extends T> s1, Iterable<? extends T> s2, BiFunction<? super T, ? super T, Boolean> comparator) {
        Iterator<T> it2 = s2.iterator();
        for (T elem : s1) {
            if (!it2.hasNext()) {
                return false;
            }
            if (comparator.apply(elem, it2.next()).booleanValue()) continue;
            return false;
        }
        return !it2.hasNext();
    }

    public static <T> int hashCode(Iterable<? extends T> s) {
        int result = 1;
        for (T elem : s) {
            result = 31 * result + (elem == null ? 0 : elem.hashCode());
        }
        return result;
    }

    public static <T> Iterable<T> recurse(final T item, final Function<? super T, ? extends Iterable<? extends T>> step, final boolean includeHead) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = (new Object(){
                    private final Set<T> traversed = new HashSet();

                    private Iterator<T> recurse(T elem, boolean includeHead) {
                        if (!this.traversed.add(elem)) {
                            return Collections.emptyIterator();
                        }
                        if (!includeHead) {
                            return this.tailOf(elem);
                        }
                        return Iterators.flat(Iterators.asIterator(elem), Iterators.lazyIterator(() -> this.tailOf(elem)));
                    }

                    @NotNull
                    private Iterator<T> tailOf(T elem) {
                        Iterable<Object> tail = Iterators.filter((Iterable)step.apply(elem), e -> !this.traversed.contains(e));
                        Iterator<Object> iterator = Iterators.flat(tail.iterator(), Iterators.flat(Iterators.map(tail.iterator(), e -> this.recurse(e, false))));
                        if (iterator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return iterator;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/util/Iterators$9$1", "tailOf"));
                    }
                }).recurse(item, includeHead);
                if (iterator == null) {
                    9.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/util/Iterators$9", "iterator"));
            }
        };
    }

    public static <T> Iterable<T> recurseDepth(final T item, final Function<? super T, ? extends Iterable<? extends T>> step, final boolean includeHead) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = (new Object(){
                    private final Set<T> visited = new HashSet();

                    private Iterator<T> recurse(T elem, boolean includeHead) {
                        if (!this.visited.add(elem)) {
                            return Collections.emptyIterator();
                        }
                        if (!includeHead) {
                            return Iterators.flat(Iterators.map(((Iterable)step.apply(elem)).iterator(), e -> this.recurse(e, true)));
                        }
                        Iterator tail = Iterators.lazyIterator(() -> ((Iterable)step.apply(elem)).iterator());
                        return Iterators.flat(Iterators.asIterator(elem), Iterators.flat(Iterators.map(tail, e -> this.recurse(e, true))));
                    }
                }).recurse(item, includeHead);
                if (iterator == null) {
                    10.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/util/Iterators$10", "iterator"));
            }
        };
    }

    private static <V> Supplier<V> cachedValue(final Supplier<V> valueFactory) {
        return new Supplier<V>(){
            private Object[] computed;

            @Override
            public V get() {
                Object object;
                if (this.computed == null) {
                    this.computed = new Object[]{valueFactory.get()};
                    object = this.computed[0];
                } else {
                    object = this.computed[0];
                }
                return object;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/jps/util/Iterators", "contains"));
    }
}

